/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class EdgeList
implements Iterable<Edge> {
    private Edge[] list;
    private int size;

    public EdgeList() {
        this(10);
    }

    public EdgeList(int n) {
        this.list = new Edge[n];
        this.size = 0;
    }

    public EdgeList(EdgeList edgeList) {
        this(edgeList.size);
        this.addEdgeList(edgeList);
    }

    public EdgeList(Edge edge) {
        this.list = new Edge[1];
        this.list[0] = edge;
        this.size = 0;
    }

    private void allocate(int n) {
        int n2 = this.list.length;
        if (n > n2) {
            Edge[] edgeArray = this.list;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.list = new Edge[n3];
            System.arraycopy(edgeArray, 0, this.list, 0, n2);
        }
    }

    public void addEdgeList(EdgeList edgeList) {
        int n = edgeList.size;
        this.allocate(this.size + n);
        System.arraycopy(edgeList.list, 0, this.list, this.size, n);
        this.size += n;
    }

    public void addEdge(Edge edge) {
        this.allocate(this.size + 1);
        this.list[this.size++] = edge;
    }

    public boolean removeEdge(Edge edge) {
        for (int i = 0; i < this.size; ++i) {
            Edge edge2 = this.list[i];
            if (!edge2.equals(edge)) continue;
            this.removeEdge(i);
            return true;
        }
        return false;
    }

    protected void removeEdge(int n) {
        this.list[n] = this.list[--this.size];
        this.list[this.size] = null;
    }

    public Edge edgeAt(int n) {
        return this.list[n];
    }

    public int size() {
        return this.size;
    }

    public EdgeList sort() {
        EdgeList edgeList = new EdgeList(this);
        Arrays.sort(edgeList.list, new Comparator<Edge>(){

            @Override
            public int compare(Edge edge, Edge edge2) {
                return edge.getDepends().max() - edge2.getDepends().max();
            }
        });
        return edgeList;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new EdgeIterator();
    }

    private EdgeList findEdges(Role role, Individual individual, Node node) {
        EdgeList edgeList = new EdgeList();
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (individual != null && !individual.equals(edge.getFrom()) || role != null && !edge.getRole().isSubRoleOf(role) || node != null && !node.equals(edge.getTo())) continue;
            edgeList.addEdge(edge);
        }
        return edgeList;
    }

    public EdgeList getEdgesFromTo(Individual individual, Node node) {
        return this.findEdges(null, individual, node);
    }

    public EdgeList getEdgesFrom(Individual individual) {
        return this.findEdges(null, individual, null);
    }

    public EdgeList getEdgesTo(Node node) {
        return this.findEdges(null, null, node);
    }

    public EdgeList getEdgesTo(Role role, Node node) {
        return this.findEdges(role, null, node);
    }

    public EdgeList getEdgesFrom(Individual individual, Role role) {
        return this.findEdges(role, individual, null);
    }

    public EdgeList getEdges(Role role) {
        EdgeList edgeList = new EdgeList();
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (!edge.getRole().isSubRoleOf(role)) continue;
            edgeList.addEdge(edge);
        }
        return edgeList;
    }

    public Set<Role> getRoles() {
        HashSet<Role> hashSet = new HashSet<Role>();
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            hashSet.add(edge.getRole());
        }
        return hashSet;
    }

    public Set<Node> getNeighbors(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            hashSet.add(edge.getNeighbor(node));
        }
        return hashSet;
    }

    public Set<Node> getFilteredNeighbors(Individual individual, ATermAppl aTermAppl) {
        HashSet<Node> hashSet = new HashSet<Node>();
        String string = null;
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            Node node = edge.getNeighbor(individual);
            if (!ATermUtils.isTop(aTermAppl) && !node.hasType((ATerm)aTermAppl)) continue;
            if (node instanceof Literal) {
                Literal literal = (Literal)node;
                if (string == null) {
                    string = literal.getLang();
                    hashSet.add(node);
                    continue;
                }
                if (!string.equals(literal.getLang())) continue;
                hashSet.add(node);
                continue;
            }
            hashSet.add(node);
        }
        return hashSet;
    }

    public boolean hasEdgeFrom(Individual individual) {
        return this.hasEdge(individual, null, null);
    }

    public boolean hasEdgeFrom(Individual individual, Role role) {
        return this.hasEdge(individual, role, null);
    }

    public boolean hasEdgeTo(Node node) {
        return this.hasEdge(null, null, node);
    }

    public boolean hasEdgeTo(Role role, Node node) {
        return this.hasEdge(null, role, node);
    }

    public boolean hasEdge(Role role) {
        return this.hasEdge(null, role, null);
    }

    public boolean hasEdge(Individual individual, Role role, Node node) {
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (individual != null && !individual.equals(edge.getFrom()) || role != null && !edge.getRole().isSubRoleOf(role) || node != null && !node.equals(edge.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactEdge(Individual individual, Role role, Node node) {
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (individual != null && !individual.equals(edge.getFrom()) || role != null && !edge.getRole().equals(role) || node != null && !node.equals(edge.getTo())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Edge edge) {
        return this.hasEdge(edge.getFrom(), edge.getRole(), edge.getTo());
    }

    public Edge getExactEdge(Individual individual, Role role, Node node) {
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (individual != null && !individual.equals(edge.getFrom()) || role != null && !edge.getRole().equals(role) || node != null && !node.equals(edge.getTo())) continue;
            return edge;
        }
        return null;
    }

    public DependencySet getDepends(boolean bl) {
        DependencySet dependencySet = DependencySet.INDEPENDENT;
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            dependencySet = dependencySet.union(edge.getDepends(), bl);
        }
        return dependencySet;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.list[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.list[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            Edge edge = this.list[i];
            if (edge.getDepends().getBranch() == DependencySet.NO_BRANCH) continue;
            this.removeEdge(i--);
        }
    }

    private class EdgeIterator
    implements Iterator<Edge> {
        private int curr = 0;

        @Override
        public boolean hasNext() {
            return this.curr != EdgeList.this.size;
        }

        @Override
        public Edge next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return EdgeList.this.list[this.curr++];
        }

        @Override
        public void remove() {
            EdgeList.this.removeEdge(--this.curr);
        }
    }
}

