/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RDFModel {
    private List<String> m_Comments = CollectionUtil.makeList();
    private Map<String, String> m_Namespaces = CollectionUtil.makeMap();
    private List<Statement> m_AllStatements = CollectionUtil.makeList();
    private Map<Resource, Map<Property, Set<RDFNode>>> m_Statements = CollectionUtil.makeMap();
    private Map<Property, List<Statement>> m_StatementsByPredicate = CollectionUtil.makeMap();
    private Map<RDFNode, List<Statement>> m_StatementsByObject = CollectionUtil.makeMap();
    private Set<RDFNode> m_BNodes = CollectionUtil.makeSet();

    public void add(RDFModel rDFModel) {
        this.m_Comments.addAll(rDFModel.m_Comments);
        this.m_Namespaces.putAll(rDFModel.m_Namespaces);
        this.addAllStatements(rDFModel.getStatements());
        this.m_BNodes.addAll(rDFModel.m_BNodes);
    }

    public void add(Model model) {
        this.addAllStatements((Iterator<Statement>)model.listStatements());
    }

    public void addComment(String string) {
        this.m_Comments.add(string);
    }

    public List<String> getComments() {
        return this.m_Comments;
    }

    public void addNamespace(String string, String string2) {
        this.m_Namespaces.put(string, string2);
    }

    public Map<String, String> getNamespaces() {
        return this.m_Namespaces;
    }

    public void addAllStatements(Iterator<Statement> iterator) {
        while (iterator.hasNext()) {
            this.addStatement(iterator.next());
        }
    }

    public void addAllStatements(List<Statement> list) {
        this.addAllStatements(list.iterator());
    }

    public void addAllStatementsWithExistingBNodesOnly(List<Statement> list) {
        for (Statement statement : list) {
            RDFNode rDFNode;
            Resource resource = statement.getSubject();
            if (resource.isAnon() && !this.m_BNodes.contains(resource) || (rDFNode = statement.getObject()).isAnon() && !this.m_BNodes.contains(rDFNode)) continue;
            this.addStatement(statement);
        }
    }

    public void addStatement(Statement statement) {
        this.m_AllStatements.add(statement);
        this.addToStatements(statement);
        this.addToStatementsByPredicate(statement);
        this.addToStatementsByObject(statement);
        this.addToBNodes((RDFNode)statement.getSubject());
        this.addToBNodes(statement.getObject());
    }

    private void addToBNodes(RDFNode rDFNode) {
        if (rDFNode.isAnon()) {
            this.m_BNodes.add(rDFNode);
        }
    }

    public List<Statement> getStatements() {
        return this.m_AllStatements;
    }

    public Collection<Statement> getStatementsByPredicate(Property property) {
        List<Statement> list = this.m_StatementsByPredicate.get(property);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Collection<Statement> getStatementsByObject(RDFNode rDFNode) {
        List<Statement> list = this.m_StatementsByObject.get(rDFNode);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Collection<RDFNode> getValues(Resource resource, Property property) {
        Map<Property, Set<RDFNode>> map = this.m_Statements.get(resource);
        if (map == null) {
            return Collections.emptyList();
        }
        Set<RDFNode> set = map.get(property);
        if (set == null) {
            return Collections.emptyList();
        }
        return set;
    }

    public RDFNode getUniqueObject(Resource resource, Property property) {
        Collection<RDFNode> collection = this.getValues(resource, property);
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public boolean containsStatement(Resource resource, Property property, RDFNode rDFNode) {
        Collection<RDFNode> collection = this.getValues(resource, property);
        if (collection.isEmpty()) {
            return false;
        }
        return collection.contains(rDFNode);
    }

    private void addToStatements(Statement statement) {
        Set<Object> set;
        Resource resource = statement.getSubject();
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        Map<Object, Set<Object>> map = this.m_Statements.get(resource);
        if (map == null) {
            map = CollectionUtil.makeMap();
            this.m_Statements.put(resource, map);
        }
        if ((set = map.get(property)) == null) {
            set = CollectionUtil.makeSet();
            map.put(property, set);
        }
        set.add(rDFNode);
    }

    private void addToStatementsByPredicate(Statement statement) {
        Property property = statement.getPredicate();
        List<Object> list = this.m_StatementsByPredicate.get(property);
        if (list == null) {
            list = CollectionUtil.makeList();
            this.m_StatementsByPredicate.put(property, list);
        }
        list.add(statement);
    }

    private void addToStatementsByObject(Statement statement) {
        RDFNode rDFNode = statement.getObject();
        List<Object> list = this.m_StatementsByObject.get(rDFNode);
        if (list == null) {
            list = CollectionUtil.makeList();
            this.m_StatementsByObject.put(rDFNode, list);
        }
        list.add(statement);
    }
}

