/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.Facet;
import java.net.URI;
import org.mindswap.pellet.utils.ATermUtils;

public class TermFactory {
    public static final ATermAppl TOP = ATermUtils.TOP;
    public static final ATermAppl BOTTOM = ATermUtils.BOTTOM;
    public static final ATermAppl TOP_LIT = ATermUtils.TOP_LIT;
    public static final ATermAppl BOTTOM_LIT = ATermUtils.BOTTOM_LIT;
    public static final ATermAppl TOP_DATA_PROPERTY = ATermUtils.TOP_DATA_PROPERTY;
    public static final ATermAppl BOTTOM_DATA_PROPERTY = ATermUtils.BOTTOM_DATA_PROPERTY;
    public static final ATermAppl TOP_OBJECT_PROPERTY = ATermUtils.TOP_OBJECT_PROPERTY;
    public static final ATermAppl BOTTOM_OBJECT_PROPERTY = ATermUtils.BOTTOM_OBJECT_PROPERTY;

    public static ATermAppl term(String string) {
        return ATermUtils.makeTermAppl(string);
    }

    public static ATermAppl bnode(String string) {
        return ATermUtils.makeBnode(string);
    }

    public static ATermAppl var(String string) {
        return ATermUtils.makeVar(string);
    }

    public static ATermList list(ATermAppl ... aTermApplArray) {
        return ATermUtils.makeList((ATerm[])aTermApplArray);
    }

    public static ATermAppl not(ATermAppl aTermAppl) {
        return ATermUtils.makeNot((ATerm)aTermAppl);
    }

    public static ATermAppl all(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static ATermAppl some(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static ATermAppl min(ATermAppl aTermAppl, int n, ATermAppl aTermAppl2) {
        return ATermUtils.makeMin((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public static ATermAppl max(ATermAppl aTermAppl, int n, ATermAppl aTermAppl2) {
        return ATermUtils.makeMax((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public static ATermAppl card(ATermAppl aTermAppl, int n, ATermAppl aTermAppl2) {
        return ATermUtils.makeCard((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public static ATermAppl inv(ATermAppl aTermAppl) {
        return ATermUtils.makeInv(aTermAppl);
    }

    public static ATermAppl literal(boolean bl) {
        return ATermUtils.makeTypedLiteral(bl ? "true" : "false", Datatypes.BOOLEAN);
    }

    public static ATermAppl literal(byte by) {
        return ATermUtils.makeTypedLiteral(String.valueOf(by), Datatypes.BYTE);
    }

    public static ATermAppl literal(short s) {
        return ATermUtils.makeTypedLiteral(String.valueOf(s), Datatypes.SHORT);
    }

    public static ATermAppl literal(long l) {
        return ATermUtils.makeTypedLiteral(String.valueOf(l), Datatypes.LONG);
    }

    public static ATermAppl literal(int n) {
        return ATermUtils.makeTypedLiteral(String.valueOf(n), Datatypes.INTEGER);
    }

    public static ATermAppl literal(float f) {
        return ATermUtils.makeTypedLiteral(String.valueOf(f), Datatypes.FLOAT);
    }

    public static ATermAppl literal(double d) {
        return ATermUtils.makeTypedLiteral(String.valueOf(d), Datatypes.DOUBLE);
    }

    public static ATermAppl literal(URI uRI) {
        return ATermUtils.makeTypedLiteral(String.valueOf(uRI), Datatypes.ANY_URI);
    }

    public static ATermAppl literal(String string) {
        return ATermUtils.makePlainLiteral(string);
    }

    public static ATermAppl literal(String string, String string2) {
        return ATermUtils.makePlainLiteral(string, string2);
    }

    public static ATermAppl literal(String string, ATermAppl aTermAppl) {
        return ATermUtils.makeTypedLiteral(string, aTermAppl);
    }

    @Deprecated
    public static ATermAppl plainLiteral(String string, String string2) {
        return ATermUtils.makePlainLiteral(string, string2);
    }

    public static ATermAppl typedLiteral(String string, ATermAppl aTermAppl) {
        return ATermUtils.makeTypedLiteral(string, aTermAppl);
    }

    public static ATermAppl typedLiteral(String string, String string2) {
        return ATermUtils.makeTypedLiteral(string, string2);
    }

    public static ATermAppl value(ATermAppl aTermAppl) {
        return ATermUtils.makeValue((ATerm)aTermAppl);
    }

    public static ATermAppl and(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeAnd((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static ATermAppl and(ATermAppl ... aTermApplArray) {
        if (aTermApplArray.length == 1) {
            return aTermApplArray[0];
        }
        return ATermUtils.makeAnd(ATermUtils.makeList((ATerm[])aTermApplArray));
    }

    public static ATermAppl or(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeOr(aTermAppl, aTermAppl2);
    }

    public static ATermAppl or(ATermAppl ... aTermApplArray) {
        if (aTermApplArray.length == 1) {
            return aTermApplArray[0];
        }
        return ATermUtils.makeOr(ATermUtils.makeList((ATerm[])aTermApplArray));
    }

    public static ATermAppl hasValue(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public static ATermAppl oneOf(ATermAppl ... aTermApplArray) {
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        for (ATermAppl aTermAppl : aTermApplArray) {
            aTermList = aTermList.insert((ATerm)TermFactory.value(aTermAppl));
        }
        return ATermUtils.makeOr(aTermList);
    }

    public static ATermAppl self(ATermAppl aTermAppl) {
        return ATermUtils.makeSelf(aTermAppl);
    }

    public static ATermAppl minInclusive(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_INCLUSIVE.getName(), aTermAppl);
    }

    public static ATermAppl minExclusive(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_EXCLUSIVE.getName(), aTermAppl);
    }

    public static ATermAppl maxInclusive(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_INCLUSIVE.getName(), aTermAppl);
    }

    public static ATermAppl maxExclusive(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_EXCLUSIVE.getName(), aTermAppl);
    }

    public static ATermAppl minLength(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MIN_LENGTH.getName(), aTermAppl);
    }

    public static ATermAppl maxLength(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.MAX_LENGTH.getName(), aTermAppl);
    }

    public static ATermAppl length(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.LENGTH.getName(), aTermAppl);
    }

    public static ATermAppl pattern(ATermAppl aTermAppl) {
        return ATermUtils.makeFacetRestriction(Facet.XSD.PATTERN.getName(), aTermAppl);
    }

    public static ATermAppl restrict(ATermAppl aTermAppl, ATermAppl ... aTermApplArray) {
        return ATermUtils.makeRestrictedDatatype(aTermAppl, aTermApplArray);
    }
}

