/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.AbstractABoxEngineWrapper;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

public class OptimizedQueryEngine2
extends AbstractABoxEngineWrapper {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());
    private QueryResult results;
    private KnowledgeBase kb;

    @Override
    public boolean supports(Query query) {
        return !query.getDistVars().isEmpty();
    }

    private void exec(Query query, ResultBinding resultBinding, boolean bl) {
        Set<ATermAppl> set;
        if (query.getDistVars().isEmpty()) {
            this.results.add(resultBinding);
            return;
        }
        Iterator<ATermAppl> iterator = query.getDistVars().iterator();
        ATermAppl aTermAppl = iterator.next();
        Set<ATermAppl> set2 = Collections.emptySet();
        ATermAppl aTermAppl2 = query.rollUpTo(aTermAppl, set2, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Rolling up " + aTermAppl + " to " + aTermAppl2);
        }
        if (bl) {
            set = new HashSet<ATermAppl>(this.kb.getIndividuals());
            for (QueryAtom object : query.findAtoms(QueryPredicate.PropertyValue, aTermAppl, null, null)) {
                set.retainAll(this.kb.retrieveIndividualsWithProperty(object.getArguments().get(1)));
            }
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, null, null, aTermAppl)) {
                set.retainAll(this.kb.retrieveIndividualsWithProperty(ATermUtils.makeInv(queryAtom.getArguments().get(1))));
            }
        } else {
            set = this.kb.getInstances(aTermAppl2);
        }
        for (ATermAppl aTermAppl3 : set) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("trying " + aTermAppl + " --> " + aTermAppl3);
            }
            ResultBinding resultBinding2 = resultBinding.duplicate();
            resultBinding2.setValue(aTermAppl, aTermAppl3);
            Query query2 = query.apply(resultBinding2);
            this.exec(query2, resultBinding2, false);
        }
    }

    @Override
    public QueryResult execABoxQuery(Query query) {
        this.results = new QueryResultImpl(query);
        this.kb = query.getKB();
        long l = this.kb.getABox().stats.satisfiabilityCount;
        long l2 = this.kb.getABox().stats.consistencyCount;
        this.exec(query, new ResultBindingImpl(), true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Total satisfiability operations: " + (this.kb.getABox().stats.satisfiabilityCount - l));
            log.fine("Total consistency operations: " + (this.kb.getABox().stats.consistencyCount - l2));
            log.fine("Results of ABox query : " + this.results);
        }
        return this.results;
    }
}

