/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.RuleNode;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.rules.rete.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Pair;

public class BetaNode
extends Node {
    private boolean doExplanation;
    private boolean dirty;
    public Node lnode;
    public List<BetaNode> parents;
    public Node rnode;
    public RuleNode rule;

    public BetaNode(Node node, Node node2, boolean bl) {
        this.doExplanation = bl;
        this.lnode = node;
        this.rnode = node2;
        this.dirty = true;
        List<ATermAppl> list = Utils.getSharedVars(node, node2);
        node.svars = list;
        node2.svars = list;
        this.vars = Utils.concat(list, node.vars);
        this.vars = Utils.concat(this.vars, node2.vars);
        this.vars = Utils.removeDups(this.vars);
        this.parents = new ArrayList<BetaNode>();
        node.add(this);
        if (!node2.equals(node)) {
            node2.add(this);
        }
    }

    public HashMap<ATermAppl, ATermAppl> getBindings(List<ATermAppl> list) {
        HashMap<ATermAppl, ATermAppl> hashMap = new HashMap<ATermAppl, ATermAppl>();
        for (int i = 0; i < this.vars.size(); ++i) {
            hashMap.put((ATermAppl)this.vars.get(i), list.get(i));
        }
        return hashMap;
    }

    private ATermAppl getVar(ATermAppl aTermAppl, List<ATermAppl> list) {
        if (this.vars.contains(aTermAppl)) {
            int n = this.getKey().indexOf(aTermAppl);
            return list.get(n);
        }
        ABox.log.warning("Unbound rule variable: " + aTermAppl + this.vars);
        return null;
    }

    private int[] getVarPermutation() {
        List<ATermAppl> list = new ArrayList<ATermAppl>(this.lnode.getKey());
        list.addAll(this.rnode.getKey());
        list = Utils.removeDups(list);
        int[] nArray = new int[this.vars.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = this.getKeyPosition(list.get(i));
        }
        return nArray;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public List<Fact> join() {
        this.dirty = false;
        int[] nArray = this.getVarPermutation();
        ArrayList<Fact> arrayList = new ArrayList<Fact>();
        for (Pair<Fact, Fact> pair : this.lnode.index.join(this.rnode.index, this.lnode.svars.size())) {
            ArrayList arrayList2 = new ArrayList(nArray.length);
            arrayList2.addAll(((Fact)pair.first).getElements());
            if (this.rnode.vars.size() <= ((Fact)pair.second).getElements().size()) {
                arrayList2.addAll(((Fact)pair.second).getElements().subList(this.lnode.svars.size(), this.rnode.vars.size()));
            }
            ATermAppl[] aTermApplArray = new ATermAppl[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                aTermApplArray[nArray[i]] = (ATermAppl)arrayList2.get(i);
            }
            DependencySet dependencySet = ((Fact)pair.first).getDependencySet();
            dependencySet = dependencySet.union(((Fact)pair.second).getDependencySet(), this.doExplanation);
            List<ATermAppl> list = Arrays.asList(aTermApplArray);
            Fact fact = new Fact(dependencySet, list);
            arrayList.add(fact);
            this.index.add(list, fact);
        }
        return arrayList;
    }

    public void markDirty() {
        this.dirty = true;
        this.index.clear();
        for (BetaNode betaNode : this.getBetas()) {
            betaNode.markDirty();
        }
    }

    public Set<Fact> matchingFacts(TermTuple termTuple, List<Fact> list) {
        HashSet<Fact> hashSet = new HashSet<Fact>();
        for (Fact fact : list) {
            ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>(termTuple.getElements().size());
            for (ATermAppl aTermAppl : termTuple.getElements()) {
                if (ATermUtils.isVar(aTermAppl)) {
                    arrayList.add(this.getVar(aTermAppl, fact.getElements()));
                    continue;
                }
                arrayList.add(aTermAppl);
            }
            Object object = fact.getDependencySet();
            object = ((DependencySet)object).union(termTuple.getDependencySet(), this.doExplanation);
            if (this.rule != null && this.rule.explain != null) {
                object = ((DependencySet)object).union(this.rule.explain, this.doExplanation);
            }
            hashSet.add(new Fact((DependencySet)object, (List<ATermAppl>)arrayList));
        }
        return hashSet;
    }

    @Override
    public void reset() {
        super.reset();
        for (BetaNode betaNode : this.parents) {
            betaNode.reset();
        }
    }

    public String toString() {
        return "BetaNode vars: " + this.vars.toString();
    }
}

