/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Arrays;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;

public class BooleanOperators {
    public static final GeneralFunction booleanNot;
    private static final ATermAppl TRUE_TERM;
    private static final ATermAppl FALSE_TERM;

    static {
        TRUE_TERM = TermFactory.literal(true);
        FALSE_TERM = TermFactory.literal(false);
        booleanNot = new BooleanNot();
    }

    private static class BooleanNot
    implements GeneralFunction {
        private BooleanNot() {
        }

        @Override
        public boolean apply(ABox aBox, Literal[] literalArray) {
            if (literalArray.length != 2) {
                return false;
            }
            if (literalArray[0] == null) {
                if (literalArray[1] != null && literalArray[1].getValue() instanceof Boolean) {
                    literalArray[0] = aBox.addLiteral((Boolean)literalArray[1].getValue() != false ? FALSE_TERM : TRUE_TERM);
                    return true;
                }
            } else if (literalArray[1] == null) {
                if (literalArray[0].getValue() instanceof Boolean) {
                    literalArray[1] = aBox.addLiteral((Boolean)literalArray[0].getValue() != false ? FALSE_TERM : TRUE_TERM);
                    return true;
                }
            } else if (literalArray[0].getValue() instanceof Boolean && literalArray[1].getValue() instanceof Boolean) {
                return !literalArray[0].equals(literalArray[1]);
            }
            return false;
        }

        @Override
        public boolean isApplicable(boolean[] blArray) {
            if (blArray.length != 2) {
                return false;
            }
            return !Arrays.equals(blArray, new boolean[]{false, false});
        }
    }
}

