/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategyImpl;
import com.clarkparsia.pellet.rules.ContinuousReteTransformer;
import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.RuleBranch;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.Timer;

public class ContinuousRulesStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;
    private ContinuousReteTransformer continuousTransformer;
    private Interpreter interpreter;
    private boolean merging;
    private Map<Fact, Integer> partialBindings;
    private Map<Pair<Rule, VariableBinding>, Integer> rulesApplied;
    private RulesToReteTranslator ruleTranslator;
    private RulesToATermTranslator atermTranslator;
    private RuleAtomAsserter ruleAtomAsserter;
    private TrivialSatisfactionHelpers atomTester;
    boolean runRules;

    public ContinuousRulesStrategy(ABox aBox) {
        super(aBox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(aBox);
        this.continuousTransformer = new ContinuousReteTransformer(aBox);
        this.partialBindings = new HashMap<Fact, Integer>();
        this.rulesApplied = new HashMap<Pair<Rule, VariableBinding>, Integer>();
        this.ruleTranslator = new RulesToReteTranslator(aBox);
        this.atermTranslator = new RulesToATermTranslator();
        this.ruleAtomAsserter = new RuleAtomAsserter();
        this.atomTester = new TrivialSatisfactionHelpers(aBox);
        this.runRules = true;
    }

    @Override
    public void addEdge(Individual individual, Role role, Node node, DependencySet dependencySet) {
        super.addEdge(individual, role, node, dependencySet);
        if (!this.merging && !this.abox.isClosed() && individual.isRootNominal() && node.isRootNominal() && this.interpreter != null) {
            EdgeList edgeList = individual.getRNeighborEdges(role, node);
            for (Edge edge : edgeList) {
                if (!edge.getFrom().isRootNominal() || !edge.getTo().isRootNominal()) continue;
                this.runRules |= this.interpreter.rete.addFact(edge);
            }
            this.runRules |= this.interpreter.rete.addDifferents(individual);
            if (node.isIndividual()) {
                this.runRules |= this.interpreter.rete.addDifferents((Individual)node);
            }
        }
    }

    @Override
    public void addType(Node node, ATermAppl aTermAppl, DependencySet dependencySet) {
        super.addType(node, aTermAppl, dependencySet);
        if (!this.merging && !this.abox.isClosed() && node.isRootNominal() && this.interpreter != null && node.isIndividual()) {
            Individual individual = (Individual)node;
            this.runRules |= this.interpreter.rete.addFact(individual, aTermAppl, individual.getDepends((ATerm)aTermAppl));
            this.runRules |= this.interpreter.rete.addDifferents((Individual)node);
        }
    }

    private void applyFact(Fact fact) {
        if (fact.getElements().size() == 0) {
            this.abox.setClash(Clash.unexplained(null, fact.getDependencySet()));
            log.log(Level.WARNING, "Fact with no elements, create clash");
            return;
        }
        if (fact.getElements().size() == 3) {
            DependencySet dependencySet = fact.getDependencySet();
            if (log.isLoggable(Level.FINE)) {
                log.fine("RULE: " + fact + " " + dependencySet);
            }
            ATermAppl aTermAppl = (ATermAppl)fact.getElements().get(0);
            Individual individual = this.abox.getIndividual((ATerm)fact.getElements().get(1));
            if (individual.isMerged()) {
                dependencySet = dependencySet.union(individual.getMergeDependency(true), this.abox.doExplanation());
                individual = individual.getSame();
            }
            ATermAppl aTermAppl2 = (ATermAppl)fact.getElements().get(2);
            if (aTermAppl.equals(Compiler.TYPE)) {
                ATermAppl aTermAppl3 = aTermAppl2;
                this.addType(individual, aTermAppl3, dependencySet);
            } else {
                Node node = this.abox.getNode((ATerm)aTermAppl2);
                if (node != null && node.isMerged()) {
                    node = node.getSame();
                }
                if (aTermAppl.equals(Compiler.SAME_AS)) {
                    Individual individual2 = (Individual)node;
                    this.mergeTo(individual2, individual, dependencySet);
                } else if (aTermAppl.equals(Compiler.DIFF_FROM)) {
                    Individual individual3 = (Individual)node;
                    individual.setDifferent(individual3, dependencySet);
                } else {
                    Role role = this.abox.getRole((ATerm)aTermAppl);
                    if (node == null && role.isDatatypeRole()) {
                        node = this.abox.addLiteral(aTermAppl2);
                    }
                    this.addEdge(individual, role, node, dependencySet);
                }
            }
        }
    }

    public void applyRete() {
        Timer timer;
        if (PelletOptions.ALWAYS_REBUILD_RETE) {
            timer = this.timers.startTimer("rule-rebuildRete");
            this.interpreter.reset();
            this.interpreter.rete.compileFacts(this.abox);
            this.partialBindings.clear();
            timer.stop();
        }
        if (!this.interpreter.isDirty()) {
            return;
        }
        timer = this.timers.startTimer("rule-reteRun");
        Set<Fact> set = this.interpreter.run();
        timer.stop();
        timer = this.timers.startTimer("rule-reteFacts");
        for (Fact fact : set) {
            assert (fact.getDependencySet().getBranch() == this.abox.getBranch());
            assert (fact.getDependencySet().max() <= this.abox.getBranch());
            this.applyFact(fact);
            if (this.abox.isClosed()) {
                timer.stop();
                return;
            }
            if (fact.getElements().size() <= 3 || !((ATermAppl)fact.getElements().get(0)).equals(ContinuousReteTransformer.VARBINDING) || this.partialBindings.containsKey(fact)) continue;
            this.partialBindings.put(fact, this.abox.getBranch());
        }
        timer.stop();
    }

    public void applyRuleBindings() {
        int n = 0;
        for (Fact fact : this.partialBindings.keySet()) {
            Pair<Rule, VariableBinding> pair = this.continuousTransformer.translateFact(fact);
            Rule rule = (Rule)pair.first;
            VariableBinding variableBinding = (VariableBinding)pair.second;
            for (VariableBinding variableBinding2 : this.bindingStrategy.createGenerator(rule, variableBinding)) {
                int n2;
                Pair<Rule, VariableBinding> pair2 = new Pair<Rule, VariableBinding>(rule, variableBinding2);
                if (this.rulesApplied.containsKey(pair2)) continue;
                ++n;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Rule: " + rule);
                    log.fine("Binding: " + variableBinding2);
                    log.fine("total:" + n);
                }
                if ((n2 = this.createDisjunctionsFromBinding(variableBinding2, rule, fact.getDependencySet())) >= 0) {
                    this.rulesApplied.put(pair2, n2);
                }
                if (!this.abox.isClosed()) continue;
                return;
            }
        }
    }

    @Override
    public void complete(Expressivity expressivity) {
        Expressivity expressivity2 = this.abox.getKB().getExpressivity();
        this.initialize(expressivity2);
        this.merging = false;
        this.interpreter = new Interpreter(this.abox);
        for (Map.Entry<Rule, Rule> entry : this.abox.getKB().getNormalizedRules().entrySet()) {
            Object object2 = entry.getKey();
            Rule rule = entry.getValue();
            if (rule == null) continue;
            Set<ATermAppl> set = this.abox.doExplanation() ? ((Rule)object2).getExplanation(this.atermTranslator) : Collections.emptySet();
            com.clarkparsia.pellet.rules.rete.Rule rule2 = this.ruleTranslator.translateRule(rule);
            if (rule2 != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("SWRL Rule: " + object2);
                    log.finer("Rete Rule: " + rule2);
                    log.finer("Term Rule: " + set);
                    log.finer("===");
                }
                this.interpreter.rete.compile(rule2, set);
            }
            if ((rule2 = this.continuousTransformer.transformRule(rule)) == null) continue;
            this.interpreter.rete.compile(rule2, set);
        }
        this.partialBindings.clear();
        this.rulesApplied.clear();
        if (log.isLoggable(Level.FINER)) {
            log.finer("AlphaStore: " + this.interpreter.rete);
        }
        this.interpreter.rete.compileFacts(this.abox);
        while (this.interpreter.isDirty() && !this.abox.isClosed()) {
            this.applyRete();
        }
        while (!this.abox.isComplete()) {
            Object object;
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.stats.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                }
                object = this.abox.getIndIterator();
                for (Object object2 : this.tableauRules) {
                    object2.apply((IndividualIterator)object);
                    if (!this.abox.isClosed()) continue;
                    break;
                }
                if (this.abox.isClosed()) break;
                if (!this.abox.isChanged()) {
                    while (this.interpreter.isDirty() && !this.abox.isClosed()) {
                        this.applyRete();
                    }
                    if (this.abox.isClosed()) break;
                }
                if (this.abox.isChanged() || !this.runRules) continue;
                this.runRules = false;
                this.applyRuleBindings();
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                object = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    object = this.abox.getBranches().get(i);
                    ((Branch)object).setTryNext(((Branch)object).getTryNext() + 1);
                    if (((Branch)object).getTryNext() < ((Branch)object).getTryCount()) {
                        this.restore((Branch)object);
                        System.out.println("restoring branch " + ((Branch)object).getBranch() + " tryNext = " + ((Branch)object).getTryNext() + " tryCount = " + ((Branch)object).getTryCount());
                        ((Branch)object).tryNext();
                        break;
                    }
                    System.out.println("removing branch " + ((Branch)object).getBranch());
                    this.abox.getBranches().remove(i);
                    object = null;
                }
                if (object != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }

    private int createDisjunctionsFromBinding(VariableBinding variableBinding, Rule rule, DependencySet dependencySet) {
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        for (RuleAtom object2 : rule.getBody()) {
            DependencySet dependencySet2 = this.atomTester.isAtomTrue(object2, variableBinding);
            if (dependencySet2 != null) {
                dependencySet = dependencySet.union(dependencySet2, this.abox.doExplanation());
                continue;
            }
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            if (rule.getHead().isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Empty head for rule " + rule);
                }
                this.abox.setClash(Clash.unexplained(null, dependencySet));
            } else {
                for (RuleAtom ruleAtom : rule.getHead()) {
                    this.ruleAtomAsserter.assertAtom(ruleAtom, variableBinding, dependencySet, false, this.abox, this);
                }
            }
            return -1;
        }
        int n = arrayList.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            DependencySet dependencySet3 = this.atomTester.isAtomTrue(ruleAtom, variableBinding);
            if (dependencySet3 != null) continue;
            arrayList.add(ruleAtom);
        }
        if (arrayList.size() == n && !rule.getHead().isEmpty()) {
            return -1;
        }
        if (arrayList.size() == 1) {
            this.ruleAtomAsserter.assertAtom((RuleAtom)arrayList.get(0), variableBinding, dependencySet, true, this.abox, this);
            return -1;
        }
        RuleBranch ruleBranch = new RuleBranch(this.abox, this, this.ruleAtomAsserter, arrayList, variableBinding, n, dependencySet);
        this.addBranch(ruleBranch);
        ruleBranch.tryNext();
        return ruleBranch.getBranch();
    }

    @Override
    public void mergeTo(Node node, Node node2, DependencySet dependencySet) {
        this.merging = true;
        super.mergeTo(node, node2, dependencySet);
        if (!this.abox.isClosed() && this.interpreter != null && (node.isRootNominal() || node2.isRootNominal())) {
            if (node.isRootNominal()) {
                this.runRules |= this.interpreter.removeMentions(node.getTerm());
            }
            if (node2.isIndividual()) {
                this.runRules |= this.interpreter.rete.processIndividual((Individual)node2);
            }
        }
        this.merging = false;
    }

    @Override
    public void restore(Branch branch) {
        super.restore(branch);
        this.restoreRules(branch);
    }

    @Override
    public void restoreLocal(Individual individual, Branch branch) {
        super.restoreLocal(individual, branch);
        this.restoreRules(branch);
    }

    private void restoreRules(Branch branch) {
        Map.Entry<Object, Integer> entry;
        int n = 0;
        Iterator<Map.Entry<Object, Integer>> iterator = this.rulesApplied.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue() <= branch.getBranch()) continue;
            iterator.remove();
            this.runRules = true;
            ++n;
        }
        iterator = this.partialBindings.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue() <= branch.getBranch()) continue;
            iterator.remove();
            this.runRules = true;
        }
        this.runRules |= this.interpreter.restore(branch.getBranch());
    }
}

