/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.owlapiv3.ConceptConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;

public class AxiomConverter {
    public static Logger log = Logger.getLogger(AxiomConverter.class.getName());
    private ConceptConverter conceptConverter;
    private OWLDataFactory factory;
    private KnowledgeBase kb;

    public AxiomConverter(PelletReasoner pelletReasoner) {
        this(pelletReasoner.getKB(), pelletReasoner.getManager().getOWLDataFactory());
    }

    public AxiomConverter(KnowledgeBase knowledgeBase, OWLDataFactory oWLDataFactory) {
        if (knowledgeBase == null) {
            throw new NullPointerException("KnowledgeBase is null");
        }
        if (oWLDataFactory == null) {
            throw new NullPointerException("OWLDataFactory is null");
        }
        this.kb = knowledgeBase;
        this.factory = oWLDataFactory;
        this.conceptConverter = new ConceptConverter(knowledgeBase, oWLDataFactory);
    }

    public OWLAxiom convert(ATermAppl aTermAppl) {
        Object object = null;
        if (aTermAppl.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLClassExpression oWLClassExpression2 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            hashSet.add(oWLClassExpression);
            hashSet.add(oWLClassExpression2);
            if (oWLClassExpression != null && oWLClassExpression2 != null) {
                object = this.factory.getOWLEquivalentClassesAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBFUN)) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLClassExpression oWLClassExpression3 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLClassExpression != null && oWLClassExpression3 != null) {
                object = this.factory.getOWLSubClassOfAxiom(oWLClassExpression, oWLClassExpression3);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermAppl aTermAppl2;
            OWLClassExpression oWLClassExpression;
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty() && (oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert(aTermAppl2 = (ATermAppl)aTermList.getFirst())) != null) {
                hashSet.add(oWLClassExpression);
                aTermList = aTermList.getNext();
            }
            if (aTermList.isEmpty()) {
                object = this.factory.getOWLDisjointClassesAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLClassExpression oWLClassExpression4 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            hashSet.add(oWLClassExpression);
            hashSet.add(oWLClassExpression4);
            if (oWLClassExpression != null && oWLClassExpression4 != null) {
                object = this.factory.getOWLDisjointClassesAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            OWLObject oWLObject;
            HashSet<OWLObjectProperty> hashSet = new HashSet<OWLObjectProperty>();
            HashSet<OWLDataProperty> hashSet2 = new HashSet<OWLDataProperty>();
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty() && (oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0))) != null) {
                if (oWLObject instanceof OWLObjectProperty) {
                    if (!hashSet2.isEmpty()) break;
                    hashSet.add((OWLObjectProperty)oWLObject);
                } else {
                    if (!hashSet.isEmpty()) break;
                    hashSet2.add((OWLDataProperty)oWLObject);
                }
                aTermList = aTermList.getNext();
            }
            if (aTermList.isEmpty()) {
                object = !hashSet.isEmpty() ? this.factory.getOWLDisjointObjectPropertiesAxiom(hashSet) : this.factory.getOWLDisjointDataPropertiesAxiom(hashSet2);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLObject oWLObject2 = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLObject != null && oWLObject2 != null) {
                if (oWLObject instanceof OWLObjectProperty && oWLObject2 instanceof OWLObjectProperty) {
                    object = this.factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)oWLObject, (OWLObjectProperty)oWLObject2));
                } else if (oWLObject instanceof OWLDataProperty && oWLObject2 instanceof OWLDataProperty) {
                    object = this.factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((OWLDataProperty)oWLObject, (OWLDataProperty)oWLObject2));
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (aTermAppl.getArgument(0) instanceof ATermList) {
                ArrayList<OWLObjectPropertyExpression> arrayList = new ArrayList<OWLObjectPropertyExpression>();
                ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
                while (!aTermList.isEmpty()) {
                    OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)this.conceptConverter.convert((ATermAppl)aTermList.getFirst());
                    if (oWLObjectPropertyExpression == null) {
                        arrayList = null;
                        break;
                    }
                    arrayList.add(oWLObjectPropertyExpression);
                    aTermList = aTermList.getNext();
                }
                aTermList = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
                if (arrayList != null && aTermList != null) {
                    object = this.factory.getOWLSubPropertyChainOfAxiom(arrayList, (OWLObjectPropertyExpression)aTermList);
                }
            } else {
                OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                OWLObject oWLObject3 = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
                if (oWLObject != null && oWLObject3 != null) {
                    if (oWLObject instanceof OWLObjectPropertyExpression && oWLObject3 instanceof OWLObjectPropertyExpression) {
                        object = this.factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)oWLObject, (OWLObjectPropertyExpression)oWLObject3);
                    } else if (oWLObject instanceof OWLDataProperty && oWLObject3 instanceof OWLDataProperty) {
                        object = this.factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)((OWLDataProperty)oWLObject), (OWLDataPropertyExpression)((OWLDataProperty)oWLObject3));
                    }
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.EQPROPFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLObject oWLObject4 = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLObject != null && oWLObject4 != null) {
                if (oWLObject instanceof OWLObjectProperty && oWLObject4 instanceof OWLObjectProperty) {
                    object = this.factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)oWLObject, (OWLObjectProperty)oWLObject4));
                } else if (oWLObject instanceof OWLDataProperty && oWLObject4 instanceof OWLDataProperty) {
                    object = this.factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((OWLDataProperty)oWLObject, (OWLDataProperty)oWLObject4));
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DOMAINFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLClassExpression != null && oWLObject != null) {
                object = oWLObject instanceof OWLObjectProperty ? this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)oWLObject, oWLClassExpression) : this.factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)oWLObject, oWLClassExpression);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.RANGEFUN)) {
            OWLPropertyRange oWLPropertyRange = (OWLPropertyRange)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLPropertyRange != null) {
                if (oWLPropertyRange instanceof OWLClassExpression) {
                    OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                    if (oWLObjectProperty != null) {
                        object = this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)oWLObjectProperty, (OWLClassExpression)oWLPropertyRange);
                    }
                } else {
                    OWLDataProperty oWLDataProperty = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                    if (oWLDataProperty != null) {
                        object = this.factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)oWLDataProperty, (OWLDataRange)oWLPropertyRange);
                    }
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.INVPROPFUN)) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLObjectProperty oWLObjectProperty2 = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLObjectProperty != null && oWLObjectProperty2 != null) {
                object = this.factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)oWLObjectProperty, (OWLObjectPropertyExpression)oWLObjectProperty2);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObjectProperty != null) {
                object = this.factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObjectProperty);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObject != null) {
                if (oWLObject instanceof OWLObjectProperty) {
                    object = this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObject);
                } else if (oWLObject instanceof OWLDataProperty) {
                    object = this.factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)oWLObject);
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObjectProperty != null) {
                object = this.factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObjectProperty);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObject != null && oWLObject instanceof OWLObjectPropertyExpression) {
                object = this.factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObject);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObject != null && oWLObject instanceof OWLObjectPropertyExpression) {
                object = this.factory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObject);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObject != null && oWLObject instanceof OWLObjectPropertyExpression) {
                object = this.factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObject);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            if (oWLObject != null && oWLObject instanceof OWLObjectPropertyExpression) {
                object = this.factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)oWLObject);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.TYPEFUN)) {
            OWLIndividual oWLIndividual = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(0));
            OWLClassExpression oWLClassExpression = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLIndividual != null && oWLClassExpression != null) {
                object = this.factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual oWLIndividual = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(1));
            if (oWLIndividual == null) {
                object = null;
            } else if (ATermUtils.isLiteral((ATermAppl)aTermAppl.getArgument(2))) {
                OWLDataProperty oWLDataProperty = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                OWLLiteral oWLLiteral = (OWLLiteral)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(2));
                if (oWLDataProperty != null && oWLLiteral != null) {
                    object = this.factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty, oWLIndividual, oWLLiteral);
                }
            } else {
                OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                OWLIndividual oWLIndividual2 = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(2));
                if (oWLObjectProperty != null && oWLIndividual2 != null) {
                    object = this.factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)oWLObjectProperty, oWLIndividual, oWLIndividual2);
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.NOTFUN) && ((ATermAppl)aTermAppl.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual oWLIndividual = this.conceptConverter.convertIndividual((ATermAppl)(aTermAppl = (ATermAppl)aTermAppl.getArgument(0)).getArgument(1));
            if (oWLIndividual == null) {
                object = null;
            } else if (ATermUtils.isLiteral((ATermAppl)aTermAppl.getArgument(2))) {
                OWLDataProperty oWLDataProperty = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                OWLLiteral oWLLiteral = (OWLLiteral)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(2));
                if (oWLDataProperty != null && oWLLiteral != null) {
                    object = this.factory.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty, oWLIndividual, oWLLiteral);
                }
            } else {
                OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
                OWLIndividual oWLIndividual3 = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(2));
                if (oWLObjectProperty != null && oWLIndividual3 != null) {
                    object = this.factory.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)oWLObjectProperty, oWLIndividual, oWLIndividual3);
                }
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.SAMEASFUN)) {
            OWLIndividual oWLIndividual = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(0));
            OWLIndividual oWLIndividual4 = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(1));
            HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
            hashSet.add(oWLIndividual);
            hashSet.add(oWLIndividual4);
            if (oWLIndividual != null && oWLIndividual4 != null) {
                object = this.factory.getOWLSameIndividualAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            OWLIndividual oWLIndividual = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(0));
            OWLIndividual oWLIndividual5 = this.conceptConverter.convertIndividual((ATermAppl)aTermAppl.getArgument(1));
            HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
            hashSet.add(oWLIndividual);
            hashSet.add(oWLIndividual5);
            if (oWLIndividual != null && oWLIndividual5 != null) {
                object = this.factory.getOWLDifferentIndividualsAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermAppl aTermAppl3;
            OWLIndividual oWLIndividual;
            HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            while (!aTermList.isEmpty() && (oWLIndividual = this.conceptConverter.convertIndividual(aTermAppl3 = (ATermAppl)aTermList.getFirst())) != null) {
                hashSet.add(oWLIndividual);
                aTermList = aTermList.getNext();
            }
            if (aTermList.isEmpty()) {
                object = this.factory.getOWLDifferentIndividualsAxiom(hashSet);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.RULEFUN)) {
            HashSet<SWRLAtom> hashSet = new HashSet<SWRLAtom>();
            HashSet<SWRLAtom> hashSet3 = new HashSet<SWRLAtom>();
            ATermList aTermList = (ATermList)aTermAppl.getArgument(1);
            ATermList aTermList2 = (ATermList)aTermAppl.getArgument(2);
            while (!aTermList2.isEmpty()) {
                hashSet.add(this.parseToSWRLAtom((ATermAppl)aTermList2.getFirst()));
                aTermList2 = aTermList2.getNext();
            }
            while (!aTermList.isEmpty()) {
                hashSet3.add(this.parseToSWRLAtom((ATermAppl)aTermList.getFirst()));
                aTermList = aTermList.getNext();
            }
            if (!hashSet.contains(null) && !hashSet3.contains(null)) {
                ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(0);
                object = aTermAppl4 == ATermUtils.EMPTY ? this.factory.getSWRLRule(hashSet, hashSet3) : (ATermUtils.isBnode(aTermAppl4) ? this.factory.getSWRLRule(NodeID.getNodeID((String)((ATermAppl)aTermAppl4.getArgument(0)).getName()), hashSet, hashSet3) : this.factory.getSWRLRule(IRI.create((String)aTermAppl4.getName()), hashSet, hashSet3));
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.DATATYPEDEFFUN)) {
            OWLDatatype oWLDatatype = (OWLDatatype)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(0));
            OWLDataRange oWLDataRange = (OWLDataRange)this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLDatatype != null && oWLDataRange != null) {
                object = this.factory.getOWLDatatypeDefinitionAxiom(oWLDatatype, oWLDataRange);
            }
        }
        if (object == null) {
            log.warning("Cannot convert to OWLAPI: " + aTermAppl);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SWRLAtom parseToSWRLAtom(ATermAppl aTermAppl) {
        SWRLClassAtom sWRLClassAtom = null;
        if (aTermAppl.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            OWLObject oWLObject = this.conceptConverter.convert((ATermAppl)aTermAppl.getArgument(1));
            if (oWLObject instanceof OWLClassExpression) {
                SWRLIArgument sWRLIArgument = this.parseToAtomIObject(aTermAppl2);
                sWRLClassAtom = this.factory.getSWRLClassAtom((OWLClassExpression)oWLObject, sWRLIArgument);
            } else {
                if (!(oWLObject instanceof OWLDataRange)) throw new InternalReasonerException("Cannot convert to SWRL atom: " + ATermUtils.toString(aTermAppl));
                SWRLDArgument sWRLDArgument = this.parseToAtomDObject(aTermAppl2);
                sWRLClassAtom = this.factory.getSWRLDataRangeAtom((OWLDataRange)oWLObject, sWRLDArgument);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl4 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl5 = (ATermAppl)aTermAppl.getArgument(2);
            SWRLIArgument sWRLIArgument = this.parseToAtomIObject(aTermAppl4);
            if (this.kb.isObjectProperty((ATerm)aTermAppl3)) {
                SWRLIArgument sWRLIArgument2 = this.parseToAtomIObject(aTermAppl5);
                OWLObjectProperty oWLObjectProperty = this.factory.getOWLObjectProperty(IRI.create((String)aTermAppl3.getName()));
                sWRLClassAtom = this.factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)oWLObjectProperty, sWRLIArgument, sWRLIArgument2);
            } else if (this.kb.isDatatypeProperty((ATerm)aTermAppl3)) {
                SWRLDArgument sWRLDArgument = this.parseToAtomDObject(aTermAppl5);
                OWLDataProperty oWLDataProperty = this.factory.getOWLDataProperty(IRI.create((String)aTermAppl3.getName()));
                sWRLClassAtom = this.factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)oWLDataProperty, sWRLIArgument, sWRLDArgument);
            }
        } else if (aTermAppl.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl aTermAppl6 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl7 = (ATermAppl)aTermAppl.getArgument(1);
            SWRLIArgument sWRLIArgument = this.parseToAtomIObject(aTermAppl6);
            SWRLIArgument sWRLIArgument3 = this.parseToAtomIObject(aTermAppl7);
            sWRLClassAtom = this.factory.getSWRLSameIndividualAtom(sWRLIArgument, sWRLIArgument3);
        } else if (aTermAppl.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl aTermAppl8 = (ATermAppl)aTermAppl.getArgument(0);
            ATermAppl aTermAppl9 = (ATermAppl)aTermAppl.getArgument(1);
            SWRLIArgument sWRLIArgument = this.parseToAtomIObject(aTermAppl8);
            SWRLIArgument sWRLIArgument4 = this.parseToAtomIObject(aTermAppl9);
            sWRLClassAtom = this.factory.getSWRLDifferentIndividualsAtom(sWRLIArgument, sWRLIArgument4);
        } else if (aTermAppl.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            ATermAppl aTermAppl10 = (ATermAppl)aTermList.getFirst();
            ArrayList<SWRLDArgument> arrayList = new ArrayList<SWRLDArgument>();
            aTermList = aTermList.getNext();
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl11 = (ATermAppl)aTermList.getFirst();
                arrayList.add(this.parseToAtomDObject(aTermAppl11));
                aTermList = aTermList.getNext();
            }
            sWRLClassAtom = this.factory.getSWRLBuiltInAtom(IRI.create((String)aTermAppl10.getName()), arrayList);
        }
        if (sWRLClassAtom != null) return sWRLClassAtom;
        log.warning("Cannot convert to SWRLAtom: " + aTermAppl);
        return sWRLClassAtom;
    }

    private SWRLIArgument parseToAtomIObject(ATermAppl aTermAppl) {
        if (ATermUtils.isVar(aTermAppl)) {
            return this.factory.getSWRLVariable(IRI.create((String)((ATermAppl)aTermAppl.getArgument(0)).getName()));
        }
        if (this.kb.isIndividual((ATerm)aTermAppl)) {
            return this.factory.getSWRLIndividualArgument(this.conceptConverter.convertIndividual(aTermAppl));
        }
        throw new InternalReasonerException("Unrecognized term: " + aTermAppl);
    }

    private SWRLDArgument parseToAtomDObject(ATermAppl aTermAppl) {
        if (ATermUtils.isVar(aTermAppl)) {
            return this.factory.getSWRLVariable(IRI.create((String)((ATermAppl)aTermAppl.getArgument(0)).getName()));
        }
        if (ATermUtils.isLiteral(aTermAppl)) {
            return this.factory.getSWRLLiteralArgument((OWLLiteral)this.conceptConverter.convert(aTermAppl));
        }
        throw new InternalReasonerException("Unrecognized term: " + aTermAppl);
    }
}

