/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

public class RoleChainCache {
    private static final String ANON_ROLE = "anonRole";
    private int m_AnonRoleCount = 0;
    private Map<ATermAppl, MultiValueMap<ATermAppl, ATermAppl>> m_BinaryRoleInclusions = CollectionUtils.makeMap();

    public RoleChainCache(KnowledgeBase knowledgeBase) {
        for (Role role : knowledgeBase.getRBox().getRoles()) {
            if (role.isAnon()) continue;
            for (ATermList aTermList : role.getSubRoleChains()) {
                int n = aTermList.getLength();
                if (n <= 1) continue;
                ATermAppl aTermAppl = (ATermAppl)aTermList.getFirst();
                aTermList = aTermList.getNext();
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                ATermAppl aTermAppl3 = this.createSuperRoleFor(aTermAppl, aTermAppl2);
                for (int i = 1; i < n - 1; ++i) {
                    this.add(knowledgeBase, aTermAppl, aTermAppl2, aTermAppl3);
                    aTermAppl = aTermAppl3;
                    aTermList = aTermList.getNext();
                    aTermAppl2 = (ATermAppl)aTermList.getFirst();
                    aTermAppl3 = this.createSuperRoleFor(aTermAppl, aTermAppl2);
                }
                this.add(knowledgeBase, aTermAppl, aTermAppl2, role.getName());
            }
        }
    }

    public boolean isAnon(ATermAppl aTermAppl) {
        return aTermAppl.getName().startsWith(ANON_ROLE);
    }

    public Set<ATermAppl> getAllSuperRoles(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        MultiValueMap<ATermAppl, ATermAppl> multiValueMap = this.m_BinaryRoleInclusions.get(aTermAppl);
        if (multiValueMap == null) {
            return Collections.emptySet();
        }
        Set set = (Set)multiValueMap.get(aTermAppl2);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private ATermAppl createSuperRoleFor(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Set<ATermAppl> set = this.getAllSuperRoles(aTermAppl, aTermAppl2);
        if (set.isEmpty()) {
            return ATermUtils.makeTermAppl(ANON_ROLE + this.m_AnonRoleCount++);
        }
        return set.iterator().next();
    }

    private void add(KnowledgeBase knowledgeBase, ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Role role = knowledgeBase.getRole((ATerm)aTermAppl);
        Role role2 = knowledgeBase.getRole((ATerm)aTermAppl2);
        if (role == null) {
            if (role2 == null) {
                this.add(aTermAppl, aTermAppl2, aTermAppl3);
            } else {
                for (Role role3 : role2.getSubRoles()) {
                    this.add(aTermAppl, role3.getName(), aTermAppl3);
                }
            }
        } else if (role2 == null) {
            for (Role role4 : role.getSubRoles()) {
                this.add(role4.getName(), aTermAppl2, aTermAppl3);
            }
        } else {
            for (Role role5 : role.getSubRoles()) {
                for (Role role6 : role2.getSubRoles()) {
                    this.add(role5.getName(), role6.getName(), aTermAppl3);
                }
            }
        }
    }

    private boolean add(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        MultiValueMap<Object, Object> multiValueMap = this.m_BinaryRoleInclusions.get(aTermAppl);
        if (multiValueMap == null) {
            multiValueMap = new MultiValueMap();
            this.m_BinaryRoleInclusions.put(aTermAppl, multiValueMap);
        }
        return multiValueMap.add(aTermAppl2, aTermAppl3);
    }

    public void print() {
        System.out.println("Role Chains:");
        System.out.println(this.m_BinaryRoleInclusions);
    }
}

