/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ConceptInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

class ELTaxonomyBuilder {
    private Taxonomy<ATermAppl> taxonomy;

    ELTaxonomyBuilder() {
    }

    public Taxonomy<ATermAppl> build(Map<ATermAppl, ConceptInfo> map) {
        this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ConceptInfo object : map.get(ATermUtils.TOP).getSuperClasses()) {
            ATermAppl aTermAppl = object.getConcept();
            if (!ATermUtils.isPrimitive(aTermAppl)) continue;
            this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getTop());
        }
        ConceptInfo conceptInfo = map.get(ATermUtils.BOTTOM);
        for (ConceptInfo conceptInfo2 : map.values()) {
            ATermAppl aTermAppl = conceptInfo2.getConcept();
            if (!ATermUtils.isPrimitive(aTermAppl)) continue;
            if (conceptInfo2.getSuperClasses().contains(conceptInfo)) {
                this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getBottom());
                continue;
            }
            this.classify(conceptInfo2);
        }
        return this.taxonomy;
    }

    private TaxonomyNode<ATermAppl> classify(ConceptInfo conceptInfo) {
        ATermAppl aTermAppl = conceptInfo.getConcept();
        TaxonomyNode<ATermAppl> taxonomyNode = this.taxonomy.getNode(aTermAppl);
        if (taxonomyNode == null) {
            Object object;
            HashSet<ConceptInfo> hashSet = new HashSet<ConceptInfo>();
            HashSet<TaxonomyNode<ATermAppl>> hashSet2 = new HashSet<TaxonomyNode<ATermAppl>>();
            for (ConceptInfo conceptInfo2 : conceptInfo.getSuperClasses()) {
                if (!ATermUtils.isPrimitive(conceptInfo2.getConcept()) || conceptInfo.equals(conceptInfo2)) continue;
                if (conceptInfo2.hasSuperClass(conceptInfo)) {
                    hashSet.add(conceptInfo2);
                    continue;
                }
                object = this.classify(conceptInfo2);
                if (object == null) continue;
                hashSet2.add((TaxonomyNode<ATermAppl>)object);
            }
            taxonomyNode = this.add(conceptInfo, hashSet2);
            for (ConceptInfo conceptInfo2 : hashSet) {
                object = conceptInfo2.getConcept();
                this.taxonomy.addEquivalentNode((ATermAppl)object, taxonomyNode);
            }
        }
        return taxonomyNode;
    }

    private TaxonomyNode<ATermAppl> add(ConceptInfo conceptInfo, Set<TaxonomyNode<ATermAppl>> set) {
        ATermAppl aTermAppl = conceptInfo.getConcept();
        HashSet<TaxonomyNode<ATermAppl>> hashSet = new HashSet<TaxonomyNode<ATermAppl>>(set);
        HashSet<Object> hashSet2 = new HashSet<Object>();
        Set<ATermAppl> set2 = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> taxonomyNode : set) {
            hashSet.removeAll(taxonomyNode.getSupers());
        }
        for (TaxonomyNode<Object> taxonomyNode : hashSet) {
            hashSet2.add(taxonomyNode.getName());
            taxonomyNode.removeSub(this.taxonomy.getBottom());
        }
        return this.taxonomy.addNode(Collections.singleton(aTermAppl), hashSet2, set2, false);
    }
}

