/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNegativeInteger instance = new XSDNegativeInteger();

    public static XSDNegativeInteger getInstance() {
        return instance;
    }

    private XSDNegativeInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#negativeInteger"), null, -1);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            BigInteger bigInteger = DatatypeConverter.parseInteger(string);
            if (BigInteger.ZERO.compareTo(bigInteger) <= 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

