/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class OWLRational
extends AbstractBaseDatatype<Number> {
    private static final OWLRational instance = new OWLRational();
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLRational getInstance() {
        return instance;
    }

    private OWLRational() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#rational"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        Number number = this.getValue(aTermAppl);
        if (number instanceof Rational) {
            String string = Rational.simplify((Rational)number).toString();
            if (string.equals(ATermUtils.getLiteralValue(aTermAppl))) {
                return aTermAppl;
            }
            return ATermUtils.makeTypedLiteral(string, this.getName());
        }
        return OWLReal.getInstance().getLiteral(OWLRealUtils.getCanonicalObject(number));
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        if (object instanceof Rational) {
            Rational rational = (Rational)object;
            String string = rational.toString();
            return ATermUtils.makeTypedLiteral(string, this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return OWLReal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        String string = this.getLexicalForm(aTermAppl);
        try {
            return OWLRealUtils.getCanonicalObject(Rational.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

