/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OntologyDiff {
    private List<OWLAxiom> additions = new ArrayList<OWLAxiom>();
    private List<OWLAxiom> deletions = new ArrayList<OWLAxiom>();

    private OntologyDiff() {
    }

    public static OntologyDiff diffOntologies(OWLOntology oWLOntology, OWLOntology oWLOntology2) {
        OntologyDiff ontologyDiff = new OntologyDiff();
        for (OWLAxiom oWLAxiom : oWLOntology.getLogicalAxioms()) {
            if (oWLOntology2.containsAxiom(oWLAxiom)) continue;
            ontologyDiff.deletions.add(oWLAxiom);
        }
        for (OWLAxiom oWLAxiom : oWLOntology2.getLogicalAxioms()) {
            if (oWLOntology.containsAxiom(oWLAxiom)) continue;
            ontologyDiff.additions.add(oWLAxiom);
        }
        return ontologyDiff;
    }

    public static OntologyDiff diffOntologiesWithAxioms(Collection<OWLOntology> collection, Collection<OWLAxiom> collection2) {
        OntologyDiff ontologyDiff = new OntologyDiff();
        for (OWLOntology oWLOntology : collection) {
            for (OWLAxiom oWLAxiom : oWLOntology.getAxioms()) {
                if (collection2.contains(oWLAxiom)) continue;
                ontologyDiff.deletions.add(oWLAxiom);
            }
        }
        for (OWLAxiom oWLAxiom : collection2) {
            if (OntologyDiff.containsAxiom(oWLAxiom, collection)) continue;
            ontologyDiff.additions.add(oWLAxiom);
        }
        return ontologyDiff;
    }

    public static OntologyDiff diffAxiomsWithOntologies(Collection<OWLAxiom> collection, Collection<OWLOntology> collection2) {
        OntologyDiff ontologyDiff = new OntologyDiff();
        for (OWLAxiom oWLAxiom : collection) {
            if (OntologyDiff.containsAxiom(oWLAxiom, collection2)) continue;
            ontologyDiff.deletions.add(oWLAxiom);
        }
        for (OWLOntology oWLOntology : collection2) {
            for (OWLAxiom oWLAxiom : oWLOntology.getAxioms()) {
                if (collection.contains(oWLAxiom)) continue;
                ontologyDiff.additions.add(oWLAxiom);
            }
        }
        return ontologyDiff;
    }

    private static boolean containsAxiom(OWLAxiom oWLAxiom, Collection<OWLOntology> collection) {
        for (OWLOntology oWLOntology : collection) {
            if (!oWLOntology.containsAxiom(oWLAxiom)) continue;
            return true;
        }
        return false;
    }

    public static OntologyDiff diffAxioms(Collection<OWLAxiom> collection, Collection<OWLAxiom> collection2) {
        OntologyDiff ontologyDiff = new OntologyDiff();
        for (OWLAxiom oWLAxiom : collection) {
            if (collection2.contains(oWLAxiom)) continue;
            ontologyDiff.deletions.add(oWLAxiom);
        }
        for (OWLAxiom oWLAxiom : collection2) {
            if (collection.contains(oWLAxiom)) continue;
            ontologyDiff.additions.add(oWLAxiom);
        }
        return ontologyDiff;
    }

    public boolean areSame() {
        return this.additions.isEmpty() && this.deletions.isEmpty();
    }

    public int getDiffCount() {
        return this.additions.size() + this.deletions.size();
    }

    public Collection<OWLAxiom> getAdditions() {
        return this.additions;
    }

    public Collection<OWLOntologyChange> getChanges(OWLOntology oWLOntology) {
        ArrayList<OWLOntologyChange> arrayList = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom oWLAxiom : this.additions) {
            arrayList.add((OWLOntologyChange)new AddAxiom(oWLOntology, oWLAxiom));
        }
        for (OWLAxiom oWLAxiom : this.deletions) {
            arrayList.add((OWLOntologyChange)new RemoveAxiom(oWLOntology, oWLAxiom));
        }
        return arrayList;
    }

    private static OWLOntology identifyAxiomOntology(OWLAxiom oWLAxiom, Collection<OWLOntology> collection) {
        for (OWLOntology oWLOntology : collection) {
            if (!oWLOntology.containsAxiom(oWLAxiom)) continue;
            return oWLOntology;
        }
        return null;
    }

    public Collection<OWLOntologyChange> getChanges(Collection<OWLOntology> collection) {
        OWLOntology oWLOntology;
        ArrayList<OWLOntologyChange> arrayList = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom oWLAxiom : this.additions) {
            oWLOntology = OntologyDiff.identifyAxiomOntology(oWLAxiom, collection);
            if (null == oWLOntology) {
                throw new IllegalArgumentException("None of the ontologies contain the added axiom");
            }
            arrayList.add((OWLOntologyChange)new AddAxiom(oWLOntology, oWLAxiom));
        }
        for (OWLAxiom oWLAxiom : this.deletions) {
            oWLOntology = null;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("There are no ontologies defined that could have contained the removed axiom");
            }
            oWLOntology = collection.iterator().next();
            arrayList.add((OWLOntologyChange)new RemoveAxiom(oWLOntology, oWLAxiom));
        }
        return arrayList;
    }

    public Collection<OWLAxiom> getDeletions() {
        return this.deletions;
    }
}

