/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public abstract class OWLPropertyExpressionImpl<R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>>
extends OWLObjectImpl
implements OWLPropertyExpression<R, P> {
    private static final long serialVersionUID = 30402L;

    @Override
    public Set<R> getRanges(OWLOntology ontology) {
        TreeSet<R> result = new TreeSet<R>();
        for (OWLPropertyRangeAxiom<P, R> axiom : this.getRangeAxioms(ontology)) {
            result.add(axiom.getRange());
        }
        return result;
    }

    @Override
    public Set<R> getRanges(Set<OWLOntology> ontologies) {
        TreeSet<R> result = new TreeSet<R>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getRanges(ont));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getDomains(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLPropertyDomainAxiom<?> axiom : this.getDomainAxioms(ontology)) {
            result.add(axiom.getDomain());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getDomains(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getDomains(ont));
        }
        return result;
    }

    @Override
    public Set<P> getSuperProperties(OWLOntology ontology) {
        TreeSet<P> result = new TreeSet<P>();
        for (OWLSubPropertyAxiom<P> axiom : this.getSubPropertyAxioms(ontology)) {
            result.add(axiom.getSuperProperty());
        }
        return result;
    }

    @Override
    public Set<P> getSuperProperties(Set<OWLOntology> ontologies) {
        TreeSet<P> results = new TreeSet<P>();
        for (OWLOntology ont : ontologies) {
            results.addAll(this.getSuperProperties(ont));
        }
        return results;
    }

    @Override
    public Set<P> getSubProperties(OWLOntology ontology) {
        TreeSet<P> results = new TreeSet<P>();
        for (OWLSubPropertyAxiom<P> axiom : this.getSubPropertyAxiomsForRHS(ontology)) {
            results.add(axiom.getSubProperty());
        }
        return results;
    }

    @Override
    public Set<P> getSubProperties(Set<OWLOntology> ontologies) {
        TreeSet<P> result = new TreeSet<P>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSubProperties(ont));
        }
        return result;
    }

    protected abstract Set<? extends OWLSubPropertyAxiom<P>> getSubPropertyAxiomsForRHS(OWLOntology var1);

    @Override
    public Set<P> getEquivalentProperties(OWLOntology ontology) {
        return this.getProperties(this.getEquivalentPropertiesAxioms(ontology));
    }

    @Override
    public Set<P> getEquivalentProperties(Set<OWLOntology> ontologies) {
        TreeSet<P> result = new TreeSet<P>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getEquivalentProperties(ont));
        }
        return result;
    }

    @Override
    public Set<P> getDisjointProperties(OWLOntology ontology) {
        return this.getProperties(this.getDisjointPropertiesAxioms(ontology));
    }

    @Override
    public Set<P> getDisjointProperties(Set<OWLOntology> ontologies) {
        TreeSet<P> result = new TreeSet<P>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getDisjointProperties(ont));
        }
        return result;
    }

    protected abstract Set<? extends OWLPropertyDomainAxiom<?>> getDomainAxioms(OWLOntology var1);

    protected abstract Set<? extends OWLPropertyRangeAxiom<P, R>> getRangeAxioms(OWLOntology var1);

    protected abstract Set<? extends OWLSubPropertyAxiom<P>> getSubPropertyAxioms(OWLOntology var1);

    protected abstract Set<? extends OWLNaryPropertyAxiom<P>> getEquivalentPropertiesAxioms(OWLOntology var1);

    protected abstract Set<? extends OWLNaryPropertyAxiom<P>> getDisjointPropertiesAxioms(OWLOntology var1);

    private <Prop extends OWLPropertyExpression<?, ?>> Set<Prop> getProperties(Set<? extends OWLNaryPropertyAxiom<Prop>> axioms) {
        TreeSet<Prop> result = new TreeSet<Prop>();
        for (OWLNaryPropertyAxiom<Prop> axiom : axioms) {
            result.addAll(axiom.getProperties());
        }
        result.remove(this);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return obj instanceof OWLPropertyExpression;
        }
        return false;
    }
}

