/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.out.SinkQuadOutput;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class infer
extends CmdGeneral {
    static final ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private Model vocab;

    public static void main(String ... argv) {
        new infer(argv).mainRun();
    }

    protected infer(String[] argv) {
        super(argv);
        super.add(argRDFS);
    }

    @Override
    protected String getSummary() {
        return "infer --rdfs=vocab FILE ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!this.contains(argRDFS)) {
            throw new CmdException("Required argument missing: --" + argRDFS.getKeyName());
        }
        String fn = this.getValue(argRDFS);
        this.vocab = FileManager.get().loadModel(fn);
    }

    @Override
    protected void exec() {
        Sink<Quad> sink = new SinkQuadOutput(System.out);
        sink = InfFactory.infQuads(sink, this.vocab);
        List<String> files = this.getPositionalOrStdin();
        if (files.isEmpty()) {
            files.add("-");
        }
        for (String fn : files) {
            this.processFile(fn, sink);
        }
        IO.flush(System.out);
    }

    private void processFile(String filename, Sink<Quad> qsink) {
        Lang lang = filename.equals("-") ? RDFLanguages.NQUADS : RDFLanguages.filenameToLang(filename, RDFLanguages.NQUADS);
        String baseURI = IRILib.filenameToIRI(filename);
        StreamRDF sink = StreamRDFLib.sinkQuads(qsink);
        if (RDFLanguages.isTriples(lang)) {
            InputStream in = IO.openFile(filename);
            sink = StreamRDFLib.extendTriplesToQuads(sink);
            LangRIOT parser = RiotReader.createParser(in, lang, baseURI, sink);
            parser.parse();
            return;
        }
        InputStream in = IO.openFile(filename);
        LangRIOT parser = RiotReader.createParser(in, lang, baseURI, sink);
        parser.parse();
    }

    @Override
    protected String getCommandName() {
        return "infer";
    }
}

