/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.sparql.lang.ParserBase;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.OutputUtils;

public class EscapeStr {
    private final boolean ascii;

    public EscapeStr(boolean asciiOnly) {
        this.ascii = asciiOnly;
    }

    public void writeURI(Writer w, String s) {
        try {
            if (this.ascii) {
                EscapeStr.stringEsc(w, s, true, this.ascii);
            } else {
                w.write(s);
            }
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    public void writeStr(Writer w, String s) {
        try {
            EscapeStr.stringEsc(w, s, true, this.ascii);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    public void writeStrMultiLine(Writer w, String s) {
        try {
            EscapeStr.stringEsc(w, s, false, this.ascii);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    public static String stringEsc(String s) {
        return EscapeStr.stringEsc(s, true, false);
    }

    private static String stringEsc(String s, boolean singleLineString, boolean asciiOnly) {
        try {
            StringWriter sb = new StringWriter();
            EscapeStr.stringEsc(sb, s, singleLineString, asciiOnly);
            return ((Object)sb).toString();
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }

    public static void stringEsc(Writer out, String s, boolean singleLineString, boolean asciiOnly) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                out.write(92);
                out.write(c);
                continue;
            }
            if (singleLineString) {
                if (c == '\"') {
                    out.write("\\\"");
                    continue;
                }
                if (c == '\n') {
                    out.write("\\n");
                    continue;
                }
                if (c == '\t') {
                    out.write("\\t");
                    continue;
                }
                if (c == '\r') {
                    out.write("\\r");
                    continue;
                }
                if (c == '\f') {
                    out.write("\\f");
                    continue;
                }
            }
            if (c >= ' ' && c < '\u007f') {
                out.write(c);
                continue;
            }
            if (!asciiOnly) {
                out.write(c);
                continue;
            }
            out.write("\\u");
            OutputUtils.printHex(out, (int)c, 4);
        }
    }

    public static String unescapeStr(String s) {
        return EscapeStr.unescape(s, '\\');
    }

    public static String unescape(String s, char escape) {
        return ParserBase.unescape(s, escape, false, -1, -1);
    }
}

