/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;

public class TemplateLib {
    public static Iterator<Quad> template(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        quads = TemplateLib.remapDefaultGraph(quads, dftGraph);
        return TemplateLib.calcQuads(quads, bindings2);
    }

    protected static List<Quad> remapDefaultGraph(List<Quad> quads, final Node dftGraph) {
        if (dftGraph != null) {
            Transform<Quad, Quad> nt = new Transform<Quad, Quad>(){

                @Override
                public Quad convert(Quad quad) {
                    if (!quad.isDefaultGraph()) {
                        return quad;
                    }
                    return new Quad(dftGraph, quad.getSubject(), quad.getPredicate(), quad.getObject());
                }
            };
            quads = Iter.map(quads, nt);
        }
        return quads;
    }

    public static Iterator<Triple> calcTriples(final List<Triple> triples, Iterator<Binding> bindings2) {
        return Iter.mapMany(bindings2, new Transform<Binding, Iterator<Triple>>(){
            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();

            @Override
            public Iterator<Triple> convert(Binding b) {
                this.bNodeMap.clear();
                ArrayList<Triple> tripleList = new ArrayList<Triple>(triples.size());
                for (Triple triple : triples) {
                    Triple q = TemplateLib.subst(triple, b, this.bNodeMap);
                    if (!q.isConcrete() || !ModelUtils.isValidAsStatement(q.getSubject(), q.getPredicate(), q.getObject())) continue;
                    tripleList.add(q);
                }
                return tripleList.iterator();
            }
        });
    }

    public static Iterator<Quad> calcQuads(final List<Quad> quads, Iterator<Binding> bindings2) {
        return Iter.mapMany(bindings2, new Transform<Binding, Iterator<Quad>>(){
            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();

            @Override
            public Iterator<Quad> convert(Binding b) {
                this.bNodeMap.clear();
                ArrayList<Quad> quadList = new ArrayList<Quad>(quads.size());
                for (Quad quad : quads) {
                    Quad q = TemplateLib.subst(quad, b, this.bNodeMap);
                    if (!q.isConcrete()) continue;
                    quadList.add(q);
                }
                return quadList.iterator();
            }
        });
    }

    public static Quad subst(Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = g;
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (g1.isBlank() || Var.isBlankNodeVar(g1)) {
            g1 = TemplateLib.newBlank(g1, bNodeMap);
        }
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Quad q = quad;
        if (s1 != s || p1 != p || o1 != o || g1 != g) {
            q = new Quad(g1, s1, p1, o1);
        }
        Quad q2 = Substitute.substitute(q, b);
        return q2;
    }

    public static Triple subst(Triple triple, Binding b, Map<Node, Node> bNodeMap) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (s1.isBlank() || Var.isBlankNodeVar(s1)) {
            s1 = TemplateLib.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank() || Var.isBlankNodeVar(p1)) {
            p1 = TemplateLib.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank() || Var.isBlankNodeVar(o1)) {
            o1 = TemplateLib.newBlank(o1, bNodeMap);
        }
        Triple t = triple;
        if (s1 != s || p1 != p || o1 != o) {
            t = new Triple(s1, p1, o1);
        }
        Triple t2 = Substitute.substitute(t, b);
        return t2;
    }

    private static Node newBlank(Node n, Map<Node, Node> bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return bNodeMap.get(n);
    }
}

