/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class BitIntSet
implements IntSet {
    private BitSet bits;

    public BitIntSet() {
        this.bits = new BitSet();
    }

    public BitIntSet(BitIntSet bitIntSet) {
        this.bits = (BitSet)bitIntSet.bits.clone();
    }

    @Override
    public void add(int n) {
        if (n < 0) {
            throw new UnsupportedOperationException("Negatibe integers cannot be added to this set");
        }
        this.bits.set(n);
    }

    @Override
    public void addAll(IntSet intSet) {
        if (intSet instanceof BitIntSet) {
            this.bits.or(((BitIntSet)intSet).bits);
        } else {
            IntIterator intIterator = intSet.iterator();
            while (intIterator.hasNext()) {
                this.add(intIterator.next());
            }
        }
    }

    @Override
    public boolean contains(int n) {
        return this.bits.get(n);
    }

    @Override
    public IntSet copy() {
        return new BitIntSet(this);
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int next;
            {
                this.next = BitIntSet.this.bits.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public int next() {
                int n = this.next;
                if (n == -1) {
                    throw new NoSuchElementException();
                }
                this.next = BitIntSet.this.bits.nextSetBit(0);
                return n;
            }
        };
    }

    @Override
    public int max() {
        return this.bits.length() - 1;
    }

    @Override
    public int min() {
        return this.bits.nextSetBit(0);
    }

    @Override
    public void remove(int n) {
        if (n >= 0) {
            this.bits.clear(n);
        }
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public IntSet union(IntSet intSet) {
        IntSet intSet2 = this.copy();
        intSet2.addAll(intSet);
        return intSet2;
    }
}

