/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATerm;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import org.mindswap.pellet.utils.NumberUtils;

public class Comparators {
    public static final Comparator<Comparable<Object>> comparator = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable.compareTo(comparable2);
        }
    };
    public static final Comparator<ATerm> termComparator = new Comparator<ATerm>(){

        @Override
        public int compare(ATerm aTerm, ATerm aTerm2) {
            int n;
            int n2 = aTerm.hashCode();
            if (n2 < (n = aTerm2.hashCode())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            if (aTerm == aTerm2) {
                return 0;
            }
            return aTerm.toString().compareTo(aTerm2.toString());
        }
    };
    public static final Comparator<Number> numberComparator = new Comparator<Number>(){

        @Override
        public int compare(Number number, Number number2) {
            return NumberUtils.compare(number, number2);
        }
    };
    public static final Comparator<Object> stringComparator = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }
    };
    public static final Comparator<Calendar> calendarComparator = new Comparator<Calendar>(){

        @Override
        public int compare(Calendar calendar, Calendar calendar2) {
            long l;
            long l2 = calendar.getTimeInMillis();
            if (l2 < (l = calendar2.getTimeInMillis())) {
                return -1;
            }
            if (l2 == l) {
                return 0;
            }
            return 1;
        }
    };

    public static <T> Comparator<T> reverse(Comparator<T> comparator) {
        return Collections.reverseOrder(comparator);
    }
}

