/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;

public class FunctionalTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    private Taxonomy<T> taxonomy;
    private PrintWriter out;
    private Set<T> bottomEquivalents;
    private Set<T> printed;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<T> taxonomy, PrintWriter printWriter) {
        this.taxonomy = taxonomy;
        this.out = printWriter;
        this.bottomEquivalents = new TreeSet<Object>(Comparators.stringComparator);
        this.bottomEquivalents.addAll(taxonomy.getBottom().getEquivalents());
        this.printed = new HashSet<T>();
        printWriter.println();
        TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
        treeSet.addAll(taxonomy.getTop().getEquivalents());
        Set<TreeSet<Object>> set = Collections.singleton(treeSet);
        this.printGroup(set);
        this.taxonomy = null;
        this.out = null;
        this.bottomEquivalents = null;
        this.printed = null;
        printWriter.println();
        printWriter.flush();
    }

    private void printGroup(Collection<? extends Collection<T>> collection) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Collection<T> collection2 : collection) {
            Set<Object> set;
            T t = collection2.iterator().next();
            Set<Set<T>> set2 = this.taxonomy.getSupers(t, true);
            if (set2.size() > 1 && this.printed.contains(t)) continue;
            this.printed.add(t);
            this.out.print("(");
            this.printEqClass(collection2);
            this.out.print(" ");
            TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.stringComparator);
            Object object = set2.iterator();
            while (object.hasNext()) {
                set = new TreeSet<Object>(Comparators.stringComparator);
                set.addAll((Collection<Object>)object.next());
                treeSet.add(set);
            }
            this.printEqClassGroups(treeSet);
            this.out.print(" ");
            object = new TreeSet<Object>(Comparators.stringComparator);
            set = this.taxonomy.getSubs(t, true);
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                TreeSet<Object> treeSet2 = new TreeSet<Object>(Comparators.stringComparator);
                treeSet2.addAll((Collection)iterator.next());
                object.add(treeSet2);
            }
            this.printEqClassGroups((Collection<? extends Collection<T>>)object);
            linkedHashSet.addAll(object);
            this.out.println(")");
        }
        switch (linkedHashSet.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.printGroup(linkedHashSet);
                break;
            }
            default: {
                linkedHashSet.remove(this.bottomEquivalents);
                this.printGroup(linkedHashSet);
            }
        }
    }

    private void printEqClass(Collection<T> collection) {
        int n = collection.size();
        T t2 = null;
        switch (n) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                t2 = collection.iterator().next();
                this.printURI(t2);
                break;
            }
            default: {
                this.out.print("(");
                boolean bl = true;
                for (T t2 : collection) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printURI(t2);
                }
                this.out.print(")");
            }
        }
    }

    private void printEqClassGroups(Collection<? extends Collection<T>> collection) {
        int n = collection.size();
        Collection<T> collection22 = null;
        switch (n) {
            case 0: {
                this.out.print("NIL");
                break;
            }
            case 1: {
                collection22 = collection.iterator().next();
                this.out.print("(");
                this.printEqClass(collection22);
                this.out.print(")");
                break;
            }
            default: {
                this.out.print("(");
                boolean bl = true;
                for (Collection<T> collection22 : collection) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.out.print(" ");
                    }
                    this.printEqClass(collection22);
                }
                this.out.print(")");
            }
        }
    }

    private void printURI(T t) {
        String string = t.toString();
        if (t.equals(ATermUtils.TOP)) {
            string = "http://www.w3.org/2002/07/owl#Thing";
        } else if (t.equals(ATermUtils.BOTTOM)) {
            string = "http://www.w3.org/2002/07/owl#Nothing";
        }
        this.out.print(string);
    }
}

