/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import java.util.logging.Logger;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;

public abstract class AbstractTableauRule
implements TableauRule {
    public static final Logger log = Logger.getLogger(AbstractTableauRule.class.getName());
    protected CompletionStrategy strategy;
    protected NodeSelector nodeSelector;
    protected BlockingType blockingType;

    public AbstractTableauRule(CompletionStrategy completionStrategy, NodeSelector nodeSelector, BlockingType blockingType) {
        this.strategy = completionStrategy;
        this.nodeSelector = nodeSelector;
        this.blockingType = blockingType;
    }

    public boolean isDisabled() {
        return false;
    }

    @Override
    public void apply(IndividualIterator individualIterator) {
        individualIterator.reset(this.nodeSelector);
        while (individualIterator.hasNext()) {
            Individual individual = individualIterator.next();
            if (this.strategy.getBlocking().isBlocked(individual)) {
                if (!PelletOptions.USE_COMPLETION_QUEUE) continue;
                this.addQueueElement(individual);
                continue;
            }
            this.apply(individual);
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }

    protected boolean isBlocked(Individual individual) {
        switch (this.blockingType) {
            case NONE: {
                return false;
            }
            case DIRECT: {
                return this.strategy.getBlocking().isDirectlyBlocked(individual);
            }
            case INDIRECT: {
                return this.strategy.getBlocking().isIndirectlyBlocked(individual);
            }
            case COMPLETE: {
                return this.strategy.getBlocking().isBlocked(individual);
            }
        }
        throw new AssertionError();
    }

    protected void addQueueElement(Node node) {
        this.strategy.getABox().getCompletionQueue().add(new QueueElement(node), this.nodeSelector);
    }

    protected static enum BlockingType {
        NONE,
        DIRECT,
        INDIRECT,
        COMPLETE;

    }
}

