/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.queue;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.queue.CompletionQueue;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;

public class OptimizedBasicCompletionQueue
extends CompletionQueue {
    protected List<ATermAppl>[] queue;
    protected Set<ATermAppl>[] newQueue;
    protected List<ATermAppl>[] newQueueList;
    protected int[] current;
    protected int[] end;
    protected int[] cutOff;
    protected boolean backtracked;

    public OptimizedBasicCompletionQueue(ABox aBox) {
        super(aBox);
        int n = NodeSelector.numSelectors();
        this.queue = new ArrayList[n];
        this.newQueue = new HashSet[n];
        this.newQueueList = new ArrayList[n];
        this.current = new int[n];
        this.cutOff = new int[n];
        this.end = new int[n];
        for (int i = 0; i < n; ++i) {
            this.queue[i] = new ArrayList<ATermAppl>();
            this.newQueue[i] = new HashSet<ATermAppl>();
            this.newQueueList[i] = new ArrayList<ATermAppl>();
            this.current[i] = 0;
            this.cutOff[i] = 0;
            this.end[i] = 0;
        }
        this.backtracked = false;
    }

    @Override
    protected void findNext(int n) {
        Node node;
        while (!(this.current[n] >= this.cutOff[n] || (node = this.abox.getNode((ATerm)this.queue[n].get(this.current[n]))) != null && ((node = node.getSame()) instanceof Literal && this.allowLiterals() || node instanceof Individual && !this.allowLiterals()) && !node.isPruned())) {
            int n2 = n;
            this.current[n2] = this.current[n2] + 1;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(this.currentType);
        return this.current[this.currentType] < this.cutOff[this.currentType];
    }

    @Override
    public void restore(int n) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
            this.current[i] = 0;
            this.cutOff[i] = this.end[i];
        }
        this.backtracked = true;
    }

    @Override
    public Individual next() {
        this.findNext(this.currentType);
        Individual individual = (Individual)this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        individual = individual.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return individual;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(this.currentType);
        Node node = this.abox.getNode((ATerm)this.queue[this.currentType].get(this.current[this.currentType]));
        node = node.getSame();
        int n = this.currentType;
        this.current[n] = this.current[n] + 1;
        return node;
    }

    @Override
    public void add(QueueElement queueElement, NodeSelector nodeSelector) {
        int n = nodeSelector.ordinal();
        if (!this.newQueue[n].contains(queueElement.getNode())) {
            this.newQueue[n].add(queueElement.getNode());
            this.newQueueList[n].add(queueElement.getNode());
        }
    }

    @Override
    public void add(QueueElement queueElement) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (this.newQueue[i].contains(queueElement.getNode())) continue;
            this.newQueue[i].add(queueElement.getNode());
            this.newQueueList[i].add(queueElement.getNode());
        }
    }

    @Override
    public void reset(NodeSelector nodeSelector) {
        this.currentType = nodeSelector.ordinal();
        this.cutOff[this.currentType] = this.end[this.currentType];
        this.current[this.currentType] = 0;
    }

    @Override
    public void incrementBranch(int n) {
    }

    @Override
    public OptimizedBasicCompletionQueue copy() {
        OptimizedBasicCompletionQueue optimizedBasicCompletionQueue = new OptimizedBasicCompletionQueue(this.abox);
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            optimizedBasicCompletionQueue.queue[i] = new ArrayList<ATermAppl>(this.queue[i]);
            optimizedBasicCompletionQueue.newQueue[i] = new HashSet<ATermAppl>(this.newQueue[i]);
            optimizedBasicCompletionQueue.newQueueList[i] = new ArrayList<ATermAppl>(this.newQueueList[i]);
            optimizedBasicCompletionQueue.current[i] = this.current[i];
            optimizedBasicCompletionQueue.cutOff[i] = this.cutOff[i];
            optimizedBasicCompletionQueue.end[i] = this.end[i];
        }
        optimizedBasicCompletionQueue.backtracked = this.backtracked;
        optimizedBasicCompletionQueue.setAllowLiterals(this.allowLiterals());
        return optimizedBasicCompletionQueue;
    }

    @Override
    public void setABox(ABox aBox) {
        this.abox = aBox;
    }

    @Override
    public void print(int n) {
        if (n > NodeSelector.numSelectors()) {
            return;
        }
        System.out.println("Queue " + n + ": " + this.queue[n]);
    }

    @Override
    public void print() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            System.out.println("Queue " + i + ": " + this.queue[i]);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }

    @Override
    public void flushQueue() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (!this.backtracked && !this.closed) {
                this.queue[i].clear();
            } else if (this.closed && !this.abox.isClosed()) {
                this.closed = false;
            }
            this.queue[i].addAll(this.newQueueList[i]);
            this.newQueue[i].clear();
            this.newQueueList[i].clear();
            this.end[i] = this.queue[i].size();
        }
        this.backtracked = false;
    }

    @Override
    protected void flushQueue(NodeSelector nodeSelector) {
        int n = nodeSelector.ordinal();
        if (n == NodeSelector.UNIVERSAL.ordinal() || !this.backtracked) {
            this.queue[n].clear();
        }
        this.queue[n].addAll(this.newQueueList[n]);
        this.newQueue[n].clear();
        this.newQueueList[n].clear();
        this.end[n] = this.queue[n].size();
    }

    @Override
    public void clearQueue(NodeSelector nodeSelector) {
        int n = nodeSelector.ordinal();
        this.queue[n].clear();
        this.newQueue[n].clear();
        this.newQueueList[n].clear();
        this.end[n] = this.queue[n].size();
    }
}

