/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.UnaryAtom;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;

public class RuleBranch
extends Branch {
    private RuleAtomAsserter ruleAtomAsserter;
    private VariableBinding binding;
    private List<RuleAtom> atoms;
    private int bodyAtomCount;
    private int[] order;
    private DependencySet[] prevDS;

    public RuleBranch(ABox aBox, CompletionStrategy completionStrategy, RuleAtomAsserter ruleAtomAsserter, List<RuleAtom> list, VariableBinding variableBinding, int n, DependencySet dependencySet) {
        super(aBox, completionStrategy, dependencySet, list.size());
        this.ruleAtomAsserter = ruleAtomAsserter;
        this.atoms = list;
        this.bodyAtomCount = n;
        this.binding = variableBinding;
        this.prevDS = new DependencySet[list.size()];
        this.order = new int[list.size()];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public RuleBranch copyTo(ABox aBox) {
        RuleBranch ruleBranch = new RuleBranch(aBox, this.strategy, this.ruleAtomAsserter, this.atoms, this.binding, this.bodyAtomCount, this.getTermDepends());
        ruleBranch.setAnonCount(this.getAnonCount());
        ruleBranch.setNodeCount(this.nodeCount);
        ruleBranch.setBranch(this.branch);
        ruleBranch.setTryNext(this.tryNext);
        ruleBranch.prevDS = new DependencySet[this.prevDS.length];
        System.arraycopy(this.prevDS, 0, ruleBranch.prevDS, 0, this.tryNext);
        ruleBranch.order = new int[this.order.length];
        System.arraycopy(this.order, 0, ruleBranch.order, 0, this.order.length);
        return ruleBranch;
    }

    @Override
    public void setLastClash(DependencySet dependencySet) {
        super.setLastClash(dependencySet);
        if (this.tryNext >= 0) {
            this.prevDS[this.tryNext] = dependencySet;
        }
    }

    @Override
    protected void tryBranch() {
        this.abox.incrementBranch();
        while (this.tryNext < this.tryCount) {
            DependencySet dependencySet;
            RuleAtom ruleAtom = this.atoms.get(this.tryNext);
            DependencySet dependencySet2 = null;
            if (this.tryNext == this.tryCount - 1 && !PelletOptions.SATURATE_TABLEAU) {
                dependencySet2 = this.getTermDepends();
                for (int i = 0; i < this.tryNext; ++i) {
                    dependencySet2 = dependencySet2.union(this.prevDS[i], this.abox.doExplanation());
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    dependencySet2.setExplain(this.getTermDepends().getExplain());
                } else {
                    dependencySet2.remove(this.getBranch());
                }
            } else {
                dependencySet2 = PelletOptions.USE_INCREMENTAL_DELETION ? this.getTermDepends().union(new DependencySet(this.getBranch()), this.abox.doExplanation()) : new DependencySet(this.getBranch());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("RULE: Branch (" + this.getBranch() + ") try (" + (this.tryNext + 1) + "/" + this.tryCount + ") " + ruleAtom + " " + this.binding + " " + this.atoms + " " + dependencySet2);
            }
            this.ruleAtomAsserter.assertAtom(ruleAtom, this.binding, dependencySet2, this.tryNext < this.bodyAtomCount, this.abox, this.strategy);
            if (this.abox.isClosed()) {
                dependencySet = this.abox.getClash().getDepends();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + Clash.unexplained(null, dependencySet) + "!");
                }
                if (this.tryNext >= this.tryCount - 1 || !dependencySet.contains(this.getBranch())) {
                    this.abox.setClash(Clash.unexplained(null, dependencySet.union(dependencySet2, this.abox.doExplanation())));
                    if (PelletOptions.USE_INCREMENTAL_DELETION) {
                        this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().getDepends());
                    }
                    return;
                }
            } else {
                return;
            }
            AtomIObject atomIObject = (AtomIObject)(ruleAtom instanceof UnaryAtom ? ((UnaryAtom)ruleAtom).getArgument() : ((BinaryAtom)ruleAtom).getArgument1());
            Individual individual = this.binding.get(atomIObject);
            this.strategy.restoreLocal(individual, this);
            this.abox.incrementBranch();
            this.setLastClash(dependencySet);
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int n) {
    }
}

