/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import com.clarkparsia.pellet.utils.IdentityHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <K, V> Map<K, V> makeIdentityMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> makeIdentityMap(int n) {
        return new IdentityHashMap(n);
    }

    public static <K, V> Map<K, V> makeIdentityMap(Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <T> Set<T> makeIdentitySet() {
        return new IdentityHashSet();
    }

    public static <T> Set<T> makeIdentitySet(int n) {
        return new IdentityHashSet(n);
    }

    public static <T> Set<T> makeIdentitySet(Collection<? extends T> collection) {
        return new IdentityHashSet<T>(collection);
    }

    public static <T> List<T> makeList() {
        return new ArrayList();
    }

    public static <T> List<T> makeList(int n) {
        return new ArrayList(n);
    }

    public static <T> List<T> makeList(Collection<? extends T> collection) {
        return new ArrayList<T>(collection);
    }

    public static <K, V> Map<K, V> makeMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> makeMap(int n) {
        return new HashMap(n);
    }

    public static <K, V> Map<K, V> makeMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <T> Set<T> makeSet() {
        return new HashSet();
    }

    public static <T> Set<T> makeSet(int n) {
        return new HashSet(n);
    }

    public static <T> Set<T> makeSet(Collection<? extends T> collection) {
        return new HashSet<T>(collection);
    }
}

