/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class StringOperators {
    public static final Tester contains = new Contains();
    public static final Tester containsIgnoreCase = new ContainsIgnoreCase();
    public static final Tester endsWith = new EndsWith();
    public static final Function lowerCase = new StringFunctionAdapter(new LowerCase());
    public static final Tester matches = new Matches();
    public static final Function normalizeSpace = new StringFunctionAdapter(new NormalizeSpace());
    public static final Function replace = new StringFunctionAdapter(new Replace());
    public static final Tester startsWith = new StartsWith();
    public static final Function stringConcat = new StringFunctionAdapter(new StringConcat());
    public static final Tester stringEqualIgnoreCase = new StringEqualIgnoreCase();
    public static final Function stringLength = new StringLength();
    public static final Function substring = new StringFunctionAdapter(new SubString());
    public static final Function substringAfter = new StringFunctionAdapter(new SubStringAfter());
    public static final Function substringBefore = new StringFunctionAdapter(new SubStringBefore());
    public static final BuiltIn tokenize = new Tokenize();
    public static final Function translate = new StringFunctionAdapter(new Translate());
    public static final Function upperCase = new StringFunctionAdapter(new UpperCase());

    private static class UpperCase
    implements StringToStringFunction {
        private UpperCase() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 1) {
                return null;
            }
            return stringArray[0].toUpperCase();
        }
    }

    private static class Translate
    implements StringToStringFunction {
        private Translate() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 3) {
                return null;
            }
            String string = stringArray[1];
            String string2 = stringArray[2];
            StringBuffer stringBuffer = new StringBuffer();
            for (char c : stringArray[0].toCharArray()) {
                int n = string.indexOf(c);
                if (n < 0) {
                    stringBuffer.append(c);
                    continue;
                }
                if (n >= string2.length()) continue;
                stringBuffer.append(string2.charAt(n));
            }
            return stringBuffer.toString();
        }
    }

    private static class Tokenize
    implements BuiltIn {
        @Override
        public BindingHelper createHelper(BuiltInAtom builtInAtom) {
            return new TokenizeBindingHelper(builtInAtom);
        }

        private static class TokenizeBindingHelper
        implements BindingHelper {
            private BuiltInAtom atom;
            private AtomDObject head;
            private String match;
            private Iterator<String> tokens;

            public TokenizeBindingHelper(BuiltInAtom builtInAtom) {
                this.atom = builtInAtom;
                this.head = null;
                this.match = null;
                this.tokens = null;
            }

            @Override
            public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> collection) {
                this.head = null;
                for (AtomDObject atomDObject : this.atom.getAllArguments()) {
                    if (this.head == null) {
                        this.head = atomDObject;
                        if (VariableUtils.isVariable(this.head)) continue;
                        return Collections.emptySet();
                    }
                    if (!this.head.equals(atomDObject)) continue;
                    return Collections.emptySet();
                }
                if (this.head == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton((AtomVariable)((Object)this.head));
            }

            @Override
            public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> collection) {
                Collection<AtomVariable> collection2 = VariableUtils.getVars(this.atom);
                collection2.removeAll(this.getBindableVars(collection));
                return collection2;
            }

            @Override
            public void rebind(VariableBinding variableBinding) {
                if (this.atom.getAllArguments().size() < 3) {
                    this.tokens = null;
                    return;
                }
                Literal literal = variableBinding.get((AtomDObject)this.atom.getAllArguments().get(0));
                if (literal != null) {
                    this.match = ATermUtils.getLiteralValue(literal.getTerm());
                }
                String string = ATermUtils.getLiteralValue(variableBinding.get((AtomDObject)this.atom.getAllArguments().get(1)).getTerm());
                String string2 = ATermUtils.getLiteralValue(variableBinding.get((AtomDObject)this.atom.getAllArguments().get(2)).getTerm());
                String[] stringArray = string.split(string2);
                this.tokens = Arrays.asList(stringArray).iterator();
                if (this.match != null) {
                    while (this.tokens.hasNext()) {
                        String string3 = this.tokens.next();
                        if (!string3.equals(this.match)) continue;
                        this.tokens = Collections.singleton(string3).iterator();
                        break;
                    }
                }
            }

            @Override
            public boolean selectNextBinding() {
                if (this.tokens != null && this.tokens.hasNext()) {
                    this.match = this.tokens.next();
                    return true;
                }
                return false;
            }

            @Override
            public void setCurrentBinding(VariableBinding variableBinding) {
                if (VariableUtils.isVariable(this.head)) {
                    ATermAppl aTermAppl = ATermUtils.makePlainLiteral(this.match);
                    Literal literal = variableBinding.getABox().addLiteral(aTermAppl);
                    variableBinding.set(this.head, literal);
                }
            }
        }
    }

    private static class SubStringBefore
    implements StringToStringFunction {
        private SubStringBefore() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 2) {
                return null;
            }
            if (stringArray[1].equals("")) {
                return "";
            }
            int n = stringArray[0].indexOf(stringArray[1]);
            if (n < 0) {
                return "";
            }
            return stringArray[0].substring(0, n);
        }
    }

    private static class SubStringAfter
    implements StringToStringFunction {
        private SubStringAfter() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 2) {
                return null;
            }
            if (stringArray[1].equals("")) {
                return "";
            }
            int n = stringArray[0].indexOf(stringArray[1]);
            if (n < 0) {
                return "";
            }
            return stringArray[0].substring(n + stringArray[1].length());
        }
    }

    private static class SubString
    implements StringToStringFunction {
        private SubString() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length < 2 || stringArray.length > 3) {
                return null;
            }
            long l = 0L;
            long l2 = stringArray[0].length();
            try {
                Double d = new Double(stringArray[1]);
                long l3 = d.isNaN() || d > 2.147483647E9 ? Integer.MAX_VALUE : Math.round(d);
                long l4 = Integer.MAX_VALUE;
                if (stringArray.length == 3) {
                    Double d2 = new Double(stringArray[2]);
                    l4 = d2.isNaN() || d2 < 0.0 ? 0L : Math.round(d2);
                }
                l = Math.min((long)stringArray[0].length(), Math.max(0L, l3 - 1L));
                l2 = Math.min((long)stringArray[0].length(), Math.max(l, l3 + l4 - 1L));
            }
            catch (NumberFormatException numberFormatException) {
                return "";
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            return stringArray[0].substring((int)l, (int)l2);
        }
    }

    private static class StringLength
    implements Function {
        private StringLength() {
        }

        @Override
        public Literal apply(ABox aBox, Literal literal, Literal ... literalArray) {
            if (literalArray.length != 1) {
                return null;
            }
            String string = ATermUtils.getLiteralValue(literalArray[0].getTerm());
            String string2 = Integer.toString(string.length());
            Literal literal2 = aBox.addLiteral(ATermUtils.makeTypedLiteral(string2, "http://www.w3.org/2001/XMLSchema#integer"));
            return ComparisonTesters.expectedIfEquals(literal, literal2);
        }
    }

    private static class StringEqualIgnoreCase
    extends BinaryTester {
        private StringEqualIgnoreCase() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getName();
            ATermAppl aTermAppl2 = literal2.getName();
            String string = ATermUtils.getLiteralValue(aTermAppl);
            String string2 = ATermUtils.getLiteralValue(aTermAppl2);
            return string.equalsIgnoreCase(string2);
        }
    }

    private static class StringConcat
    implements StringToStringFunction {
        private StringConcat() {
        }

        @Override
        public String apply(String ... stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : stringArray) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    private static class StartsWith
    extends BinaryTester {
        private StartsWith() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl2 = literal2.getTerm();
            String string = ATermUtils.getLiteralValue(aTermAppl);
            String string2 = ATermUtils.getLiteralValue(aTermAppl2);
            return string.startsWith(string2);
        }
    }

    private static class Replace
    implements StringToStringFunction {
        private Replace() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 3) {
                return null;
            }
            String string = stringArray[1];
            String string2 = stringArray[2];
            return stringArray[0].replace(string, string2);
        }
    }

    private static class NormalizeSpace
    implements StringToStringFunction {
        private NormalizeSpace() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 1) {
                return null;
            }
            return stringArray[0].trim().replaceAll("\\s+", " ");
        }
    }

    private static class Matches
    extends BinaryTester {
        private Matches() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl2 = literal2.getTerm();
            String string = ATermUtils.getLiteralValue(aTermAppl);
            String string2 = ATermUtils.getLiteralValue(aTermAppl2);
            boolean bl = false;
            try {
                bl = Pattern.matches(string2, string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ABox.log.info("Bad regex from builtin rule: " + literal2);
            }
            return bl;
        }
    }

    private static class LowerCase
    implements StringToStringFunction {
        private LowerCase() {
        }

        @Override
        public String apply(String ... stringArray) {
            if (stringArray.length != 1) {
                return null;
            }
            return stringArray[0].toLowerCase();
        }
    }

    private static class EndsWith
    extends BinaryTester {
        private EndsWith() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl2 = literal2.getTerm();
            String string = ATermUtils.getLiteralValue(aTermAppl);
            String string2 = ATermUtils.getLiteralValue(aTermAppl2);
            return string.endsWith(string2);
        }
    }

    private static class ContainsIgnoreCase
    extends BinaryTester {
        private ContainsIgnoreCase() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl2 = literal2.getTerm();
            String string = ATermUtils.getLiteralValue(aTermAppl).toLowerCase();
            String string2 = ATermUtils.getLiteralValue(aTermAppl2).toLowerCase();
            return string.contains(string2);
        }
    }

    private static class Contains
    extends BinaryTester {
        private Contains() {
        }

        @Override
        protected boolean test(Literal literal, Literal literal2) {
            ATermAppl aTermAppl = literal.getTerm();
            ATermAppl aTermAppl2 = literal2.getTerm();
            String string = ATermUtils.getLiteralValue(aTermAppl);
            String string2 = ATermUtils.getLiteralValue(aTermAppl2);
            return string.contains(string2);
        }
    }
}

