/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AnnotationClasses;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MultiValueMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

public class PelletVisitor
implements OWLObjectVisitor {
    private static final long serialVersionUID = 8211773146996997500L;
    public static Logger log = Logger.getLogger(PelletVisitor.class.getName());
    private KnowledgeBase kb;
    private ATermAppl term;
    private AtomDObject swrlDObject;
    private AtomIObject swrlIObject;
    private RuleAtom swrlAtom;
    private boolean addAxioms;
    private boolean reloadRequired;
    private Set<OWLAxiom> unsupportedAxioms;
    private MultiValueMap<OWLObjectProperty, OWLObjectPropertyAxiom> compositePropertyAxioms;
    private Set<OWLObjectProperty> simpleProperties;

    public PelletVisitor(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.clear();
    }

    public void clear() {
        this.unsupportedAxioms = new HashSet<OWLAxiom>();
        this.compositePropertyAxioms = new MultiValueMap();
        this.simpleProperties = new HashSet<OWLObjectProperty>();
    }

    private void addUnsupportedAxiom(OWLAxiom oWLAxiom) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException("Axiom: " + oWLAxiom);
        }
        if (this.unsupportedAxioms.add(oWLAxiom)) {
            log.warning("Ignoring unsupported axiom: " + oWLAxiom);
        }
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return new HashSet<OWLAxiom>(this.unsupportedAxioms);
    }

    private OWLObjectProperty getNamedProperty(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        if (oWLObjectPropertyExpression.isAnonymous()) {
            return this.getNamedProperty(((OWLObjectInverseOf)oWLObjectPropertyExpression).getInverse());
        }
        return oWLObjectPropertyExpression.asOWLObjectProperty();
    }

    private void addSimpleProperty(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        if (!this.addAxioms) {
            return;
        }
        OWLObjectProperty oWLObjectProperty = this.getNamedProperty(oWLObjectPropertyExpression);
        this.simpleProperties.add(oWLObjectProperty);
        oWLObjectProperty.accept((OWLObjectVisitor)this);
        Role role = this.kb.getRBox().getRole((ATerm)this.term);
        role.setForceSimple(true);
    }

    void verify() {
        for (Map.Entry entry : this.compositePropertyAxioms.entrySet()) {
            Object object2;
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)entry.getKey();
            if (!this.simpleProperties.contains(oWLObjectProperty)) continue;
            Set set = (Set)entry.getValue();
            for (Object object2 : set) {
                this.addUnsupportedAxiom((OWLAxiom)object2);
            }
            ATermAppl aTermAppl = ATermUtils.makeTermAppl(oWLObjectProperty.getIRI().toString());
            object2 = this.kb.getRBox().getRole((ATerm)aTermAppl);
            ((Role)object2).removeSubRoleChains();
        }
    }

    public void setAddAxiom(boolean bl) {
        this.addAxioms = bl;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public ATermAppl result() {
        return this.term;
    }

    public void reset() {
        this.term = null;
        this.reloadRequired = false;
    }

    public void visit(OWLClass oWLClass) {
        this.term = oWLClass.isOWLThing() ? ATermUtils.TOP : (oWLClass.isOWLNothing() ? ATermUtils.BOTTOM : ATermUtils.makeTermAppl(oWLClass.getIRI().toString()));
        if (this.addAxioms) {
            this.kb.addClass(this.term);
        }
    }

    public void visit(OWLAnnotationProperty oWLAnnotationProperty) {
        this.term = ATermUtils.makeTermAppl(oWLAnnotationProperty.getIRI().toString());
        if (this.addAxioms) {
            this.kb.addAnnotationProperty((ATerm)this.term);
        }
    }

    public void visit(OWLAnonymousIndividual oWLAnonymousIndividual) {
        this.term = ATermUtils.makeBnode(oWLAnonymousIndividual.toStringID());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLNamedIndividual oWLNamedIndividual) {
        this.term = ATermUtils.makeTermAppl(oWLNamedIndividual.getIRI().toString());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLObjectProperty oWLObjectProperty) {
        if (oWLObjectProperty.isOWLTopObjectProperty()) {
            this.term = ATermUtils.TOP_OBJECT_PROPERTY;
        } else if (oWLObjectProperty.isOWLBottomObjectProperty()) {
            this.term = ATermUtils.BOTTOM_OBJECT_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(oWLObjectProperty.getIRI().toString());
            if (this.addAxioms) {
                this.kb.addObjectProperty((ATerm)this.term);
            }
        }
    }

    public void visit(OWLObjectInverseOf oWLObjectInverseOf) {
        oWLObjectInverseOf.getInverse().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.term = ATermUtils.makeInv(aTermAppl);
    }

    public void visit(OWLDataProperty oWLDataProperty) {
        if (oWLDataProperty.isOWLTopDataProperty()) {
            this.term = ATermUtils.TOP_DATA_PROPERTY;
        } else if (oWLDataProperty.isOWLBottomDataProperty()) {
            this.term = ATermUtils.BOTTOM_DATA_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(oWLDataProperty.getIRI().toString());
            if (this.addAxioms) {
                this.kb.addDatatypeProperty((ATerm)this.term);
            }
        }
    }

    public void visit(OWLLiteral oWLLiteral) {
        if (oWLLiteral.isRDFPlainLiteral()) {
            String string = oWLLiteral.getLiteral();
            String string2 = oWLLiteral.getLang();
            this.term = string2 != null ? ATermUtils.makePlainLiteral(string, string2) : ATermUtils.makePlainLiteral(string);
        } else {
            String string = oWLLiteral.getLiteral();
            oWLLiteral.getDatatype().accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl = this.term;
            this.term = ATermUtils.makeTypedLiteral(string, aTermAppl.toString());
        }
    }

    public void visit(OWLDatatype oWLDatatype) {
        this.term = ATermUtils.makeTermAppl(oWLDatatype.getIRI().toString());
        this.kb.addDatatype(this.term);
    }

    public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
        Set set = oWLObjectIntersectionOf.getOperands();
        ATerm[] aTermArray = new ATerm[set.size()];
        int n = 0;
        for (OWLClassExpression oWLClassExpression : set) {
            oWLClassExpression.accept((OWLObjectVisitor)this);
            aTermArray[n++] = this.term;
        }
        ATermList aTermList = n > 0 ? ATermUtils.toSet(aTermArray, n) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(aTermList);
    }

    public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
        Set set = oWLObjectUnionOf.getOperands();
        ATerm[] aTermArray = new ATerm[set.size()];
        int n = 0;
        for (OWLClassExpression oWLClassExpression : set) {
            oWLClassExpression.accept((OWLObjectVisitor)this);
            aTermArray[n++] = this.term;
        }
        ATermList aTermList = n > 0 ? ATermUtils.toSet(aTermArray, n) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(aTermList);
    }

    public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
        OWLClassExpression oWLClassExpression = oWLObjectComplementOf.getOperand();
        oWLClassExpression.accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot((ATerm)this.term);
    }

    public void visit(OWLObjectOneOf oWLObjectOneOf) {
        Set set = oWLObjectOneOf.getIndividuals();
        ATerm[] aTermArray = new ATerm[set.size()];
        int n = 0;
        for (OWLIndividual oWLIndividual : set) {
            oWLIndividual.accept((OWLObjectVisitor)this);
            aTermArray[n++] = ATermUtils.makeValue((ATerm)this.term);
        }
        ATermList aTermList = n > 0 ? ATermUtils.toSet(aTermArray, n) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(aTermList);
    }

    public void visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
        ((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
        ((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLClassExpression)oWLObjectAllValuesFrom.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLObjectHasValue oWLObjectHasValue) {
        ((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLIndividual)oWLObjectHasValue.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty());
        ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLObjectExactCardinality.getCardinality();
        ((OWLClassExpression)oWLObjectExactCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeCard((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty());
        ((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLObjectMaxCardinality.getCardinality();
        ((OWLClassExpression)oWLObjectMaxCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeMax((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty());
        ((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLObjectMinCardinality.getCardinality();
        ((OWLClassExpression)oWLObjectMinCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeMin((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLDataExactCardinality oWLDataExactCardinality) {
        ((OWLDataPropertyExpression)oWLDataExactCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLDataExactCardinality.getCardinality();
        ((OWLDataRange)oWLDataExactCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeCard((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
        ((OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLDataMaxCardinality.getCardinality();
        ((OWLDataRange)oWLDataMaxCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeMax((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLDataMinCardinality oWLDataMinCardinality) {
        ((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        int n = oWLDataMinCardinality.getCardinality();
        ((OWLDataRange)oWLDataMinCardinality.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeMin((ATerm)aTermAppl, n, (ATerm)aTermAppl2);
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        Set set = oWLEquivalentClassesAxiom.getClassExpressions();
        int n = set.size();
        if (n > 1) {
            ATermAppl[] aTermApplArray = new ATermAppl[n];
            int n2 = 0;
            for (OWLClassExpression oWLClassExpression : set) {
                oWLClassExpression.accept((OWLObjectVisitor)this);
                aTermApplArray[n2++] = this.term;
            }
            Arrays.sort(aTermApplArray, 0, n, Comparators.termComparator);
            ATermAppl aTermAppl = aTermApplArray[0];
            for (int i = 1; i < aTermApplArray.length; ++i) {
                ATermAppl aTermAppl2 = aTermApplArray[i];
                if (this.addAxioms) {
                    this.kb.addEquivalentClass(aTermAppl, aTermAppl2);
                    continue;
                }
                ATermAppl aTermAppl3 = ATermUtils.makeEqClasses((ATerm)aTermAppl, (ATerm)aTermAppl2);
                boolean bl = this.reloadRequired = !this.kb.removeAxiom(aTermAppl3);
                if (!this.reloadRequired) continue;
                return;
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        Set set = oWLDisjointClassesAxiom.getClassExpressions();
        int n = set.size();
        if (n > 1) {
            ATermAppl[] aTermApplArray = new ATermAppl[n];
            int n2 = 0;
            for (OWLClassExpression oWLClassExpression : set) {
                oWLClassExpression.accept((OWLObjectVisitor)this);
                aTermApplArray[n2++] = this.term;
            }
            ATermList aTermList = ATermUtils.toSet((ATerm[])aTermApplArray, n);
            if (this.addAxioms) {
                this.kb.addDisjointClasses(aTermList);
            } else {
                this.reloadRequired = !this.kb.removeAxiom(ATermUtils.makeDisjoints(aTermList));
            }
        }
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        oWLSubClassOfAxiom.getSubClass().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLSubClassOfAxiom.getSuperClass().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addSubClass(aTermAppl, aTermAppl2);
        } else {
            ATermAppl aTermAppl3 = ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)aTermAppl2);
            this.reloadRequired = !this.kb.removeAxiom(aTermAppl3);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int n = oWLEquivalentObjectPropertiesAxiom.getProperties().size();
        OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = new OWLObjectPropertyExpression[n];
        oWLEquivalentObjectPropertiesAxiom.getProperties().toArray(oWLObjectPropertyExpressionArray);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                oWLObjectPropertyExpressionArray[i].accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl = this.term;
                oWLObjectPropertyExpressionArray[j].accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl2 = this.term;
                this.kb.addEquivalentProperty(aTermAppl, aTermAppl2);
            }
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int n = oWLEquivalentDataPropertiesAxiom.getProperties().size();
        OWLDataPropertyExpression[] oWLDataPropertyExpressionArray = new OWLDataPropertyExpression[n];
        oWLEquivalentDataPropertiesAxiom.getProperties().toArray(oWLDataPropertyExpressionArray);
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                oWLDataPropertyExpressionArray[i].accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl = this.term;
                oWLDataPropertyExpressionArray[j].accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl2 = this.term;
                this.kb.addEquivalentProperty(aTermAppl, aTermAppl2);
            }
        }
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        if (oWLDifferentIndividualsAxiom.getIndividuals().size() == 2) {
            Iterator iterator = oWLDifferentIndividualsAxiom.getIndividuals().iterator();
            ((OWLIndividual)iterator.next()).accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl = this.term;
            ((OWLIndividual)iterator.next()).accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl2 = this.term;
            this.kb.addDifferent(aTermAppl, aTermAppl2);
        } else {
            ATermAppl[] aTermApplArray = new ATermAppl[oWLDifferentIndividualsAxiom.getIndividuals().size()];
            int n = 0;
            for (OWLIndividual oWLIndividual : oWLDifferentIndividualsAxiom.getIndividuals()) {
                oWLIndividual.accept((OWLObjectVisitor)this);
                aTermApplArray[n++] = this.term;
            }
            this.kb.addAllDifferent(ATermUtils.makeList((ATerm[])aTermApplArray));
        }
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Iterator iterator = oWLSameIndividualAxiom.getIndividuals().iterator();
        if (iterator.hasNext()) {
            ((OWLIndividual)iterator.next()).accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl = this.term;
            while (iterator.hasNext()) {
                ((OWLIndividual)iterator.next()).accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl2 = this.term;
                this.kb.addSame(aTermAppl, aTermAppl2);
            }
        }
    }

    public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLHasKeyAxiom.getClassExpression().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (OWLPropertyExpression oWLPropertyExpression : oWLHasKeyAxiom.getPropertyExpressions()) {
            oWLPropertyExpression.accept((OWLObjectVisitor)this);
            hashSet.add(this.term);
        }
        this.kb.addKey(aTermAppl, hashSet);
    }

    public void visit(OWLDataOneOf oWLDataOneOf) {
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        for (OWLLiteral oWLLiteral : oWLDataOneOf.getValues()) {
            oWLLiteral.accept((OWLObjectVisitor)this);
            aTermList = aTermList.insert((ATerm)ATermUtils.makeValue((ATerm)this.result()));
        }
        this.term = ATermUtils.makeOr(aTermList);
    }

    public void visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
        ((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataRange)oWLDataAllValuesFrom.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
        ((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataRange)oWLDataSomeValuesFrom.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLDataHasValue oWLDataHasValue) {
        ((OWLDataPropertyExpression)oWLDataHasValue.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLLiteral)oWLDataHasValue.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.term = ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl2);
    }

    public void visit(OWLOntology oWLOntology) {
        for (OWLEntity oWLEntity : oWLOntology.getSignature()) {
            oWLEntity.accept((OWLObjectVisitor)this);
        }
        for (OWLEntity oWLEntity : oWLOntology.getAxioms()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Load " + oWLEntity);
            }
            oWLEntity.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLObjectHasSelf oWLObjectHasSelf) {
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty());
        ((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.term = ATermUtils.makeSelf(aTermAppl);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = oWLDisjointObjectPropertiesAxiom.getProperties().toArray(new OWLObjectPropertyExpression[0]);
        for (int i = 0; i < oWLObjectPropertyExpressionArray.length - 1; ++i) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = oWLObjectPropertyExpressionArray[i];
            this.addSimpleProperty(oWLObjectPropertyExpression);
            for (int j = i + 1; j < oWLObjectPropertyExpressionArray.length; ++j) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLObjectPropertyExpressionArray[j];
                this.addSimpleProperty(oWLObjectPropertyExpression2);
                oWLObjectPropertyExpression.accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl = this.term;
                oWLObjectPropertyExpression2.accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl2 = this.term;
                this.kb.addDisjointProperty(aTermAppl, aTermAppl2);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] objectArray = oWLDisjointDataPropertiesAxiom.getProperties().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            OWLDataProperty oWLDataProperty = (OWLDataProperty)objectArray[i];
            oWLDataProperty.accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl = this.term;
            for (int j = i + 1; j < objectArray.length; ++j) {
                OWLDataProperty oWLDataProperty2 = (OWLDataProperty)objectArray[j];
                oWLDataProperty2.accept((OWLObjectVisitor)this);
                ATermAppl aTermAppl2 = this.term;
                this.kb.addDisjointProperty(aTermAppl, aTermAppl2);
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty(oWLSubPropertyChainOfAxiom.getSuperProperty()), (OWLObjectPropertyAxiom)oWLSubPropertyChainOfAxiom);
        oWLSubPropertyChainOfAxiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.result();
        List list = oWLSubPropertyChainOfAxiom.getPropertyChain();
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        for (int i = list.size() - 1; i >= 0; --i) {
            ((OWLObjectPropertyExpression)list.get(i)).accept((OWLObjectVisitor)this);
            aTermList = aTermList.insert((ATerm)this.result());
        }
        this.kb.addSubProperty((ATerm)aTermList, aTermAppl);
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLDisjointUnionAxiom.getOWLClass().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ATermList aTermList = ATermUtils.EMPTY_LIST;
        for (OWLClassExpression oWLClassExpression : oWLDisjointUnionAxiom.getClassExpressions()) {
            oWLClassExpression.accept((OWLObjectVisitor)this);
            aTermList = aTermList.insert((ATerm)this.result());
        }
        this.kb.addDisjointClasses(aTermList);
        this.kb.addEquivalentClass(aTermAppl, ATermUtils.makeOr(aTermList));
    }

    public void visit(OWLDataComplementOf oWLDataComplementOf) {
        oWLDataComplementOf.getDataRange().accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot((ATerm)this.term);
    }

    public void visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
        Set set = oWLDataIntersectionOf.getOperands();
        ATerm[] aTermArray = new ATerm[set.size()];
        int n = 0;
        for (OWLDataRange oWLDataRange : set) {
            oWLDataRange.accept((OWLObjectVisitor)this);
            aTermArray[n++] = this.term;
        }
        ATermList aTermList = n > 0 ? ATermUtils.toSet(aTermArray, n) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(aTermList);
    }

    public void visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
        oWLDatatypeRestriction.getDatatype().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (OWLFacetRestriction oWLFacetRestriction : oWLDatatypeRestriction.getFacetRestrictions()) {
            oWLFacetRestriction.accept((OWLObjectVisitor)this);
            if (this.term != null) {
                arrayList.add(this.term);
                continue;
            }
            log.warning("Unrecognized facet " + oWLFacetRestriction.getFacet());
            return;
        }
        if (arrayList.isEmpty()) {
            log.warning("A data range is defined without facet restrictions " + oWLDatatypeRestriction);
        } else {
            this.term = ATermUtils.makeRestrictedDatatype(aTermAppl, arrayList.toArray(new ATermAppl[arrayList.size()]));
        }
    }

    public void visit(OWLDataUnionOf oWLDataUnionOf) {
        Set set = oWLDataUnionOf.getOperands();
        ATerm[] aTermArray = new ATerm[set.size()];
        int n = 0;
        for (OWLDataRange oWLDataRange : set) {
            oWLDataRange.accept((OWLObjectVisitor)this);
            aTermArray[n++] = this.term;
        }
        ATermList aTermList = n > 0 ? ATermUtils.toSet(aTermArray, n) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(aTermList);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty());
        ((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addAsymmetricProperty(aTermAppl);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addReflexiveProperty(aTermAppl);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty());
        ((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addFunctionalProperty(aTermAppl);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLNegativeObjectPropertyAssertionAxiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        ((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl3 = this.term;
        this.kb.addNegatedPropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        ((OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLDataPropertyDomainAxiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addDomain((ATerm)aTermAppl, aTermAppl2);
        } else {
            this.reloadRequired = !this.kb.removeDomain((ATerm)aTermAppl, aTermAppl2);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        ((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLObjectPropertyDomainAxiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addDomain((ATerm)aTermAppl, aTermAppl2);
        } else {
            this.reloadRequired = !this.kb.removeDomain((ATerm)aTermAppl, aTermAppl2);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLNegativeDataPropertyAssertionAxiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        ((OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl3 = this.term;
        this.kb.addNegatedPropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        ((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addRange((ATerm)aTermAppl, aTermAppl2);
        } else {
            this.reloadRequired = !this.kb.removeRange((ATerm)aTermAppl, aTermAppl2);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        oWLObjectPropertyAssertionAxiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        ((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl3 = this.term;
        if (this.addAxioms) {
            this.kb.addPropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
        } else {
            this.kb.removePropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
        }
    }

    public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl2);
    }

    public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLDatatypeDefinitionAxiom.getDatatype().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLDatatypeDefinitionAxiom.getDataRange().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.kb.addDatatypeDefinition(aTermAppl, aTermAppl2);
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        oWLDeclarationAxiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addSymmetricProperty(aTermAppl);
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        ((OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addRange((ATerm)aTermAppl, aTermAppl2);
        } else {
            this.reloadRequired = !this.kb.removeRange((ATerm)aTermAppl, aTermAppl2);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addFunctionalProperty(aTermAppl);
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        oWLClassAssertionAxiom.getClassExpression().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        if (AnnotationClasses.contains(aTermAppl)) {
            return;
        }
        oWLClassAssertionAxiom.getIndividual().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        if (this.addAxioms) {
            this.kb.addType(aTermAppl2, aTermAppl);
        } else {
            this.kb.removeType(aTermAppl2, aTermAppl);
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        oWLDataPropertyAssertionAxiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        ((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl3 = this.term;
        if (this.addAxioms) {
            this.kb.addPropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
        } else {
            this.kb.removePropertyValue(aTermAppl2, aTermAppl, aTermAppl3);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()), (OWLObjectPropertyAxiom)oWLTransitiveObjectPropertyAxiom);
        ((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addTransitiveProperty(aTermAppl);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty());
        ((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addIrreflexiveProperty(aTermAppl);
    }

    public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        ((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl2);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty());
        ((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        this.kb.addInverseFunctionalProperty((ATerm)aTermAppl);
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLInverseObjectPropertiesAxiom.getFirstProperty().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLInverseObjectPropertiesAxiom.getSecondProperty().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.kb.addInverseProperty(aTermAppl, aTermAppl2);
    }

    public void visit(OWLFacetRestriction oWLFacetRestriction) {
        Facet facet = Facet.Registry.get(ATermUtils.makeTermAppl(oWLFacetRestriction.getFacet().getIRI().toString()));
        if (facet != null) {
            OWLLiteral oWLLiteral = oWLFacetRestriction.getFacetValue();
            oWLLiteral.accept((OWLObjectVisitor)this);
            this.term = ATermUtils.makeFacetRestriction(facet.getName(), this.term);
        }
    }

    public void visit(SWRLRule sWRLRule) {
        if (!PelletOptions.DL_SAFE_RULES) {
            return;
        }
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        List<RuleAtom> list = this.parseAtomList(sWRLRule.getHead());
        List<RuleAtom> list2 = this.parseAtomList(sWRLRule.getBody());
        if (list == null || list2 == null) {
            this.addUnsupportedAxiom((OWLAxiom)sWRLRule);
            return;
        }
        Rule rule = new Rule(list, list2);
        this.kb.addRule(rule);
    }

    public void visit(OWLAnnotation oWLAnnotation) {
        throw new UnsupportedOperationException();
    }

    public void visit(IRI iRI) {
        this.term = ATermUtils.makeTermAppl(iRI.toString());
    }

    public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = PelletOptions.USE_ANNOTATION_SUPPORT;
            return;
        }
        if (PelletOptions.USE_ANNOTATION_SUPPORT) {
            oWLAnnotationAssertionAxiom.getSubject().accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl = this.term;
            oWLAnnotationAssertionAxiom.getProperty().accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl2 = this.term;
            oWLAnnotationAssertionAxiom.getValue().accept((OWLObjectVisitor)this);
            ATermAppl aTermAppl3 = this.term;
            this.kb.addAnnotation(aTermAppl, aTermAppl2, aTermAppl3);
        }
    }

    public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
    }

    public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        oWLSubAnnotationPropertyOfAxiom.getSubProperty().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl = this.term;
        oWLSubAnnotationPropertyOfAxiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl aTermAppl2 = this.term;
        this.kb.addSubProperty((ATerm)aTermAppl, aTermAppl2);
    }

    private List<RuleAtom> parseAtomList(Set<SWRLAtom> set) {
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        for (SWRLAtom sWRLAtom : set) {
            sWRLAtom.accept((OWLObjectVisitor)this);
            if (this.swrlAtom == null) {
                return null;
            }
            arrayList.add(this.swrlAtom);
        }
        return arrayList;
    }

    public void visit(SWRLClassAtom sWRLClassAtom) {
        OWLClassExpression oWLClassExpression = sWRLClassAtom.getPredicate();
        SWRLIArgument sWRLIArgument = (SWRLIArgument)sWRLClassAtom.getArgument();
        sWRLIArgument.accept((OWLObjectVisitor)this);
        AtomIObject atomIObject = this.swrlIObject;
        oWLClassExpression.accept((OWLObjectVisitor)this);
        this.swrlAtom = new ClassAtom(this.term, atomIObject);
    }

    public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
        sWRLDataRangeAtom.getPredicate().accept((OWLObjectVisitor)this);
        ((SWRLDArgument)sWRLDataRangeAtom.getArgument()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DataRangeAtom(this.term, this.swrlDObject);
    }

    public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
        if (sWRLObjectPropertyAtom.getPredicate().isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLIArgument)sWRLObjectPropertyAtom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject = this.swrlIObject;
        ((SWRLIArgument)sWRLObjectPropertyAtom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject2 = this.swrlIObject;
        sWRLObjectPropertyAtom.getPredicate().accept((OWLObjectVisitor)this);
        this.swrlAtom = new IndividualPropertyAtom(this.term, atomIObject, atomIObject2);
    }

    public void visit(SWRLDataPropertyAtom sWRLDataPropertyAtom) {
        if (sWRLDataPropertyAtom.getPredicate().isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLIArgument)sWRLDataPropertyAtom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject = this.swrlIObject;
        ((SWRLDArgument)sWRLDataPropertyAtom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomDObject atomDObject = this.swrlDObject;
        sWRLDataPropertyAtom.getPredicate().accept((OWLObjectVisitor)this);
        this.swrlAtom = new DatavaluedPropertyAtom(this.term, atomIObject, atomDObject);
    }

    public void visit(SWRLSameIndividualAtom sWRLSameIndividualAtom) {
        ((SWRLIArgument)sWRLSameIndividualAtom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject = this.swrlIObject;
        ((SWRLIArgument)sWRLSameIndividualAtom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject2 = this.swrlIObject;
        this.swrlAtom = new SameIndividualAtom(atomIObject, atomIObject2);
    }

    public void visit(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) {
        ((SWRLIArgument)sWRLDifferentIndividualsAtom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject = this.swrlIObject;
        ((SWRLIArgument)sWRLDifferentIndividualsAtom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject atomIObject2 = this.swrlIObject;
        this.swrlAtom = new DifferentIndividualsAtom(atomIObject, atomIObject2);
    }

    public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
        ArrayList<AtomDObject> arrayList = new ArrayList<AtomDObject>(sWRLBuiltInAtom.getAllArguments().size());
        for (SWRLDArgument sWRLDArgument : sWRLBuiltInAtom.getArguments()) {
            sWRLDArgument.accept((OWLObjectVisitor)this);
            arrayList.add(this.swrlDObject);
        }
        this.swrlAtom = new BuiltInAtom(sWRLBuiltInAtom.getPredicate().toString(), arrayList);
    }

    public void visit(SWRLVariable sWRLVariable) {
        this.swrlDObject = new AtomDVariable(sWRLVariable.getIRI().toString());
        this.swrlIObject = new AtomIVariable(sWRLVariable.getIRI().toString());
    }

    public void visit(SWRLIndividualArgument sWRLIndividualArgument) {
        sWRLIndividualArgument.getIndividual().accept((OWLObjectVisitor)this);
        this.swrlIObject = new AtomIConstant(this.term);
    }

    public void visit(SWRLLiteralArgument sWRLLiteralArgument) {
        sWRLLiteralArgument.getLiteral().accept((OWLObjectVisitor)this);
        this.swrlDObject = new AtomDConstant(this.term);
    }
}

