/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

public class OWLClassTreePrinter
extends TreeTaxonomyPrinter<OWLClass>
implements TaxonomyPrinter<OWLClass> {
    private QNameProvider qnames = new QNameProvider();

    @Override
    protected void printNode(Set<OWLClass> set) {
        super.printNode(set);
        Set<OWLNamedIndividual> set2 = OWLClassTreePrinter.getDirectInstances(this.taxonomy, set.iterator().next());
        if (set2.size() > 0) {
            this.out.print(" - (");
            boolean bl = false;
            Iterator<OWLNamedIndividual> iterator = set2.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                OWLNamedIndividual oWLNamedIndividual = iterator.next();
                if (bl) {
                    this.out.print(", ");
                } else {
                    bl = true;
                }
                this.printURI(this.out, oWLNamedIndividual);
                ++n;
            }
            this.out.print(")");
        }
    }

    @Override
    protected void printURI(PrintWriter printWriter, OWLClass oWLClass) {
        this.printIRI(printWriter, oWLClass.getIRI());
    }

    @Override
    private void printURI(PrintWriter printWriter, OWLNamedIndividual oWLNamedIndividual) {
        this.printIRI(printWriter, oWLNamedIndividual.getIRI());
    }

    private void printIRI(PrintWriter printWriter, IRI iRI) {
        printWriter.print(this.qnames.shortForm(iRI.toString()));
    }

    public static Set<OWLNamedIndividual> getDirectInstances(Taxonomy<OWLClass> taxonomy, OWLClass oWLClass) {
        Set set = (Set)taxonomy.getDatum(oWLClass, TaxonomyUtils.INSTANCES_KEY);
        if (set == null) {
            if (taxonomy.contains(oWLClass)) {
                return Collections.emptySet();
            }
            throw new RuntimeException(oWLClass + " is an unknown class!");
        }
        return Collections.unmodifiableSet(set);
    }
}

