/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDNonNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNonNegativeInteger instance = new XSDNonNegativeInteger();

    public static XSDNonNegativeInteger getInstance() {
        return instance;
    }

    private XSDNonNegativeInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"), 0, null);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            BigInteger bigInteger = DatatypeConverter.parseInteger(string);
            if (BigInteger.ZERO.compareTo(bigInteger) > 0) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

