/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDByte
extends AbstractDerivedIntegerType {
    private static final XSDByte instance = new XSDByte();

    public static XSDByte getInstance() {
        return instance;
    }

    private XSDByte() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#byte"), (byte)-128, (byte)127);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt(string);
            if (n < -128 || n > 127) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return (byte)n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

