/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.io;

import com.clarkparsia.owlapiv3.OWL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class TaxonomyPersistence {
    public static final Logger log = Logger.getLogger(TaxonomyPersistence.class.getName());
    private static IRI TAXONOMY_ONTOLOGY_IRI = IRI.create((String)"http://clarkparsia.com/pellet/modularity/taxonomy");

    public static void save(Taxonomy<OWLClass> taxonomy, OutputStream outputStream) throws IOException {
        try {
            OWLOntology oWLOntology = TaxonomyPersistence.createTaxonomyOntology(taxonomy);
            OWL.manager.saveOntology(oWLOntology, (OWLOntologyFormat)new OWLXMLOntologyFormat(), (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
            outputStream.flush();
            OWL.manager.removeOntology(oWLOntology);
        }
        catch (OWLException oWLException) {
            log.log(Level.SEVERE, "An error occured while creating an ontology for taxonomy", oWLException);
            throw new IOException("An error occured while creating an ontology for taxonomy");
        }
    }

    private static OWLOntology createTaxonomyOntology(Taxonomy<OWLClass> taxonomy) throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntology oWLOntology = OWL.Ontology(Collections.emptyList(), TAXONOMY_ONTOLOGY_IRI);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes()) {
            AddAxiom addAxiom;
            Object object;
            if (hashSet.contains(taxonomyNode.getName())) continue;
            hashSet.addAll(taxonomyNode.getEquivalents());
            Object object2 = taxonomyNode.getEquivalents().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                addAxiom = new AddAxiom(oWLOntology, (OWLAxiom)OWL.declaration((OWLEntity)object));
                linkedList.add(addAxiom);
                for (TaxonomyNode<OWLClass> taxonomyNode2 : taxonomyNode.getSupers()) {
                    AddAxiom addAxiom2 = new AddAxiom(oWLOntology, (OWLAxiom)OWL.subClassOf((OWLClassExpression)object, (OWLClassExpression)taxonomyNode2.getName()));
                    linkedList.add(addAxiom2);
                }
            }
            if (taxonomyNode.getEquivalents().size() > 1) {
                object2 = new AddAxiom(oWLOntology, (OWLAxiom)OWL.equivalentClasses(taxonomyNode.getEquivalents()));
                linkedList.add(object2);
            }
            if ((object2 = (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY)) == null || object2.isEmpty()) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                addAxiom = (OWLNamedIndividual)object.next();
                AddAxiom addAxiom3 = new AddAxiom(oWLOntology, (OWLAxiom)OWL.classAssertion((OWLIndividual)addAxiom, (OWLClassExpression)taxonomyNode.getName()));
                linkedList.add(addAxiom3);
            }
        }
        OWL.manager.applyChanges(linkedList);
        return oWLOntology;
    }

    private static Set<OWLClass> getSuperClasses(OWLOntology oWLOntology, OWLClass oWLClass) {
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLOntology.getSubClassAxiomsForSubClass(oWLClass)) {
            OWLClassExpression oWLClassExpression = oWLSubClassOfAxiom.getSuperClass();
            if (!(oWLClassExpression instanceof OWLClass)) continue;
            hashSet.add((OWLClass)oWLClassExpression);
        }
        return hashSet;
    }

    private static Taxonomy<OWLClass> createTaxonomy(OWLOntology oWLOntology) {
        Object object;
        Taxonomy<OWLClass> taxonomy = new Taxonomy<OWLClass>(null, OWL.Thing, OWL.Nothing);
        HashSet<OWLClass> hashSet = new HashSet<OWLClass>();
        hashSet.add(OWL.Thing);
        hashSet.add(OWL.Nothing);
        for (OWLClass object2 : oWLOntology.getClassesInSignature()) {
            if (hashSet.contains(object2)) continue;
            object = new HashSet();
            boolean bl = false;
            boolean bl2 = false;
            for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : oWLOntology.getEquivalentClassesAxioms(object2)) {
                object.addAll(oWLEquivalentClassesAxiom.getNamedClasses());
                if (oWLEquivalentClassesAxiom.containsOWLNothing()) {
                    bl2 = true;
                }
                if (!oWLEquivalentClassesAxiom.containsOWLThing()) continue;
                bl = true;
            }
            object.removeAll(hashSet);
            if (bl) {
                taxonomy.addEquivalents(OWL.Thing, (Collection<OWLClass>)object);
            } else if (bl2) {
                taxonomy.addEquivalents(OWL.Nothing, (Collection<OWLClass>)object);
            } else {
                if (object.contains(object2)) {
                    object.remove(object2);
                }
                taxonomy.addNode(object2, false);
                taxonomy.addEquivalents(object2, (Collection<OWLClass>)object);
            }
            hashSet.add(object2);
            hashSet.addAll((Collection<OWLClass>)object);
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            if (!OWL.Nothing.equals(taxonomyNode.getName()) || taxonomyNode.getSupers().size() <= 1 || !taxonomyNode.getSupers().contains(taxonomy.getTop())) continue;
            taxonomy.getTop().removeSub(taxonomyNode);
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            object = (OWLClass)taxonomyNode.getName();
            if (object == null || object.equals(OWL.Nothing)) continue;
            taxonomy.addSupers((OWLClass)object, (Collection<OWLClass>)TaxonomyPersistence.getSuperClasses(oWLOntology, object));
        }
        for (TaxonomyNode taxonomyNode : taxonomy.getNodes()) {
            object = null;
            for (OWLClassAssertionAxiom oWLClassAssertionAxiom : oWLOntology.getClassAssertionAxioms((OWLClassExpression)taxonomyNode.getName())) {
                OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
                if (!oWLIndividual.isNamed() || !(oWLIndividual instanceof OWLNamedIndividual)) continue;
                if (object == null) {
                    object = new HashSet();
                }
                object.add((OWLNamedIndividual)oWLIndividual);
            }
            if (object == null) continue;
            taxonomyNode.putDatum(TaxonomyUtils.INSTANCES_KEY, object);
        }
        return taxonomy;
    }

    public static Taxonomy<OWLClass> load(InputStream inputStream) throws IOException {
        try {
            OWLOntology oWLOntology = OWL.manager.loadOntologyFromOntologyDocument(inputStream);
            Taxonomy<OWLClass> taxonomy = TaxonomyPersistence.createTaxonomy(oWLOntology);
            OWL.manager.removeOntology(oWLOntology);
            return taxonomy;
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            log.log(Level.SEVERE, "Unable to create the ontology", oWLOntologyCreationException);
            throw new IOException("Unable to create the ontology");
        }
    }
}

