/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;

public class UpdateProcessRemoteForm
implements UpdateProcessor {
    public static final Symbol HTTP_CONTEXT = Symbol.create("httpContext");
    private final UpdateRequest request;
    private final String endpoint;
    private final Context context;

    public UpdateProcessRemoteForm(UpdateRequest request, String endpoint, Context context) {
        this.request = request;
        this.endpoint = endpoint;
        this.context = Context.setupContext(context, null);
    }

    @Override
    public GraphStore getGraphStore() {
        return null;
    }

    @Override
    public void execute() {
        if (this.endpoint == null) {
            throw new ARQException("Null endpoint for remote update by form");
        }
        String reqStr = this.request.toString();
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(Pair.create("update", reqStr));
        HashMap<String, HttpResponseHandler> handlers = new HashMap<String, HttpResponseHandler>();
        handlers.put("*", HttpResponseLib.nullResponse);
        HttpOp.execHttpPostForm(this.endpoint, params, handlers, this.getHttpContext());
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.getContext().put(HTTP_CONTEXT, httpContext);
    }

    public HttpContext getHttpContext() {
        return (HttpContext)this.getContext().get(HTTP_CONTEXT);
    }
}

