/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.fsm;

import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.fsm.Transition;

public class State<T> {
    private static int next_unused_name = 0;
    private int name = next_unused_name++;
    private Set<Transition<T>> transitions = new HashSet<Transition<T>>();

    public void addTransition(T t, State<T> state) {
        if (t == null || state == null) {
            throw new NullPointerException();
        }
        if (!(t instanceof Role)) {
            throw new ClassCastException();
        }
        Transition<T> transition = new Transition<T>(t, state);
        this.transitions.add(transition);
    }

    public void addTransition(State<T> state) {
        if (state == null) {
            throw new NullPointerException();
        }
        Transition<T> transition = new Transition<T>(state);
        this.transitions.add(transition);
    }

    public Set<Transition<T>> getTransitions() {
        return this.transitions;
    }

    public State<T> move(T t) {
        for (Transition<T> transition : this.transitions) {
            if (!transition.hasName(t)) continue;
            return transition.getTo();
        }
        return null;
    }

    public int getName() {
        return this.name;
    }

    public void setName(int n) {
        this.name = n;
    }

    public String toString() {
        return String.valueOf(this.name);
    }
}

