/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BinarySet<T>
extends AbstractSet<T> {
    private T first;
    private T second;

    private BinarySet(T t, T t2) {
        if (t.equals(t2)) {
            throw new IllegalArgumentException("Cannot create a binary set with single element: " + t);
        }
        this.first = t;
        this.second = t2;
    }

    public static <T> BinarySet<T> create(T t, T t2) {
        return new BinarySet<T>(t, t2);
    }

    public T first() {
        return this.first;
    }

    public T second() {
        return this.second;
    }

    @Override
    public boolean contains(Object object) {
        return this.first.equals(object) || this.second.equals(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.i++ == 0 ? BinarySet.this.first : BinarySet.this.second;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return 2;
    }
}

