/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class MinRule
extends AbstractTableauRule {
    public MinRule(CompletionStrategy completionStrategy) {
        super(completionStrategy, NodeSelector.MIN_NUMBER, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual individual) {
        if (!individual.canApply(4)) {
            return;
        }
        List<ATermAppl> list = individual.getTypes(4);
        int n = list.size();
        for (int i = individual.applyNext[4]; i < n; ++i) {
            ATermAppl aTermAppl = list.get(i);
            this.apply(individual, aTermAppl);
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
        individual.applyNext[4] = n;
    }

    protected void apply(Individual individual, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2;
        int n;
        Role role = this.strategy.getABox().getRole(aTermAppl.getArgument(0));
        if (individual.hasDistinctRNeighborsForMin(role, n = ((ATermInt)aTermAppl.getArgument(1)).getInt(), aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2))) {
            return;
        }
        DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && dependencySet == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("MIN : " + individual + " -> " + role + " -> anon" + (n == 1 ? "" : this.strategy.getABox().getAnonCount() + 1 + " - anon") + (this.strategy.getABox().getAnonCount() + n) + " " + ATermUtils.toString(aTermAppl2) + " " + dependencySet);
        }
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            this.strategy.checkTimer();
            nodeArray[i] = role.isDatatypeRole() ? this.strategy.getABox().addLiteral(dependencySet) : this.strategy.createFreshIndividual(individual, dependencySet);
            Node node = nodeArray[i];
            DependencySet dependencySet2 = dependencySet;
            this.strategy.addEdge(individual, role, node, dependencySet);
            if (node.isPruned()) {
                dependencySet2 = dependencySet2.union(node.getMergeDependency(true), this.strategy.getABox().doExplanation());
                node = node.getMergedTo();
            }
            this.strategy.addType(node, aTermAppl2, dependencySet2);
            for (int j = 0; j < i; ++j) {
                node.setDifferent(nodeArray[j], dependencySet2);
            }
        }
    }
}

