/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedNodeFactory;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;

public abstract class AbstractConceptCache
implements ConceptCache {
    public static final Logger log = Logger.getLogger(AbstractConceptCache.class.getName());
    private int maxSize;

    public AbstractConceptCache(int n) {
        this.maxSize = n;
    }

    protected boolean isFull() {
        return this.size() == this.maxSize;
    }

    @Override
    public Bool getSat(ATermAppl aTermAppl) {
        CachedNode cachedNode = (CachedNode)this.get(aTermAppl);
        return cachedNode == null ? Bool.UNKNOWN : Bool.create(!cachedNode.isBottom());
    }

    @Override
    public boolean putSat(ATermAppl aTermAppl, boolean bl) {
        CachedNode cachedNode = (CachedNode)this.get(aTermAppl);
        if (cachedNode != null) {
            if (bl != !cachedNode.isBottom()) {
                throw new InternalReasonerException("Caching inconsistent results for " + aTermAppl);
            }
            return false;
        }
        if (bl) {
            this.put(aTermAppl, CachedNodeFactory.createSatisfiableNode());
        } else {
            ATermAppl aTermAppl2 = ATermUtils.negate(aTermAppl);
            this.put(aTermAppl, CachedNodeFactory.createBottomNode());
            this.put(aTermAppl2, CachedNodeFactory.createTopNode());
        }
        return true;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    private Bool checkTrivialClash(CachedNode cachedNode, CachedNode cachedNode2) {
        Bool bool = null;
        if (cachedNode.isBottom() || cachedNode2.isBottom()) {
            bool = Bool.TRUE;
        } else if (cachedNode.isTop() || cachedNode2.isTop()) {
            bool = Bool.FALSE;
        } else if (!cachedNode.isComplete() || !cachedNode2.isComplete()) {
            bool = Bool.UNKNOWN;
        }
        return bool;
    }

    @Override
    public Bool isMergable(KnowledgeBase knowledgeBase, CachedNode cachedNode, CachedNode cachedNode2) {
        Bool bool;
        boolean bl;
        Object object;
        Object object2;
        Bool bool2 = this.checkTrivialClash(cachedNode, cachedNode2);
        if (bool2 != null) {
            return bool2.not();
        }
        CachedNode[] cachedNodeArray = new CachedNode[]{cachedNode, cachedNode2};
        boolean bl2 = cachedNode.isIndependent() && cachedNode2.isIndependent();
        int n = cachedNodeArray[0].getDepends().size() < cachedNodeArray[1].getDepends().size() ? 0 : 1;
        int n2 = 1 - n;
        for (Map.Entry<ATermAppl, DependencySet> object32 : cachedNodeArray[n].getDepends().entrySet()) {
            boolean bl3;
            object2 = object32.getKey();
            object = ATermUtils.negate(object2);
            DependencySet dependencySet = cachedNodeArray[n2].getDepends().get(object);
            if (dependencySet == null) continue;
            Object object3 = object32.getValue();
            boolean bl4 = bl3 = bl2 && ((DependencySet)object3).isIndependent() && dependencySet.isIndependent();
            if (bl3) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(cachedNodeArray[n] + " has " + object2 + " " + cachedNodeArray[n2] + " has negation " + ((DependencySet)object3).max() + " " + dependencySet.max());
                }
                return Bool.FALSE;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(cachedNodeArray[n] + " has " + object2 + " " + cachedNodeArray[n2] + " has negation " + ((DependencySet)object3).max() + " " + dependencySet.max());
            }
            bool2 = Bool.UNKNOWN;
        }
        if (bool2 != null) {
            return bool2;
        }
        for (n = 0; n < 2; ++n) {
            n2 = 1 - n;
            for (ATermAppl aTermAppl : cachedNodeArray[n].getDepends().keySet()) {
                if (ATermUtils.isPrimitive(aTermAppl)) {
                    bool2 = this.checkBinaryClash(knowledgeBase, aTermAppl, cachedNodeArray[n], cachedNodeArray[n2]);
                } else if (ATermUtils.isAllValues(aTermAppl)) {
                    bool2 = this.checkAllValuesClash(knowledgeBase, aTermAppl, cachedNodeArray[n], cachedNodeArray[n2]);
                } else if (ATermUtils.isNot(aTermAppl)) {
                    object2 = (ATermAppl)aTermAppl.getArgument(0);
                    if (ATermUtils.isMin(object2)) {
                        bool2 = this.checkMaxClash(knowledgeBase, aTermAppl, cachedNodeArray[n], cachedNodeArray[n2]);
                    } else if (ATermUtils.isSelf(object2)) {
                        bool2 = this.checkSelfClash(knowledgeBase, (ATermAppl)object2, cachedNodeArray[n], cachedNodeArray[n2]);
                    }
                }
                if (bool2 == null) continue;
                return bool2;
            }
        }
        boolean bl5 = bl = cachedNode instanceof Individual && cachedNode2 instanceof Individual;
        if (knowledgeBase.getExpressivity().hasFunctionality() || knowledgeBase.getExpressivity().hasFunctionalityD()) {
            n = cachedNodeArray[0].getOutEdges().size() + cachedNodeArray[0].getInEdges().size() < cachedNodeArray[1].getOutEdges().size() + cachedNodeArray[1].getInEdges().size() ? 0 : 1;
            n2 = 1 - n;
            bool2 = bl ? this.checkFunctionalityClashWithDifferents((Individual)cachedNodeArray[n], (Individual)cachedNodeArray[n2]) : this.checkFunctionalityClash(cachedNodeArray[n], cachedNodeArray[n2]);
            if (bool2 != null) {
                return bool2;
            }
        }
        if (bl) {
            Individual individual = (Individual)cachedNode;
            object2 = (Individual)cachedNode2;
            object = individual.getDifferenceDependency((Node)object2);
            if (object != null) {
                return ((DependencySet)object).isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
            for (Object object3 : individual.getOutEdges()) {
                if (!object3.getRole().isIrreflexive() || !object3.getTo().equals(object2)) continue;
                return object3.getDepends().isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
            for (Object object3 : individual.getInEdges()) {
                if (!object3.getRole().isIrreflexive() || !object3.getFrom().equals(object2)) continue;
                return object3.getDepends().isIndependent() ? Bool.FALSE : Bool.UNKNOWN;
            }
        }
        if (knowledgeBase.getExpressivity().hasDisjointRoles() && (bool = this.checkDisjointPropertyClash(cachedNode, cachedNode2)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot determine if two named individuals can be merged or not: " + cachedNodeArray[0] + "  + roots[1]");
            }
            return Bool.UNKNOWN;
        }
        return Bool.TRUE;
    }

    private Bool checkBinaryClash(KnowledgeBase knowledgeBase, ATermAppl aTermAppl, CachedNode cachedNode, CachedNode cachedNode2) {
        Iterator<Unfolding> iterator = knowledgeBase.getTBox().unfold(aTermAppl);
        while (iterator.hasNext()) {
            Unfolding unfolding = iterator.next();
            ATermAppl aTermAppl2 = unfolding.getCondition();
            if (aTermAppl2.equals(TermFactory.TOP) || !cachedNode2.getDepends().containsKey(aTermAppl2)) continue;
            return Bool.UNKNOWN;
        }
        return null;
    }

    private Bool checkAllValuesClash(KnowledgeBase knowledgeBase, ATermAppl aTermAppl, CachedNode cachedNode, CachedNode cachedNode2) {
        Role role;
        ATerm aTerm = aTermAppl.getArgument(0);
        if (aTerm.getType() == 4) {
            aTerm = ((ATermList)aTerm).getFirst();
        }
        if (!(role = knowledgeBase.getRole(aTerm)).hasComplexSubRole()) {
            if (cachedNode2.hasRNeighbor(role)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(cachedNode + " has " + aTermAppl + " " + cachedNode2 + " has " + role + " neighbor");
                }
                return Bool.UNKNOWN;
            }
        } else {
            TransitionGraph<Role> transitionGraph = role.getFSM();
            for (Transition<Role> transition : transitionGraph.getInitialState().getTransitions()) {
                if (!cachedNode2.hasRNeighbor(transition.getName())) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(cachedNode + " has " + aTermAppl + " " + cachedNode2 + " has " + transition.getName() + " neighbor");
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private Bool checkMaxClash(KnowledgeBase knowledgeBase, ATermAppl aTermAppl, CachedNode cachedNode, CachedNode cachedNode2) {
        int n;
        ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
        Role role = knowledgeBase.getRole(aTermAppl2.getArgument(0));
        int n2 = ((ATermInt)aTermAppl2.getArgument(1)).getInt() - 1;
        int n3 = this.getRNeighbors(cachedNode, role).size();
        if (n3 + (n = this.getRNeighbors(cachedNode2, role).size()) > n2) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(cachedNode + " has " + aTermAppl + " " + cachedNode2 + " has R-neighbor");
            }
            return Bool.UNKNOWN;
        }
        return null;
    }

    private Bool checkSelfClash(KnowledgeBase knowledgeBase, ATermAppl aTermAppl, CachedNode cachedNode, CachedNode cachedNode2) {
        Role role = knowledgeBase.getRole(aTermAppl.getArgument(0));
        for (Edge edge : cachedNode2.getOutEdges()) {
            if (!edge.getRole().isSubRoleOf(role) || !edge.getToName().equals(cachedNode2.getName())) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine(cachedNode + " has not(" + aTermAppl + ") " + cachedNode2 + " has self edge");
            }
            boolean bl = cachedNode.isIndependent() && cachedNode2.isIndependent() && edge.getDepends().isIndependent();
            return bl ? Bool.FALSE : Bool.UNKNOWN;
        }
        return null;
    }

    private Bool checkFunctionalityClash(CachedNode cachedNode, CachedNode cachedNode2) {
        Set<Role> set;
        Role role;
        HashSet<Role> hashSet = new HashSet<Role>();
        for (Edge edge : cachedNode.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            set = role.getFunctionalSupers();
            for (Role role2 : set) {
                if (hashSet.contains(role2)) continue;
                hashSet.add(role2);
                if (!cachedNode2.hasRNeighbor(role2)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(cachedNode + " and " + cachedNode2 + " has " + role2);
                }
                return Bool.UNKNOWN;
            }
        }
        for (Edge edge : cachedNode.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            set = role.getFunctionalSupers();
            for (Role role2 : set) {
                if (hashSet.contains(role2)) continue;
                hashSet.add(role2);
                if (!cachedNode2.hasRNeighbor(role2)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(cachedNode + " and " + cachedNode2 + " has " + role2);
                }
                return Bool.UNKNOWN;
            }
        }
        return null;
    }

    private Bool checkFunctionalityClashWithDifferents(Individual individual, Individual individual2) {
        DependencySet dependencySet;
        EdgeList edgeList;
        Set<Role> set;
        Role role;
        Bool bool = null;
        for (Edge edge : individual.getOutEdges()) {
            role = edge.getRole();
            if (!role.isFunctional()) continue;
            set = role.getFunctionalSupers();
            for (Role role2 : set) {
                edgeList = individual2.getRNeighborEdges(role2);
                for (Edge edge2 : edgeList) {
                    dependencySet = edge.getTo().getDifferenceDependency(edge2.getNeighbor(individual2));
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(individual + " and " + individual2 + " has " + role2 + " " + edge + " " + edge2);
                    }
                    if (dependencySet != null && dependencySet.isIndependent()) {
                        return Bool.FALSE;
                    }
                    bool = Bool.UNKNOWN;
                }
            }
        }
        for (Edge edge : individual.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role == null || !role.isFunctional()) continue;
            set = role.getFunctionalSupers();
            for (Role role2 : set) {
                edgeList = individual2.getRNeighborEdges(role2);
                for (Edge edge2 : edgeList) {
                    dependencySet = edge.getTo().getDifferenceDependency(edge2.getNeighbor(individual2));
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(individual + " and " + individual2 + " has " + role2 + " " + edge + " " + edge2);
                    }
                    if (dependencySet != null && dependencySet.isIndependent()) {
                        return Bool.FALSE;
                    }
                    bool = Bool.UNKNOWN;
                }
            }
        }
        return bool;
    }

    private MultiValueMap<ATermAppl, Role> collectNeighbors(CachedNode cachedNode) {
        ATermAppl aTermAppl;
        Role role;
        MultiValueMap<ATermAppl, Role> multiValueMap = new MultiValueMap<ATermAppl, Role>();
        for (Edge edge : cachedNode.getInEdges()) {
            role = edge.getRole();
            aTermAppl = edge.getFromName();
            if (ATermUtils.isBnode(aTermAppl)) continue;
            multiValueMap.putSingle(aTermAppl, role);
        }
        for (Edge edge : cachedNode.getOutEdges()) {
            role = edge.getRole();
            aTermAppl = edge.getToName();
            if (!role.isObjectRole() || ATermUtils.isBnode(aTermAppl)) continue;
            multiValueMap.putSingle(aTermAppl, role.getInverse());
        }
        return multiValueMap;
    }

    private boolean checkDisjointProperties(Set<Role> set, Set<Role> set2) {
        HashSet<Role> hashSet = new HashSet<Role>();
        for (Role role : set) {
            hashSet.addAll(role.getDisjointRoles());
        }
        return SetUtils.intersects(hashSet, set2);
    }

    private Bool checkDisjointPropertyClash(CachedNode cachedNode, CachedNode cachedNode2) {
        MultiValueMap<ATermAppl, Role> multiValueMap = this.collectNeighbors(cachedNode);
        if (multiValueMap.isEmpty()) {
            return null;
        }
        MultiValueMap<ATermAppl, Role> multiValueMap2 = this.collectNeighbors(cachedNode2);
        if (multiValueMap2.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : multiValueMap.entrySet()) {
            ATermAppl aTermAppl = (ATermAppl)entry.getKey();
            Set set = (Set)entry.getValue();
            Set set2 = (Set)multiValueMap2.get(aTermAppl);
            if (set2 == null || !this.checkDisjointProperties(set, set2)) continue;
            return Bool.UNKNOWN;
        }
        return null;
    }

    @Override
    public Bool checkNominalEdges(KnowledgeBase knowledgeBase, CachedNode cachedNode, CachedNode cachedNode2) {
        Bool bool = Bool.UNKNOWN;
        if (cachedNode.isComplete() && cachedNode2.isComplete() && cachedNode2.isIndependent() && (bool = this.checkNominalEdges(knowledgeBase, cachedNode, cachedNode2, false)).isUnknown()) {
            bool = this.checkNominalEdges(knowledgeBase, cachedNode, cachedNode2, true);
        }
        return bool;
    }

    private Bool checkNominalEdges(KnowledgeBase knowledgeBase, CachedNode cachedNode, CachedNode cachedNode2, boolean bl) {
        EdgeList edgeList = bl ? cachedNode2.getInEdges() : cachedNode2.getOutEdges();
        for (Edge edge : edgeList) {
            Object object;
            Object object2;
            HashSet<ATermAppl> hashSet;
            ATermAppl aTermAppl;
            Role role = bl ? edge.getRole().getInverse() : edge.getRole();
            DependencySet dependencySet = edge.getDepends();
            if (!dependencySet.isIndependent()) continue;
            boolean bl2 = false;
            ATermAppl aTermAppl2 = aTermAppl = bl ? edge.getFromName() : edge.getToName();
            if (!role.isObjectRole()) {
                bl2 = cachedNode.hasRNeighbor(role);
            } else if (!this.isRootNominal(knowledgeBase, aTermAppl)) {
                if (!role.hasComplexSubRole()) {
                    bl2 = cachedNode.hasRNeighbor(role);
                } else {
                    hashSet = role.getFSM();
                    object2 = ((TransitionGraph)((Object)hashSet)).getInitialState().getTransitions().iterator();
                    while (!bl2 && object2.hasNext()) {
                        object = object2.next();
                        bl2 = cachedNode.hasRNeighbor((Role)((Transition)object).getName());
                    }
                }
            } else {
                hashSet = null;
                if (role.isSimple() || !(cachedNode instanceof Individual)) {
                    hashSet = this.getRNeighbors(cachedNode, role);
                } else {
                    hashSet = new HashSet<ATermAppl>();
                    knowledgeBase.getABox().getObjectPropertyValues(cachedNode.getName(), role, hashSet, hashSet, false);
                }
                object2 = knowledgeBase.getABox().getIndividual((ATerm)aTermAppl).getSame();
                object = new HashSet();
                knowledgeBase.getABox().getSames((Individual)object2, (Set<ATermAppl>)object, (Set<ATermAppl>)object);
                bl2 = SetUtils.intersects(object, hashSet);
            }
            if (bl2) continue;
            return Bool.FALSE;
        }
        return Bool.UNKNOWN;
    }

    private boolean isRootNominal(KnowledgeBase knowledgeBase, ATermAppl aTermAppl) {
        Individual individual = knowledgeBase.getABox().getIndividual((ATerm)aTermAppl);
        return individual != null && individual.isRootNominal();
    }

    private Set<ATermAppl> getRNeighbors(CachedNode cachedNode, Role role) {
        Role role2;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Edge edge : cachedNode.getOutEdges()) {
            role2 = edge.getRole();
            if (!role2.isSubRoleOf(role)) continue;
            hashSet.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            role = role.getInverse();
            for (Edge edge : cachedNode.getInEdges()) {
                role2 = edge.getRole();
                if (!role2.isSubRoleOf(role)) continue;
                hashSet.add(edge.getFromName());
            }
        }
        return hashSet;
    }
}

