/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.EntailmentQueryVisitor;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class EntailmentChecker
implements OWLAxiomVisitor {
    public static Logger log = Logger.getLogger(EntailmentChecker.class.getName());
    public static final Set<AxiomType<?>> UNSUPPORTED_ENTAILMENT = Collections.unmodifiableSet(new HashSet<AxiomType>(Arrays.asList(AxiomType.DISJOINT_UNION, AxiomType.DATATYPE_DEFINITION, AxiomType.HAS_KEY, AxiomType.SUB_PROPERTY_CHAIN_OF, AxiomType.SWRL_RULE)));
    private PelletReasoner reasoner;
    private KnowledgeBase kb;
    private boolean isDeferred = false;
    private boolean isEntailed = false;
    private EntailmentQueryVisitor queryVisitor;

    public EntailmentChecker(PelletReasoner pelletReasoner) {
        this.reasoner = pelletReasoner;
        this.kb = pelletReasoner.getKB();
        this.queryVisitor = new EntailmentQueryVisitor(pelletReasoner);
    }

    private void deferAxiom(OWLIndividualAxiom oWLIndividualAxiom) {
        this.isDeferred = true;
        oWLIndividualAxiom.accept((OWLAxiomVisitor)this.queryVisitor);
    }

    private boolean isEntailed(OWLAxiom oWLAxiom) {
        this.isDeferred = false;
        this.isEntailed = false;
        oWLAxiom.accept((OWLAxiomVisitor)this);
        return this.isDeferred || this.isEntailed;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) {
        if (!set.isEmpty()) {
            this.queryVisitor.reset();
            for (OWLAxiom oWLAxiom : set) {
                if (this.isEntailed(oWLAxiom)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Axiom not entailed: (" + oWLAxiom + ")");
                }
                return false;
            }
            return this.queryVisitor.isEntailed();
        }
        log.warning("Empty ontologies are entailed by any premise document!");
        return true;
    }

    public Set<OWLAxiom> findNonEntailments(Set<? extends OWLAxiom> set, boolean bl) {
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        if (set.isEmpty()) {
            log.warning("Empty ontologies are entailed by any premise document!");
        } else {
            HashSet<OWLAxiom> hashSet2 = new HashSet<OWLAxiom>();
            this.queryVisitor.reset();
            for (OWLAxiom oWLAxiom : set) {
                if (!this.isEntailed(oWLAxiom)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Axiom not entailed: (" + oWLAxiom + ")");
                    }
                    hashSet.add(oWLAxiom);
                    if (!bl) continue;
                    break;
                }
                if (!this.isDeferred) continue;
                hashSet2.add(oWLAxiom);
            }
            if ((bl || hashSet.isEmpty()) && !this.queryVisitor.isEntailed()) {
                hashSet.addAll(hashSet2);
            }
        }
        return hashSet;
    }

    public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
        this.isEntailed = this.kb.isSubClassOf(this.reasoner.term((OWLObject)oWLSubClassOfAxiom.getSubClass()), this.reasoner.term((OWLObject)oWLSubClassOfAxiom.getSuperClass()));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLNegativeObjectPropertyAssertionAxiom.getSubject();
        OWLIndividual oWLIndividual2 = (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject();
        if (oWLIndividual.isAnonymous() || oWLIndividual2.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)oWLNegativeObjectPropertyAssertionAxiom);
            return;
        }
        OWLDataFactory oWLDataFactory = this.reasoner.getManager().getOWLDataFactory();
        OWLObjectHasValue oWLObjectHasValue = oWLDataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty(), oWLIndividual2);
        OWLObjectComplementOf oWLObjectComplementOf = oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)oWLObjectHasValue);
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLObjectComplementOf));
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
        this.isEntailed = this.kb.isAsymmetricProperty(this.reasoner.term((OWLObject)oWLAsymmetricObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
        this.isEntailed = this.kb.isReflexiveProperty(this.reasoner.term((OWLObject)oWLReflexiveObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
        int n;
        this.isEntailed = true;
        int n2 = oWLDisjointClassesAxiom.getClassExpressions().size();
        ATermAppl[] aTermApplArray = new ATermAppl[n2];
        Iterator iterator = oWLDisjointClassesAxiom.getClassExpressions().iterator();
        for (n = 0; n < n2; ++n) {
            aTermApplArray[n] = this.reasoner.term((OWLObject)iterator.next());
        }
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                if (this.kb.isDisjoint(aTermApplArray[n], aTermApplArray[i])) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
        this.isEntailed = this.kb.hasDomain(this.reasoner.term((OWLObject)oWLDataPropertyDomainAxiom.getProperty()), this.reasoner.term((OWLObject)oWLDataPropertyDomainAxiom.getDomain()));
    }

    public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
        this.isEntailed = this.kb.hasDomain(this.reasoner.term((OWLObject)oWLObjectPropertyDomainAxiom.getProperty()), this.reasoner.term((OWLObject)oWLObjectPropertyDomainAxiom.getDomain()));
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
        this.isEntailed = true;
        Iterator iterator = oWLEquivalentObjectPropertiesAxiom.getProperties().iterator();
        if (iterator.hasNext()) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)iterator.next();
            while (iterator.hasNext() && this.isEntailed) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression2 = (OWLObjectPropertyExpression)iterator.next();
                this.isEntailed = this.kb.isEquivalentProperty(this.reasoner.term((OWLObject)oWLObjectPropertyExpression), this.reasoner.term((OWLObject)oWLObjectPropertyExpression2));
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLNegativeDataPropertyAssertionAxiom.getSubject();
        if (oWLIndividual.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)oWLNegativeDataPropertyAssertionAxiom);
            return;
        }
        OWLDataFactory oWLDataFactory = this.reasoner.getManager().getOWLDataFactory();
        OWLDataHasValue oWLDataHasValue = oWLDataFactory.getOWLDataHasValue((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject());
        OWLObjectComplementOf oWLObjectComplementOf = oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)oWLDataHasValue);
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLObjectComplementOf));
    }

    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        this.isEntailed = true;
        for (OWLIndividual oWLIndividual : oWLDifferentIndividualsAxiom.getIndividuals()) {
            if (!oWLIndividual.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)oWLDifferentIndividualsAxiom);
            return;
        }
        ArrayList arrayList = new ArrayList(oWLDifferentIndividualsAxiom.getIndividuals());
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            OWLIndividual oWLIndividual = (OWLIndividual)arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                OWLIndividual oWLIndividual2 = (OWLIndividual)arrayList.get(j);
                if (this.kb.isDifferentFrom(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLIndividual2))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
        this.isEntailed = true;
        int n = oWLDisjointDataPropertiesAxiom.getProperties().size();
        OWLDataProperty[] oWLDataPropertyArray = oWLDisjointDataPropertiesAxiom.getProperties().toArray(new OWLDataProperty[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.kb.isDisjointProperty(this.reasoner.term((OWLObject)oWLDataPropertyArray[i]), this.reasoner.term((OWLObject)oWLDataPropertyArray[j]))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
        this.isEntailed = true;
        int n = oWLDisjointObjectPropertiesAxiom.getProperties().size();
        OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = oWLDisjointObjectPropertiesAxiom.getProperties().toArray(new OWLObjectPropertyExpression[n]);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (this.kb.isDisjointProperty(this.reasoner.term((OWLObject)oWLObjectPropertyExpressionArray[i]), this.reasoner.term((OWLObject)oWLObjectPropertyExpressionArray[j]))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
        this.isEntailed = this.kb.hasRange(this.reasoner.term((OWLObject)oWLObjectPropertyRangeAxiom.getProperty()), this.reasoner.term((OWLObject)oWLObjectPropertyRangeAxiom.getRange()));
    }

    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLObjectPropertyAssertionAxiom.getSubject();
        OWLIndividual oWLIndividual2 = (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject();
        if (oWLIndividual.isAnonymous() || oWLIndividual2.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)oWLObjectPropertyAssertionAxiom);
            return;
        }
        this.isEntailed = this.kb.hasPropertyValue(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLObjectPropertyAssertionAxiom.getProperty()), this.reasoner.term((OWLObject)oWLIndividual2));
    }

    public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
        this.isEntailed = this.kb.isFunctionalProperty(this.reasoner.term((OWLObject)oWLFunctionalObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
        this.isEntailed = this.kb.isSubPropertyOf(this.reasoner.term((OWLObject)oWLSubObjectPropertyOfAxiom.getSubProperty()), this.reasoner.term((OWLObject)oWLSubObjectPropertyOfAxiom.getSuperProperty()));
    }

    public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(oWLDisjointUnionAxiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + oWLDisjointUnionAxiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(oWLDatatypeDefinitionAxiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + oWLDatatypeDefinitionAxiom);
    }

    public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring declaration " + oWLDeclarationAxiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
        this.isEntailed = this.kb.isSymmetricProperty(this.reasoner.term((OWLObject)oWLSymmetricObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
        this.isEntailed = this.kb.hasRange(this.reasoner.term((OWLObject)oWLDataPropertyRangeAxiom.getProperty()), this.reasoner.term((OWLObject)oWLDataPropertyRangeAxiom.getRange()));
    }

    public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
        this.isEntailed = this.kb.isFunctionalProperty(this.reasoner.term((OWLObject)oWLFunctionalDataPropertyAxiom.getProperty()));
    }

    public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
        this.isEntailed = true;
        Iterator iterator = oWLEquivalentDataPropertiesAxiom.getProperties().iterator();
        if (iterator.hasNext()) {
            OWLDataProperty oWLDataProperty = (OWLDataProperty)iterator.next();
            while (iterator.hasNext() && this.isEntailed) {
                OWLDataProperty oWLDataProperty2 = (OWLDataProperty)iterator.next();
                this.isEntailed = this.kb.isEquivalentProperty(this.reasoner.term((OWLObject)oWLDataProperty), this.reasoner.term((OWLObject)oWLDataProperty2));
            }
        }
    }

    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLClassAssertionAxiom.getIndividual();
        OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
        if (oWLIndividual.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)oWLClassAssertionAxiom);
            return;
        }
        this.isEntailed = this.kb.isType(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLClassExpression));
    }

    public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
        this.isEntailed = true;
        Iterator iterator = oWLEquivalentClassesAxiom.getClassExpressions().iterator();
        if (iterator.hasNext()) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)iterator.next();
            while (iterator.hasNext() && this.isEntailed) {
                OWLClassExpression oWLClassExpression2 = (OWLClassExpression)iterator.next();
                this.isEntailed = this.kb.isEquivalentClass(this.reasoner.term((OWLObject)oWLClassExpression), this.reasoner.term((OWLObject)oWLClassExpression2));
            }
        }
    }

    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        OWLIndividual oWLIndividual = oWLDataPropertyAssertionAxiom.getSubject();
        if (oWLIndividual.isAnonymous()) {
            this.deferAxiom((OWLIndividualAxiom)oWLDataPropertyAssertionAxiom);
            return;
        }
        this.isEntailed = this.kb.hasPropertyValue(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLDataPropertyAssertionAxiom.getProperty()), this.reasoner.term((OWLObject)oWLDataPropertyAssertionAxiom.getObject()));
    }

    public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
        this.isEntailed = this.kb.isTransitiveProperty(this.reasoner.term((OWLObject)oWLTransitiveObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
        this.isEntailed = this.kb.isIrreflexiveProperty(this.reasoner.term((OWLObject)oWLIrreflexiveObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
        this.isEntailed = this.kb.isSubPropertyOf(this.reasoner.term((OWLObject)oWLSubDataPropertyOfAxiom.getSubProperty()), this.reasoner.term((OWLObject)oWLSubDataPropertyOfAxiom.getSuperProperty()));
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
        this.isEntailed = this.kb.isInverseFunctionalProperty(this.reasoner.term((OWLObject)oWLInverseFunctionalObjectPropertyAxiom.getProperty()));
    }

    public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(oWLHasKeyAxiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + oWLHasKeyAxiom);
    }

    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        for (OWLIndividual oWLIndividual : oWLSameIndividualAxiom.getIndividuals()) {
            if (!oWLIndividual.isAnonymous()) continue;
            this.deferAxiom((OWLIndividualAxiom)oWLSameIndividualAxiom);
            return;
        }
        this.isEntailed = true;
        Iterator iterator = oWLSameIndividualAxiom.getIndividuals().iterator();
        if (iterator.hasNext()) {
            OWLIndividual oWLIndividual;
            oWLIndividual = (OWLIndividual)iterator.next();
            while (iterator.hasNext()) {
                OWLIndividual oWLIndividual2 = (OWLIndividual)iterator.next();
                if (this.kb.isSameAs(this.reasoner.term((OWLObject)oWLIndividual), this.reasoner.term((OWLObject)oWLIndividual2))) continue;
                this.isEntailed = false;
                return;
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
        assert (UNSUPPORTED_ENTAILMENT.contains(oWLSubPropertyChainOfAxiom.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + oWLSubPropertyChainOfAxiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
        this.isEntailed = this.kb.isInverse(this.reasoner.term((OWLObject)oWLInverseObjectPropertiesAxiom.getFirstProperty()), this.reasoner.term((OWLObject)oWLInverseObjectPropertiesAxiom.getSecondProperty()));
    }

    public void visit(SWRLRule sWRLRule) {
        assert (UNSUPPORTED_ENTAILMENT.contains(sWRLRule.getAxiomType()));
        throw new UnsupportedOperationException("Unsupported entailment query: " + sWRLRule);
    }

    public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation assertion axiom " + oWLAnnotationAssertionAxiom);
        }
    }

    public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property domain " + oWLAnnotationPropertyDomainAxiom);
        }
    }

    public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring annotation property range " + oWLAnnotationPropertyRangeAxiom);
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        this.isEntailed = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring sub annotation property axiom " + oWLSubAnnotationPropertyOfAxiom);
        }
    }
}

