/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDInt
extends AbstractDerivedIntegerType {
    private static final XSDInt instance = new XSDInt();

    public static XSDInt getInstance() {
        return instance;
    }

    private XSDInt() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#int"), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String string) throws InvalidLiteralException {
        try {
            long l = DatatypeConverter.parseLong(string);
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), string);
            }
            return (int)l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.getName(), string);
        }
    }
}

