/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.XSDDecimal;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import pellet.DatatypeConverter;

public class XSDLong
implements Datatype<Number> {
    private static final XSDLong instance;
    private static final Logger log;
    private final RestrictedDatatype<Number> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#long");

    public static XSDLong getInstance() {
        return instance;
    }

    private XSDLong() {
        this.hashCode = this.name.hashCode();
        OWLRealInterval oWLRealInterval = new OWLRealInterval(Long.MIN_VALUE, Long.MAX_VALUE, true, true, OWLRealInterval.LineType.INTEGER_ONLY);
        this.dataRange = new RestrictedRealDatatype(this, oWLRealInterval);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            DatatypeConverter.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.severe(String.format("Number format exception (%s) cause while parsing long %s", numberFormatException.getMessage(), string));
            throw new InvalidLiteralException(this.name, string);
        }
        return XSDDecimal.getInstance().getCanonicalRepresentation(ATermUtils.makeTypedLiteral(string, XSDDecimal.getInstance().getName()));
    }

    @Override
    public ATermAppl getLiteral(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl aTermAppl) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(aTermAppl)) {
            throw new IllegalArgumentException();
        }
        if (!aTermAppl.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String string = ATermUtils.getLiteralValue(aTermAppl);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidLiteralException(this.name, string);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        log = Logger.getLogger(XSDLong.class.getCanonicalName());
        instance = new XSDLong();
    }
}

