/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class OWLRealInterval {
    private static final Logger log = Logger.getLogger(OWLRealInterval.class.getCanonicalName());
    private static OWLRealInterval unconstrainedInteger;
    private static OWLRealInterval unconstrainedReal;
    private final boolean finite;
    private final boolean inclusiveLower;
    private final boolean inclusiveUpper;
    private final Number lower;
    private final boolean point;
    private final LineType type;
    private final Number upper;

    public static OWLRealInterval allIntegers() {
        return unconstrainedInteger;
    }

    public static OWLRealInterval allReals() {
        return unconstrainedReal;
    }

    private static IntervalRelations compare(OWLRealInterval oWLRealInterval, OWLRealInterval oWLRealInterval2) {
        int n = OWLRealInterval.compareLowerLower(oWLRealInterval, oWLRealInterval2);
        if (n < 0) {
            int n2 = OWLRealInterval.compareUpperLower(oWLRealInterval, oWLRealInterval2);
            if (n2 < 0) {
                return IntervalRelations.PRECEDES;
            }
            if (n2 == 0) {
                if (oWLRealInterval.inclusiveUpper()) {
                    if (oWLRealInterval2.inclusiveLower()) {
                        return IntervalRelations.OVERLAPS;
                    }
                    return IntervalRelations.MEETS;
                }
                if (oWLRealInterval2.inclusiveLower()) {
                    return IntervalRelations.MEETS;
                }
                return IntervalRelations.PRECEDES;
            }
            int n3 = OWLRealInterval.compareUpperUpper(oWLRealInterval, oWLRealInterval2);
            if (n3 < 0) {
                return IntervalRelations.OVERLAPS;
            }
            if (n3 == 0) {
                return IntervalRelations.FINISHED_BY;
            }
            return IntervalRelations.CONTAINS;
        }
        if (n == 0) {
            int n4 = OWLRealInterval.compareUpperUpper(oWLRealInterval, oWLRealInterval2);
            if (n4 < 0) {
                return IntervalRelations.STARTS;
            }
            if (n4 == 0) {
                return IntervalRelations.EQUALS;
            }
            return IntervalRelations.STARTED_BY;
        }
        int n5 = -OWLRealInterval.compareUpperLower(oWLRealInterval2, oWLRealInterval);
        if (n5 < 0) {
            int n6 = OWLRealInterval.compareUpperUpper(oWLRealInterval, oWLRealInterval2);
            if (n6 < 0) {
                return IntervalRelations.DURING;
            }
            if (n6 == 0) {
                return IntervalRelations.FINISHES;
            }
            return IntervalRelations.OVERLAPPED_BY;
        }
        if (n5 == 0) {
            if (oWLRealInterval2.inclusiveUpper()) {
                if (oWLRealInterval.inclusiveLower()) {
                    return IntervalRelations.OVERLAPPED_BY;
                }
                return IntervalRelations.MET_BY;
            }
            if (oWLRealInterval.inclusiveLower()) {
                return IntervalRelations.MET_BY;
            }
            return IntervalRelations.PRECEDED_BY;
        }
        return IntervalRelations.PRECEDED_BY;
    }

    private static int compareLowerLower(OWLRealInterval oWLRealInterval, OWLRealInterval oWLRealInterval2) {
        int n;
        if (!oWLRealInterval.boundLower()) {
            n = !oWLRealInterval2.boundLower() ? 0 : -1;
        } else if (!oWLRealInterval2.boundLower()) {
            n = 1;
        } else {
            n = OWLRealUtils.compare(oWLRealInterval.getLower(), oWLRealInterval2.getLower());
            if (n == 0) {
                if (oWLRealInterval.inclusiveLower()) {
                    if (!oWLRealInterval2.inclusiveLower()) {
                        n = -1;
                    }
                } else if (oWLRealInterval2.inclusiveLower()) {
                    n = 1;
                }
            }
        }
        return n;
    }

    private static int compareUpperLower(OWLRealInterval oWLRealInterval, OWLRealInterval oWLRealInterval2) {
        int n = !oWLRealInterval.boundUpper() ? 1 : (!oWLRealInterval2.boundLower() ? 1 : OWLRealUtils.compare(oWLRealInterval.getUpper(), oWLRealInterval2.getLower()));
        return n;
    }

    private static int compareUpperUpper(OWLRealInterval oWLRealInterval, OWLRealInterval oWLRealInterval2) {
        int n;
        if (!oWLRealInterval.boundUpper()) {
            n = !oWLRealInterval2.boundUpper() ? 0 : 1;
        } else if (!oWLRealInterval2.boundUpper()) {
            n = -1;
        } else {
            n = OWLRealUtils.compare(oWLRealInterval.getUpper(), oWLRealInterval2.getUpper());
            if (n == 0) {
                if (oWLRealInterval.inclusiveUpper()) {
                    if (!oWLRealInterval2.inclusiveUpper()) {
                        n = 1;
                    }
                } else if (oWLRealInterval2.inclusiveUpper()) {
                    n = -1;
                }
            }
        }
        return n;
    }

    public OWLRealInterval(Number number) {
        this.lower = number;
        this.upper = number;
        this.point = true;
        this.inclusiveLower = true;
        this.inclusiveUpper = true;
        this.type = LineType.CONTINUOUS;
        this.finite = true;
    }

    public OWLRealInterval(Number number, Number number2, boolean bl, boolean bl2, LineType lineType) {
        if (number != null && number2 != null) {
            int n = OWLRealUtils.compare(number, number2);
            if (n > 0) {
                String string = String.format("Lower bound of interval (%s) should not be greater than upper bound of interval (%s)", number, number2);
                log.severe(string);
                throw new IllegalArgumentException(string);
            }
            if (n == 0) {
                if (!bl || !bl2) {
                    log.severe("Point intervals must be inclusive");
                    throw new IllegalArgumentException("Point intervals must be inclusive");
                }
                lineType = LineType.CONTINUOUS;
            }
        }
        this.type = lineType;
        if (LineType.INTEGER_ONLY.equals((Object)lineType)) {
            if (number == null) {
                this.lower = null;
                this.inclusiveLower = false;
            } else {
                this.lower = bl ? (Number)(OWLRealUtils.isInteger(number) ? (Number)number : (Number)OWLRealUtils.roundDown(number)) : (Number)(OWLRealUtils.isInteger(number) ? (Number)OWLRealUtils.integerIncrement(number) : (Number)OWLRealUtils.roundDown(number));
                this.inclusiveLower = true;
            }
            if (number2 == null) {
                this.upper = null;
                this.inclusiveUpper = false;
            } else {
                this.upper = bl2 ? (Number)(OWLRealUtils.isInteger(number2) ? (Number)number2 : (Number)OWLRealUtils.roundDown(number2)) : (Number)(OWLRealUtils.isInteger(number2) ? (Number)OWLRealUtils.integerDecrement(number2) : (Number)OWLRealUtils.roundDown(number2));
                this.inclusiveUpper = true;
            }
        } else if (LineType.INTEGER_EXCLUDED.equals((Object)lineType)) {
            if (number == null) {
                this.lower = null;
                this.inclusiveLower = false;
            } else {
                this.lower = number;
                this.inclusiveLower = bl ? !OWLRealUtils.isInteger(number) : false;
            }
            if (number2 == null) {
                this.upper = null;
                this.inclusiveUpper = false;
            } else {
                this.upper = number2;
                this.inclusiveUpper = bl2 ? !OWLRealUtils.isInteger(number2) : false;
            }
        } else {
            this.lower = number;
            this.upper = number2;
            this.inclusiveLower = number == null ? false : bl;
            this.inclusiveUpper = number2 == null ? false : bl2;
        }
        this.point = number != null && number2 != null && number.equals(number2);
        this.finite = this.point || LineType.INTEGER_ONLY.equals((Object)lineType) && number != null && number2 != null;
    }

    public boolean boundLower() {
        return this.lower != null;
    }

    public boolean boundUpper() {
        return this.upper != null;
    }

    public IntervalRelations compare(OWLRealInterval oWLRealInterval) {
        return OWLRealInterval.compare(this, oWLRealInterval);
    }

    public boolean contains(Number number) {
        int n;
        if (this.type.equals((Object)LineType.INTEGER_ONLY) ? !OWLRealUtils.isInteger(number) : this.type.equals((Object)LineType.INTEGER_EXCLUDED) && OWLRealUtils.isInteger(number)) {
            return false;
        }
        if (this.boundLower()) {
            n = OWLRealUtils.compare(this.getLower(), number);
            if (n > 0) {
                return false;
            }
            if (n == 0 && !this.inclusiveLower()) {
                return false;
            }
        }
        if (this.boundUpper()) {
            n = OWLRealUtils.compare(this.getUpper(), number);
            if (n < 0) {
                return false;
            }
            if (n == 0 && !this.inclusiveUpper()) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OWLRealInterval oWLRealInterval = (OWLRealInterval)object;
        if (this.inclusiveLower != oWLRealInterval.inclusiveLower) {
            return false;
        }
        if (this.inclusiveUpper != oWLRealInterval.inclusiveUpper) {
            return false;
        }
        if (this.lower == null ? oWLRealInterval.lower != null : OWLRealUtils.compare(this.lower, oWLRealInterval.lower) != 0) {
            return false;
        }
        if (this.type == null ? oWLRealInterval.type != null : !this.type.equals((Object)oWLRealInterval.type)) {
            return false;
        }
        return !(this.upper == null ? oWLRealInterval.upper != null : OWLRealUtils.compare(this.upper, oWLRealInterval.upper) != 0);
    }

    public Number getLower() {
        return this.lower;
    }

    public LineType getType() {
        return this.type;
    }

    public Number getUpper() {
        return this.upper;
    }

    public OWLRealInterval greater(Number number) {
        if (this.boundLower() && OWLRealUtils.compare(number, this.getLower()) < 0) {
            return this;
        }
        if (this.boundUpper() && OWLRealUtils.compare(number, this.getUpper()) >= 0) {
            return null;
        }
        return new OWLRealInterval(number, this.getUpper(), false, this.inclusiveUpper(), this.getType());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.inclusiveLower ? 1231 : 1237);
        n = 31 * n + (this.inclusiveUpper ? 1231 : 1237);
        n = 31 * n + (this.lower == null ? 0 : this.lower.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + (this.upper == null ? 0 : this.upper.hashCode());
        return n;
    }

    public boolean inclusiveLower() {
        return this.inclusiveLower;
    }

    public boolean inclusiveUpper() {
        return this.inclusiveUpper;
    }

    public OWLRealInterval intersection(OWLRealInterval oWLRealInterval) {
        boolean bl;
        Number number;
        boolean bl2;
        Number number2;
        LineType lineType = this.type.intersect(oWLRealInterval.type);
        if (lineType == null) {
            return null;
        }
        switch (this.compare(oWLRealInterval)) {
            case CONTAINS: 
            case STARTED_BY: {
                if (lineType.equals((Object)oWLRealInterval.type)) {
                    return oWLRealInterval;
                }
                number2 = oWLRealInterval.getLower();
                bl2 = oWLRealInterval.inclusiveLower();
                number = oWLRealInterval.getUpper();
                bl = oWLRealInterval.inclusiveUpper();
                break;
            }
            case EQUALS: {
                if (lineType.equals((Object)this.type)) {
                    return this;
                }
                if (lineType.equals((Object)this.type)) {
                    return oWLRealInterval;
                }
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case DURING: 
            case STARTS: {
                if (lineType.equals((Object)this.type)) {
                    return this;
                }
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case FINISHED_BY: {
                number2 = oWLRealInterval.getLower();
                bl2 = oWLRealInterval.inclusiveLower();
                number = oWLRealInterval.getUpper();
                bl = this.inclusiveUpper() && oWLRealInterval.inclusiveUpper();
                break;
            }
            case FINISHES: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper() && oWLRealInterval.inclusiveUpper();
                break;
            }
            case MEETS: 
            case MET_BY: {
                return null;
            }
            case OVERLAPPED_BY: {
                number2 = this.getLower();
                bl2 = this.inclusiveLower();
                number = oWLRealInterval.getUpper();
                bl = oWLRealInterval.inclusiveUpper();
                break;
            }
            case OVERLAPS: {
                number2 = oWLRealInterval.getLower();
                bl2 = oWLRealInterval.inclusiveLower();
                number = this.getUpper();
                bl = this.inclusiveUpper();
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (LineType.INTEGER_ONLY.equals((Object)lineType)) {
            boolean bl3 = false;
            if (number2 != null) {
                if (OWLRealUtils.isInteger(number2)) {
                    if (!bl2) {
                        number2 = OWLRealUtils.integerIncrement(number2);
                        bl2 = true;
                        bl3 = true;
                    }
                } else {
                    number2 = OWLRealUtils.roundDown(number2);
                    bl2 = true;
                    bl3 = true;
                }
            }
            if (number != null) {
                if (OWLRealUtils.isInteger(number)) {
                    if (!bl) {
                        number = OWLRealUtils.integerDecrement(number);
                        bl = true;
                        bl3 = true;
                    }
                } else {
                    number = OWLRealUtils.roundDown(number);
                    bl = true;
                    bl3 = true;
                }
            }
            if (bl3 && number2 != null && number != null && OWLRealUtils.compare(number2, number) > 0) {
                return null;
            }
        } else if (LineType.INTEGER_EXCLUDED.equals((Object)lineType) && number2 != null && number != null && number2.equals(number) && OWLRealUtils.isInteger(number2)) {
            return null;
        }
        return new OWLRealInterval(number2, number, bl2, bl, lineType);
    }

    public boolean isFinite() {
        return this.finite;
    }

    public boolean isPoint() {
        return this.point;
    }

    public OWLRealInterval less(Number number) {
        if (this.boundUpper() && OWLRealUtils.compare(number, this.getUpper()) > 0) {
            return this;
        }
        if (this.boundLower() && OWLRealUtils.compare(number, this.getLower()) <= 0) {
            return null;
        }
        return new OWLRealInterval(this.getLower(), number, this.inclusiveLower(), false, this.getType());
    }

    public List<OWLRealInterval> remove(OWLRealInterval oWLRealInterval) {
        OWLRealInterval oWLRealInterval2;
        OWLRealInterval oWLRealInterval3;
        OWLRealInterval oWLRealInterval4;
        LineType lineType = this.getType();
        LineType lineType2 = oWLRealInterval.getType();
        if (LineType.INTEGER_ONLY.equals((Object)lineType) ? LineType.INTEGER_EXCLUDED.equals((Object)lineType2) : LineType.INTEGER_EXCLUDED.equals((Object)lineType) && LineType.INTEGER_ONLY.equals((Object)lineType2)) {
            return Collections.singletonList(this);
        }
        switch (this.compare(oWLRealInterval)) {
            case CONTAINS: {
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = lineType.equals((Object)lineType2) || LineType.CONTINUOUS.equals((Object)lineType2) ? null : new OWLRealInterval(oWLRealInterval.getLower(), oWLRealInterval.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)lineType2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                oWLRealInterval2 = new OWLRealInterval(oWLRealInterval.getUpper(), this.getUpper(), !oWLRealInterval.inclusiveUpper(), this.inclusiveUpper(), lineType);
                break;
            }
            case EQUALS: 
            case DURING: 
            case STARTS: 
            case FINISHES: {
                oWLRealInterval4 = null;
                oWLRealInterval3 = lineType.equals((Object)lineType2) || LineType.CONTINUOUS.equals((Object)lineType2) ? null : new OWLRealInterval(this.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)lineType2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                oWLRealInterval2 = null;
                break;
            }
            case FINISHED_BY: {
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = lineType.equals((Object)lineType2) || LineType.CONTINUOUS.equals((Object)lineType2) ? null : new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)lineType2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                oWLRealInterval2 = null;
                break;
            }
            case MEETS: {
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), false, lineType);
                oWLRealInterval3 = null;
                oWLRealInterval2 = null;
                break;
            }
            case MET_BY: {
                oWLRealInterval4 = null;
                oWLRealInterval3 = null;
                oWLRealInterval2 = new OWLRealInterval(this.getLower(), this.getUpper(), false, this.inclusiveUpper(), lineType);
                break;
            }
            case STARTED_BY: 
            case OVERLAPPED_BY: {
                oWLRealInterval4 = null;
                oWLRealInterval3 = lineType.equals((Object)lineType2) || LineType.CONTINUOUS.equals((Object)lineType2) ? null : new OWLRealInterval(this.getLower(), oWLRealInterval.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)lineType2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                oWLRealInterval2 = new OWLRealInterval(oWLRealInterval.getUpper(), this.getUpper(), !oWLRealInterval.inclusiveUpper(), this.inclusiveUpper(), lineType);
                break;
            }
            case OVERLAPS: {
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = lineType.equals((Object)lineType2) || LineType.CONTINUOUS.equals((Object)lineType2) ? null : new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), false, false, LineType.INTEGER_EXCLUDED.equals((Object)lineType2) ? LineType.INTEGER_ONLY : LineType.INTEGER_EXCLUDED);
                oWLRealInterval2 = null;
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Collections.singletonList(this);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>();
        if (oWLRealInterval4 != null) {
            arrayList.add(oWLRealInterval4);
        }
        if (oWLRealInterval3 != null) {
            arrayList.add(oWLRealInterval3);
        }
        if (oWLRealInterval2 != null) {
            arrayList.add(oWLRealInterval2);
        }
        return arrayList;
    }

    public Number size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        if (this.point) {
            return 1;
        }
        return OWLRealUtils.integerIncrement(OWLRealUtils.integerDifference(this.upper, this.lower));
    }

    public String toString() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.inclusiveLower() ? "[" : "(";
        objectArray[1] = this.boundLower() ? this.getLower() : "-Inf";
        objectArray[2] = this.boundUpper() ? this.getUpper() : "+Inf";
        Object object = objectArray[3] = this.inclusiveUpper() ? "]" : ")";
        objectArray[4] = this.type.equals((Object)LineType.CONTINUOUS) ? "" : (this.type.equals((Object)LineType.INTEGER_ONLY) ? "{int}" : "{noint}");
        return String.format("%s%s,%s%s%s", objectArray);
    }

    public List<OWLRealInterval> union(OWLRealInterval oWLRealInterval) {
        OWLRealInterval oWLRealInterval2;
        OWLRealInterval oWLRealInterval3;
        OWLRealInterval oWLRealInterval4;
        LineType lineType = this.getType();
        LineType lineType2 = oWLRealInterval.getType();
        switch (this.compare(oWLRealInterval)) {
            case CONTAINS: {
                if (LineType.CONTINUOUS.equals((Object)lineType) || lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(this);
                }
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = LineType.CONTINUOUS.equals((Object)lineType2) ? oWLRealInterval : new OWLRealInterval(oWLRealInterval.getLower(), oWLRealInterval.getUpper(), oWLRealInterval.inclusiveLower(), oWLRealInterval.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = new OWLRealInterval(oWLRealInterval.getUpper(), this.getUpper(), !oWLRealInterval.inclusiveUpper(), this.inclusiveUpper(), lineType);
                break;
            }
            case DURING: {
                if (LineType.CONTINUOUS.equals((Object)lineType2) || lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(oWLRealInterval);
                }
                oWLRealInterval4 = new OWLRealInterval(oWLRealInterval.getLower(), this.getLower(), oWLRealInterval.inclusiveLower(), !this.inclusiveLower(), lineType2);
                oWLRealInterval3 = LineType.CONTINUOUS.equals((Object)lineType) ? this : new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = new OWLRealInterval(this.getUpper(), oWLRealInterval.getUpper(), !this.inclusiveUpper(), oWLRealInterval.inclusiveUpper(), lineType2);
                break;
            }
            case EQUALS: {
                if (LineType.CONTINUOUS.equals((Object)lineType) || lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(this);
                }
                if (LineType.CONTINUOUS.equals((Object)lineType2)) {
                    return Collections.singletonList(oWLRealInterval);
                }
                oWLRealInterval4 = null;
                oWLRealInterval3 = new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = null;
                break;
            }
            case FINISHED_BY: {
                if (LineType.CONTINUOUS.equals((Object)lineType) || lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(this);
                }
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = LineType.CONTINUOUS.equals((Object)lineType2) ? oWLRealInterval : new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), oWLRealInterval.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = null;
                break;
            }
            case FINISHES: {
                if (LineType.CONTINUOUS.equals((Object)lineType2) || lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(oWLRealInterval);
                }
                oWLRealInterval4 = new OWLRealInterval(oWLRealInterval.getLower(), this.getLower(), oWLRealInterval.inclusiveLower(), !this.inclusiveLower(), lineType2);
                oWLRealInterval3 = LineType.CONTINUOUS.equals((Object)lineType) ? this : new OWLRealInterval(this.getLower(), this.getUpper(), this.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = null;
                break;
            }
            case MEETS: {
                if (lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(new OWLRealInterval(this.getLower(), oWLRealInterval.getUpper(), this.inclusiveLower(), oWLRealInterval.inclusiveUpper(), lineType));
                }
                return Arrays.asList(this, oWLRealInterval);
            }
            case MET_BY: {
                if (lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), oWLRealInterval.inclusiveLower(), this.inclusiveUpper(), lineType));
                }
                return Arrays.asList(oWLRealInterval, this);
            }
            case OVERLAPPED_BY: {
                if (lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), oWLRealInterval.inclusiveLower(), this.inclusiveUpper(), lineType));
                }
                if (LineType.CONTINUOUS.equals((Object)lineType2)) {
                    oWLRealInterval4 = oWLRealInterval;
                    oWLRealInterval3 = null;
                    oWLRealInterval2 = new OWLRealInterval(oWLRealInterval.getUpper(), this.getUpper(), !oWLRealInterval.inclusiveUpper(), this.inclusiveUpper(), lineType);
                    break;
                }
                if (LineType.CONTINUOUS.equals((Object)lineType)) {
                    oWLRealInterval4 = new OWLRealInterval(oWLRealInterval.getLower(), this.getLower(), oWLRealInterval.inclusiveLower(), !this.inclusiveLower(), lineType2);
                    oWLRealInterval3 = null;
                    oWLRealInterval2 = this;
                    break;
                }
                oWLRealInterval4 = new OWLRealInterval(oWLRealInterval.getLower(), this.getLower(), oWLRealInterval.inclusiveLower(), !this.inclusiveLower(), lineType2);
                oWLRealInterval3 = new OWLRealInterval(this.getLower(), oWLRealInterval.getUpper(), this.inclusiveLower(), oWLRealInterval.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = new OWLRealInterval(oWLRealInterval.getUpper(), this.getUpper(), !oWLRealInterval.inclusiveUpper(), this.inclusiveUpper(), lineType);
                break;
            }
            case OVERLAPS: {
                if (lineType.equals((Object)lineType2)) {
                    return Collections.singletonList(new OWLRealInterval(this.getLower(), oWLRealInterval.getUpper(), this.inclusiveLower(), oWLRealInterval.inclusiveUpper(), lineType));
                }
                if (LineType.CONTINUOUS.equals((Object)lineType)) {
                    oWLRealInterval4 = this;
                    oWLRealInterval3 = null;
                    oWLRealInterval2 = new OWLRealInterval(this.getUpper(), oWLRealInterval.getUpper(), !this.inclusiveUpper(), oWLRealInterval.inclusiveUpper(), lineType2);
                    break;
                }
                if (LineType.CONTINUOUS.equals((Object)lineType2)) {
                    oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                    oWLRealInterval3 = null;
                    oWLRealInterval2 = oWLRealInterval;
                    break;
                }
                oWLRealInterval4 = new OWLRealInterval(this.getLower(), oWLRealInterval.getLower(), this.inclusiveLower(), !oWLRealInterval.inclusiveLower(), lineType);
                oWLRealInterval3 = new OWLRealInterval(oWLRealInterval.getLower(), this.getUpper(), oWLRealInterval.inclusiveLower(), this.inclusiveUpper(), LineType.CONTINUOUS);
                oWLRealInterval2 = new OWLRealInterval(this.getUpper(), oWLRealInterval.getUpper(), !this.inclusiveUpper(), oWLRealInterval.inclusiveUpper(), lineType2);
                break;
            }
            case PRECEDED_BY: 
            case PRECEDES: {
                return Arrays.asList(this, oWLRealInterval);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ArrayList<OWLRealInterval> arrayList = new ArrayList<OWLRealInterval>();
        if (oWLRealInterval4 != null) {
            arrayList.add(oWLRealInterval4);
        }
        if (oWLRealInterval3 != null) {
            arrayList.add(oWLRealInterval3);
        }
        if (oWLRealInterval2 != null) {
            arrayList.add(oWLRealInterval2);
        }
        return arrayList;
    }

    public Iterator<Number> valueIterator() {
        if (this.isPoint()) {
            return Collections.singletonList(this.getUpper()).iterator();
        }
        if (LineType.INTEGER_ONLY.equals((Object)this.getType())) {
            Number number;
            boolean bl;
            Number number2;
            if (this.boundLower()) {
                number2 = this.getLower();
                bl = true;
                number = this.boundUpper() ? (Number)this.getUpper() : (Number)null;
            } else if (this.boundUpper()) {
                number2 = this.getUpper();
                bl = false;
                number = null;
            } else {
                number2 = (byte)0;
                bl = true;
                number = null;
            }
            return new IntegerIterator(number2, number, bl);
        }
        throw new IllegalStateException();
    }

    static {
        unconstrainedReal = new OWLRealInterval(null, null, true, true, LineType.CONTINUOUS);
        unconstrainedInteger = new OWLRealInterval(null, null, true, true, LineType.INTEGER_ONLY);
    }

    public static enum LineType {
        CONTINUOUS,
        INTEGER_EXCLUDED,
        INTEGER_ONLY;


        public LineType intersect(LineType lineType) {
            if (lineType == null) {
                throw new NullPointerException();
            }
            switch (this) {
                case CONTINUOUS: {
                    return lineType;
                }
                case INTEGER_ONLY: {
                    if (lineType.equals((Object)INTEGER_EXCLUDED)) {
                        return null;
                    }
                    return INTEGER_ONLY;
                }
                case INTEGER_EXCLUDED: {
                    if (lineType.equals((Object)INTEGER_ONLY)) {
                        return null;
                    }
                    return INTEGER_EXCLUDED;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static class IntegerIterator
    implements Iterator<Number> {
        private final boolean increment;
        private final Number last;
        private Number next;

        public IntegerIterator(Number number, Number number2, boolean bl) {
            this.last = number2;
            this.increment = bl;
            this.next = number;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Number next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Number number = this.next;
            this.next = this.last != null && OWLRealUtils.compare(this.next, this.last) == 0 ? null : (this.increment ? (Number)OWLRealUtils.integerIncrement(this.next) : (Number)OWLRealUtils.integerDecrement(this.next));
            return number;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

