/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.datatypes.DataRange;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class DataValueEnumeration<T>
implements DataRange<T> {
    private final Set<T> values;
    private final int size;

    public DataValueEnumeration(Collection<? extends T> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.values = Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
        this.size = this.values.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.values.contains(object);
    }

    @Override
    public boolean containsAtLeast(int n) {
        return this.size >= n;
    }

    @Override
    public T getValue(int n) {
        if (n >= this.size) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = this.values.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> valueIterator() {
        return this.values.iterator();
    }

    public String toString() {
        return String.format("OneOf%s", this.values);
    }
}

