/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletRealize
extends PelletCmdApp {
    @Override
    public String getAppCmd() {
        return "pellet realize " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletRealize: Compute and display the most specific instances for each class";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions pelletCmdOptions = this.getGlobalOptions();
        pelletCmdOptions.add(this.getLoaderOption());
        pelletCmdOptions.add(this.getIgnoreImportsOption());
        pelletCmdOptions.add(this.getInputFormatOption());
        pelletCmdOptions.add(this.getInferPropValuesOption());
        pelletCmdOptions.add(this.getInferDataPropValuesOption());
        return pelletCmdOptions;
    }

    @Override
    public void run() {
        List<ATermAppl> list;
        ATermAppl aTermAppl;
        KnowledgeBase knowledgeBase = this.getKB();
        this.startTask("consistency check");
        boolean bl = knowledgeBase.isConsistent();
        this.finishTask("consistency check");
        if (!bl) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        this.startTask("classification");
        knowledgeBase.classify();
        this.finishTask("classification");
        this.startTask("realization");
        knowledgeBase.realize();
        this.finishTask("realization");
        ClassTreePrinter classTreePrinter = new ClassTreePrinter();
        classTreePrinter.print(knowledgeBase.getTaxonomy());
        if (this.options.getOption("infer-prop-values").getValue() != null) {
            for (ATermAppl aTermAppl2 : knowledgeBase.getIndividuals()) {
                for (Role role : knowledgeBase.getRBox().getRoles()) {
                    if (role.isAnon() || !role.isObjectRole()) continue;
                    aTermAppl = role.getName();
                    list = knowledgeBase.getObjectPropertyValues(aTermAppl, aTermAppl2);
                    for (ATermAppl aTermAppl3 : list) {
                        System.out.println("PROPINST: " + aTermAppl2 + " " + aTermAppl + " " + aTermAppl3);
                    }
                }
            }
        }
        if (this.options.getOption("infer-data-prop-values").getValue() != null) {
            for (ATermAppl aTermAppl2 : knowledgeBase.getIndividuals()) {
                for (Role role : knowledgeBase.getRBox().getRoles()) {
                    if (role.isAnon() || !role.isDatatypeRole()) continue;
                    aTermAppl = role.getName();
                    list = knowledgeBase.getDataPropertyValues(aTermAppl, aTermAppl2);
                    for (ATermAppl aTermAppl3 : list) {
                        System.out.println("DATAPROPVAL: " + aTermAppl2 + " " + aTermAppl + " " + aTermAppl3);
                    }
                }
            }
        }
    }
}

