/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.el.SimplifiedELClassifier;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ExpressivityChecker;
import com.clarkparsia.pellet.rules.ContinuousRulesStrategy;
import com.clarkparsia.pellet.rules.RuleStrategy;
import com.clarkparsia.pellet.rules.UsableRuleFilter;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomImpl;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.model.UnaryAtom;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.PropertyType;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.EmptySRIQStrategy;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.tableau.completion.incremental.IncrementalRestore;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.TBoxFactory;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AnnotationClasses;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.SizeEstimate;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

public class KnowledgeBase {
    public static final Logger log = Logger.getLogger(KnowledgeBase.class.getName());
    private ATermFactory factory = ATermUtils.getFactory();
    protected ABox abox;
    protected TBox tbox;
    protected RBox rbox;
    private Set<ATermAppl> individuals;
    protected TaxonomyBuilder builder;
    private ProgressMonitor builderProgressMonitor;
    private boolean consistent;
    private SizeEstimate estimate;
    private boolean explainOnlyInconsistency = false;
    private Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> annotations;
    protected EnumSet<ReasoningState> state = EnumSet.noneOf(ReasoningState.class);
    private Map<ATermAppl, Set<ATermAppl>> instances;
    private ExpressivityChecker expChecker;
    public Timers timers = new Timers();
    private Map<Rule, Rule> rules;
    private Set<ATermAppl> deletedAssertions;
    private DependencyIndex dependencyIndex;
    private Set<ATermAppl> syntacticAssertions;
    protected MultiValueMap<AssertionType, ATermAppl> aboxAssertions;
    protected EnumSet<ChangeType> changes;
    protected boolean canUseIncConsistency;
    FullyDefinedClassVisitor fullyDefinedVisitor = new FullyDefinedClassVisitor();
    DatatypeVisitor datatypeVisitor = new DatatypeVisitor();

    public KnowledgeBase() {
        this.clear();
        this.timers.createTimer("preprocessing");
        this.timers.createTimer("consistency");
        this.timers.createTimer("complete");
        this.state = EnumSet.noneOf(ReasoningState.class);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.deletedAssertions = new HashSet<ATermAppl>();
            this.dependencyIndex = new DependencyIndex(this);
            this.syntacticAssertions = new HashSet<ATermAppl>();
        }
        this.aboxAssertions = new MultiValueMap();
        this.annotations = new HashMap<ATermAppl, Map<ATermAppl, Set<ATermAppl>>>();
    }

    protected KnowledgeBase(KnowledgeBase knowledgeBase, boolean bl) {
        this.tbox = knowledgeBase.tbox;
        this.rbox = knowledgeBase.rbox;
        this.rules = knowledgeBase.rules;
        this.aboxAssertions = new MultiValueMap();
        this.annotations = knowledgeBase.annotations;
        this.expChecker = new ExpressivityChecker(this, knowledgeBase.getExpressivity());
        this.changes = knowledgeBase.changes.clone();
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.deletedAssertions = new HashSet<ATermAppl>();
            this.dependencyIndex = new DependencyIndex(this);
            this.syntacticAssertions = new HashSet<ATermAppl>();
        }
        if (bl) {
            this.abox = new ABox(this);
            this.individuals = new HashSet<ATermAppl>();
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl aTermAppl : knowledgeBase.getExpressivity().getNominals()) {
                this.addIndividual(aTermAppl);
            }
        } else {
            this.abox = knowledgeBase.abox.copy(this);
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                for (AssertionType assertionType : AssertionType.values()) {
                    Set set = (Set)knowledgeBase.aboxAssertions.get((Object)assertionType);
                    if (set.isEmpty()) continue;
                    this.aboxAssertions.put(assertionType, new HashSet(set));
                }
            }
            this.individuals = new HashSet<ATermAppl>(knowledgeBase.individuals);
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>(knowledgeBase.instances);
            if (knowledgeBase.getDeletedAssertions() != null) {
                this.deletedAssertions = new HashSet<ATermAppl>(knowledgeBase.getDeletedAssertions());
            }
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY && PelletOptions.USE_INCREMENTAL_DELETION) {
                this.dependencyIndex = new DependencyIndex(this, knowledgeBase.dependencyIndex);
            }
            if (knowledgeBase.syntacticAssertions != null) {
                this.syntacticAssertions = new HashSet<ATermAppl>(knowledgeBase.syntacticAssertions);
            }
        }
        if (knowledgeBase.isConsistencyDone()) {
            this.prepare();
            this.state = EnumSet.of(ReasoningState.CONSISTENCY);
            this.consistent = knowledgeBase.consistent;
            this.abox.setComplete(true);
            this.estimate = new SizeEstimate(this);
        } else {
            this.state = EnumSet.noneOf(ReasoningState.class);
        }
        this.timers = knowledgeBase.timers;
    }

    public Expressivity getExpressivity() {
        return this.getExpressivityChecker().getExpressivity();
    }

    public ExpressivityChecker getExpressivityChecker() {
        if (this.canUseIncConsistency()) {
            return this.expChecker;
        }
        this.prepare();
        return this.expChecker;
    }

    public void clear() {
        if (this.abox == null) {
            this.abox = new ABox(this);
        } else {
            boolean bl = this.abox.doExplanation();
            boolean bl2 = this.abox.isKeepLastCompletion();
            this.abox = new ABox(this);
            this.abox.setDoExplanation(bl);
            this.abox.setKeepLastCompletion(bl2);
        }
        this.tbox = TBoxFactory.createTBox(this);
        this.rbox = new RBox();
        this.rules = new HashMap<Rule, Rule>();
        this.expChecker = new ExpressivityChecker(this);
        this.individuals = new HashSet<ATermAppl>();
        this.aboxAssertions = new MultiValueMap();
        this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
        this.builder = null;
        this.state.clear();
        this.changes = EnumSet.of(ChangeType.ABOX_ADD, ChangeType.TBOX_ADD, ChangeType.RBOX_ADD);
    }

    public KnowledgeBase copy() {
        return this.copy(false);
    }

    public KnowledgeBase copy(boolean bl) {
        return new KnowledgeBase(this, bl);
    }

    public void loadKRSS(Reader reader) throws IOException {
        KRSSLoader kRSSLoader = new KRSSLoader(this);
        kRSSLoader.parse(reader);
    }

    public void addClass(ATermAppl aTermAppl) {
        if (aTermAppl.equals(ATermUtils.TOP) || ATermUtils.isComplexClass((ATerm)aTermAppl)) {
            return;
        }
        boolean bl = this.tbox.addClass(aTermAppl);
        if (bl) {
            this.changes.add(ChangeType.TBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("class " + aTermAppl);
            }
        }
    }

    public void addSubClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (aTermAppl.equals(aTermAppl2)) {
            return;
        }
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeSub((ATerm)aTermAppl, (ATerm)aTermAppl2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("sub-class " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addEquivalentClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (aTermAppl.equals(aTermAppl2)) {
            return;
        }
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeEqClasses((ATerm)aTermAppl, (ATerm)aTermAppl2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("eq-class " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addKey(ATermAppl aTermAppl, Set<ATermAppl> set) {
        int n = 0;
        Set set2 = CollectionUtils.makeSet();
        Set set3 = CollectionUtils.makeSet();
        AtomIVariable atomIVariable = new AtomIVariable("x");
        AtomIVariable atomIVariable2 = new AtomIVariable("y");
        set2.add(new SameIndividualAtom(atomIVariable, atomIVariable2));
        for (ATermAppl aTermAppl2 : set) {
            AtomVariable atomVariable;
            if (this.isObjectProperty((ATerm)aTermAppl2)) {
                atomVariable = new AtomIVariable("z" + n);
                set3.add(new IndividualPropertyAtom(aTermAppl2, atomIVariable, (AtomIObject)((Object)atomVariable)));
                set3.add(new IndividualPropertyAtom(aTermAppl2, atomIVariable2, (AtomIObject)((Object)atomVariable)));
            } else if (this.isDatatypeProperty((ATerm)aTermAppl2)) {
                atomVariable = new AtomDVariable("z" + n);
                set3.add(new DatavaluedPropertyAtom(aTermAppl2, atomIVariable, (AtomDObject)((Object)atomVariable)));
                set3.add(new DatavaluedPropertyAtom(aTermAppl2, atomIVariable2, (AtomDObject)((Object)atomVariable)));
            }
            ++n;
        }
        set3.add(new ClassAtom(aTermAppl, atomIVariable));
        set3.add(new ClassAtom(aTermAppl, atomIVariable2));
        this.addRule(new Rule(set2, set3));
    }

    public void addDisjointClasses(ATermList aTermList) {
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeDisjoints(aTermList));
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoints " + aTermList);
        }
    }

    public void addDisjointClasses(List<ATermAppl> list) {
        this.addDisjointClasses(ATermUtils.toSet(list));
    }

    public void addDisjointClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeDisjoint((ATerm)aTermAppl, (ATerm)aTermAppl2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoint " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addComplementClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.changes.add(ChangeType.TBOX_ADD);
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        if (aTermAppl.equals(aTermAppl3)) {
            return;
        }
        this.tbox.addAxiom(ATermUtils.makeEqClasses((ATerm)aTermAppl, (ATerm)aTermAppl3));
        if (log.isLoggable(Level.FINER)) {
            log.finer("complement " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addDataPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        this.addPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
    }

    public Individual addIndividual(ATermAppl aTermAppl) {
        Node node = this.abox.getNode((ATerm)aTermAppl);
        if (node != null) {
            if (node instanceof Literal) {
                throw new UnsupportedFeatureException("Trying to use a literal as an individual: " + ATermUtils.toString(aTermAppl));
            }
            return (Individual)node;
        }
        if (ATermUtils.isLiteral(aTermAppl)) {
            throw new UnsupportedFeatureException("Trying to use a literal as an individual: " + ATermUtils.toString(aTermAppl));
        }
        int n = this.abox.getBranch();
        this.abox.setBranch(DependencySet.NO_BRANCH);
        this.abox.setSyntacticUpdate(true);
        Individual individual = this.abox.addIndividual(aTermAppl, DependencySet.INDEPENDENT);
        this.individuals.add(aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            log.finer("individual " + aTermAppl);
        }
        this.abox.setSyntacticUpdate(false);
        if (!PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl aTermAppl2 = ATermUtils.makeValue((ATerm)aTermAppl);
            this.abox.addType(aTermAppl, aTermAppl2, DependencySet.INDEPENDENT);
        }
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.setSyntacticUpdate(true);
            for (int i = 0; i < this.abox.getBranches().size(); ++i) {
                Branch branch = this.abox.getBranches().get(i);
                branch.setNodeCount(branch.getNodeCount() + 1);
            }
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl));
            this.abox.getIncrementalChangeTracker().addNewIndividual(this.abox.getIndividual((ATerm)aTermAppl));
            this.abox.setSyntacticUpdate(false);
        }
        this.abox.setBranch(n);
        return individual;
    }

    public void addType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        DependencySet dependencySet;
        if (AnnotationClasses.contains(aTermAppl2)) {
            return;
        }
        ATermAppl aTermAppl3 = ATermUtils.makeTypeAtom(aTermAppl, aTermAppl2);
        DependencySet dependencySet2 = dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl3) : DependencySet.INDEPENDENT;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.syntacticAssertions.add(aTermAppl3);
            this.dependencyIndex.addTypeDependency(aTermAppl, aTermAppl2, dependencySet);
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            this.aboxAssertions.add(AssertionType.TYPE, aTermAppl3);
        }
        this.addType(aTermAppl, aTermAppl2, dependencySet);
    }

    public void addType(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl));
        }
        this.abox.setSyntacticUpdate(true);
        this.abox.addType(aTermAppl, aTermAppl2, dependencySet);
        this.abox.setSyntacticUpdate(false);
        if (this.canUseIncConsistency()) {
            this.updateExpressivity(aTermAppl, aTermAppl2);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("type " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addSame(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl2));
            this.abox.addSame(aTermAppl, aTermAppl2);
        }
        this.abox.addSame(aTermAppl, aTermAppl2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("same " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addAllDifferent(ATermList aTermList) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            ATermList aTermList2 = aTermList;
            while (!aTermList2.isEmpty()) {
                ATermList aTermList3 = aTermList2.getNext();
                while (!aTermList3.isEmpty()) {
                    this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(aTermList2.getFirst()));
                    this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(aTermList3.getFirst()));
                    aTermList3 = aTermList3.getNext();
                }
                aTermList2 = aTermList2.getNext();
            }
            int n = this.abox.getBranch();
            this.abox.setBranch(0);
            this.abox.addAllDifferent(aTermList);
            this.abox.setBranch(n);
        }
        this.abox.addAllDifferent(aTermList);
        if (log.isLoggable(Level.FINER)) {
            log.finer("all diff " + aTermList);
        }
    }

    public void addDifferent(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl2));
            int n = this.abox.getBranch();
            this.abox.setBranch(0);
            this.abox.addDifferent(aTermAppl, aTermAppl2);
            this.abox.setBranch(n);
        }
        this.abox.addDifferent(aTermAppl, aTermAppl2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("diff " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addObjectPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        this.addPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
    }

    public boolean addPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        DependencySet dependencySet;
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl2);
        Role role = this.getRole((ATerm)aTermAppl);
        Node node = null;
        if (individual == null) {
            log.warning(aTermAppl2 + " is not a known individual!");
            return false;
        }
        if (role == null) {
            log.warning(aTermAppl + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return false;
        }
        ATermAppl aTermAppl4 = ATermUtils.makePropAtom(aTermAppl, aTermAppl2, aTermAppl3);
        DependencySet dependencySet2 = dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl4) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            node = this.abox.getIndividual((ATerm)aTermAppl3);
            if (node == null) {
                if (ATermUtils.isLiteral(aTermAppl3)) {
                    log.warning("Ignoring literal value " + aTermAppl3 + " for object property " + aTermAppl);
                    return false;
                }
                log.warning(aTermAppl3 + " is not a known individual!");
                return false;
            }
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.OBJ_ROLE, aTermAppl4);
            }
        } else if (role.isDatatypeRole()) {
            if (!ATermUtils.isLiteral(aTermAppl3)) {
                log.warning("Ignoring non-literal value " + aTermAppl3 + " for data property " + aTermAppl);
                return false;
            }
            node = this.abox.addLiteral(aTermAppl3, dependencySet);
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.DATA_ROLE, aTermAppl4);
            }
        }
        this.changes.add(ChangeType.ABOX_ADD);
        if (!this.canUseIncConsistency()) {
            Edge edge = this.abox.addEdge(aTermAppl, aTermAppl2, node.getName(), dependencySet);
            if (edge == null) {
                this.abox.reset();
                edge = this.abox.addEdge(aTermAppl, aTermAppl2, node.getName(), dependencySet);
                assert (edge != null);
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.syntacticAssertions.add(aTermAppl4);
                this.dependencyIndex.addEdgeDependency(edge, edge.getDepends());
            }
        } else if (this.canUseIncConsistency()) {
            Individual individual2;
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl2));
            if (role.isObjectRole()) {
                this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual((ATerm)aTermAppl3));
                node = this.abox.getIndividual((ATerm)aTermAppl3);
                if (node.isPruned() || node.isMerged()) {
                    node = node.getSame();
                }
            }
            if ((individual2 = this.abox.getIndividual((ATerm)aTermAppl2)).isPruned() || individual2.isMerged()) {
                individual2 = individual2.getSame();
            }
            dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makePropAtom(aTermAppl, aTermAppl2, aTermAppl3)) : DependencySet.INDEPENDENT;
            int n = this.abox.getBranch();
            this.abox.setBranch(DependencySet.NO_BRANCH);
            Edge edge = individual2.addEdge(role, node, dependencySet);
            this.abox.setBranch(n);
            if (edge != null) {
                this.abox.getIncrementalChangeTracker().addNewEdge(edge);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("prop-value " + aTermAppl2 + " " + aTermAppl + " " + aTermAppl3);
        }
        return true;
    }

    public boolean addNegatedPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        DependencySet dependencySet;
        this.changes.add(ChangeType.ABOX_ADD);
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl2);
        Role role = this.getRole((ATerm)aTermAppl);
        if (individual == null) {
            log.warning(aTermAppl2 + " is not a known individual!");
            return false;
        }
        if (role == null) {
            log.warning(aTermAppl + " is not a known property!");
            return false;
        }
        ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)ATermUtils.makePropAtom(aTermAppl, aTermAppl2, aTermAppl3));
        DependencySet dependencySet2 = dependencySet = PelletOptions.USE_TRACING ? new DependencySet(aTermAppl4) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            if (this.abox.getIndividual((ATerm)aTermAppl3) == null) {
                if (ATermUtils.isLiteral(aTermAppl3)) {
                    log.warning("Ignoring literal value " + aTermAppl3 + " for object property " + aTermAppl);
                    return false;
                }
                log.warning(aTermAppl3 + " is not a known individual!");
                return false;
            }
        } else if (role.isDatatypeRole()) {
            this.abox.addLiteral(aTermAppl3, dependencySet);
        }
        ATermAppl aTermAppl5 = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl3));
        this.addType(aTermAppl2, aTermAppl5, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("not-prop-value " + aTermAppl2 + " " + aTermAppl + " " + aTermAppl3);
        }
        return true;
    }

    public void addProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRole(aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            log.finer("prop " + aTermAppl);
        }
    }

    public boolean addObjectProperty(ATerm aTerm) {
        boolean bl = this.getPropertyType(aTerm) == PropertyType.OBJECT;
        Role role = this.rbox.addObjectRole((ATermAppl)aTerm);
        if (!bl) {
            this.changes.add(ChangeType.RBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("object-prop " + aTerm);
            }
        }
        return role != null;
    }

    public boolean addDatatypeProperty(ATerm aTerm) {
        boolean bl = this.getPropertyType(aTerm) == PropertyType.DATATYPE;
        Role role = this.rbox.addDatatypeRole((ATermAppl)aTerm);
        if (!bl) {
            this.changes.add(ChangeType.RBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("data-prop " + aTerm);
            }
        }
        return role != null;
    }

    @Deprecated
    public void addOntologyProperty(ATermAppl aTermAppl) {
        this.addAnnotationProperty((ATerm)aTermAppl);
    }

    public boolean addAnnotationProperty(ATerm aTerm) {
        boolean bl = this.getPropertyType(aTerm) == PropertyType.ANNOTATION;
        Role role = this.rbox.addAnnotationRole((ATermAppl)aTerm);
        if (!bl) {
            this.changes.add(ChangeType.RBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("annotation-prop " + aTerm);
            }
        }
        return role != null;
    }

    public boolean addAnnotation(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Set<ATermAppl> set;
        if (!PelletOptions.USE_ANNOTATION_SUPPORT) {
            return false;
        }
        if (!this.isAnnotationProperty((ATerm)aTermAppl2)) {
            return false;
        }
        Map<ATermAppl, Set<ATermAppl>> map = this.annotations.get(aTermAppl);
        if (map == null) {
            map = new HashMap<ATermAppl, Set<ATermAppl>>();
        }
        if ((set = map.get(aTermAppl2)) == null) {
            set = new HashSet<ATermAppl>();
        }
        set.add(aTermAppl3);
        map.put(aTermAppl2, set);
        this.annotations.put(aTermAppl, map);
        if (log.isLoggable(Level.FINER)) {
            log.finer("annotation " + aTermAppl + " " + aTermAppl2 + " " + aTermAppl3);
        }
        return true;
    }

    public Set<ATermAppl> getAnnotations(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Map<ATermAppl, Set<ATermAppl>> map = this.annotations.get(aTermAppl);
        if (map == null) {
            return Collections.emptySet();
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (ATermAppl aTermAppl3 : this.getSubAnnotationProperties(aTermAppl2)) {
            if (map.get(aTermAppl3) == null) continue;
            for (ATermAppl aTermAppl4 : map.get(aTermAppl3)) {
                hashSet.add(aTermAppl4);
            }
        }
        return hashSet;
    }

    private Set<ATermAppl> getSubAnnotationProperties(ATermAppl aTermAppl) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        arrayList.add(aTermAppl);
        while (!arrayList.isEmpty()) {
            ATermAppl aTermAppl2 = (ATermAppl)arrayList.remove(0);
            hashSet.add(aTermAppl2);
            for (ATermAppl aTermAppl3 : this.getAnnotationProperties()) {
                if (aTermAppl2 == aTermAppl3 || !this.isSubPropertyOf(aTermAppl3, aTermAppl2)) continue;
                arrayList.add(aTermAppl3);
            }
        }
        return hashSet;
    }

    public Set<ATermAppl> getIndividualsWithAnnotation(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Map.Entry<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> entry : this.annotations.entrySet()) {
            ATermAppl aTermAppl3 = entry.getKey();
            Map<ATermAppl, Set<ATermAppl>> map = entry.getValue();
            for (Map.Entry<ATermAppl, Set<ATermAppl>> entry2 : map.entrySet()) {
                ATermAppl aTermAppl4 = entry2.getKey();
                Set<ATermAppl> set = entry2.getValue();
                if (!aTermAppl4.equals(aTermAppl) || !set.contains(aTermAppl2)) continue;
                hashSet.add(aTermAppl3);
            }
        }
        return hashSet;
    }

    public boolean isAnnotation(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Set<ATermAppl> set = this.getAnnotations(aTermAppl, aTermAppl2);
        if (set == null) {
            return false;
        }
        return set.contains(aTermAppl3);
    }

    public void addSubProperty(ATerm aTerm, ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addSubRole(aTerm, (ATerm)aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            log.finer("sub-prop " + aTerm + " " + aTermAppl);
        }
    }

    public void addEquivalentProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addEquivalentRole((ATerm)aTermAppl, (ATerm)aTermAppl2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("same-prop " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addDisjointProperties(ATermList aTermList) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperties(aTermList)) : DependencySet.INDEPENDENT;
        ATermList aTermList2 = aTermList;
        while (!aTermList2.isEmpty()) {
            ATermAppl aTermAppl = (ATermAppl)aTermList2.getFirst();
            ATermList aTermList3 = aTermList2.getNext();
            while (!aTermList3.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList3.getFirst();
                this.addDisjointProperty(aTermAppl, aTermAppl2, dependencySet);
                aTermList3 = aTermList3.getNext();
            }
            aTermList2 = aTermList2.getNext();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoints " + aTermList);
        }
    }

    public void addDisjointProperties(List<ATermAppl> list) {
        this.addDisjointProperties(ATermUtils.toSet(list));
    }

    public void addDisjointProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperty((ATerm)aTermAppl, (ATerm)aTermAppl2)) : DependencySet.INDEPENDENT;
        this.addDisjointProperty(aTermAppl, aTermAppl2, dependencySet);
    }

    public void addDisjointProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2, DependencySet dependencySet) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDisjointRole((ATerm)aTermAppl, (ATerm)aTermAppl2, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("dis-prop " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addInverseProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring inverseOf(" + aTermAppl + " " + aTermAppl2 + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInvProp((ATerm)aTermAppl, (ATerm)aTermAppl2)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole((ATerm)aTermAppl, (ATerm)aTermAppl2, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("inv-prop " + aTermAppl + " " + aTermAppl2);
        }
    }

    public void addTransitiveProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole((ATerm)aTermAppl);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        role.addSubRoleChain(ATermUtils.makeList(new ATerm[]{aTermAppl, aTermAppl}), dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("trans-prop " + aTermAppl);
        }
    }

    public void addSymmetricProperty(ATermAppl aTermAppl) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring SymmetricProperty(" + aTermAppl + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSymmetric((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole((ATerm)aTermAppl, (ATerm)aTermAppl, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("sym-prop " + aTermAppl);
        }
    }

    public void addAntisymmetricProperty(ATermAppl aTermAppl) {
        this.addAsymmetricProperty(aTermAppl);
    }

    public void addAsymmetricProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole((ATerm)aTermAppl);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeAsymmetric((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        role.setAsymmetric(true, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("anti-sym-prop " + aTermAppl);
        }
    }

    public void addReflexiveProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole((ATerm)aTermAppl);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeReflexive((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        role.setReflexive(true, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("reflexive-prop " + aTermAppl);
        }
    }

    public void addIrreflexiveProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole((ATerm)aTermAppl);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeIrreflexive((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        role.setIrreflexive(true, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("irreflexive-prop " + aTermAppl);
        }
    }

    public void addFunctionalProperty(ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole((ATerm)aTermAppl);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeFunctional((ATerm)aTermAppl)) : DependencySet.INDEPENDENT;
        role.setFunctional(true, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("func-prop " + aTermAppl);
        }
    }

    public void addInverseFunctionalProperty(ATerm aTerm) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring InverseFunctionalProperty(" + aTerm + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole(aTerm);
        DependencySet dependencySet = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInverseFunctional(aTerm)) : DependencySet.INDEPENDENT;
        role.setInverseFunctional(true, dependencySet);
        if (log.isLoggable(Level.FINER)) {
            log.finer("inv-func-prop " + aTerm);
        }
    }

    public void addDomain(ATerm aTerm, ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDomain(aTerm, aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            log.finer("domain " + aTerm + " " + aTermAppl);
        }
    }

    public void addDomain(ATerm aTerm, ATermAppl aTermAppl, Set<ATermAppl> set) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDomain(aTerm, aTermAppl, set);
        if (log.isLoggable(Level.FINER)) {
            log.finer("domain " + aTerm + " " + aTermAppl + " " + set);
        }
    }

    public void addRange(ATerm aTerm, ATermAppl aTermAppl) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRange(aTerm, aTermAppl);
        if (log.isLoggable(Level.FINER)) {
            log.finer("range " + aTerm + " " + aTermAppl);
        }
    }

    public void addRange(ATerm aTerm, ATermAppl aTermAppl, Set<ATermAppl> set) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRange(aTerm, aTermAppl, set);
        if (log.isLoggable(Level.FINER)) {
            log.finer("range " + aTerm + " " + aTermAppl + " " + set);
        }
    }

    public void addDatatype(ATermAppl aTermAppl) {
        this.getDatatypeReasoner().declare(aTermAppl);
    }

    public boolean addDatatypeDefinition(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return this.getDatatypeReasoner().define(aTermAppl, aTermAppl2);
    }

    public boolean removeDomain(ATerm aTerm, ATermAppl aTermAppl) {
        Role role = this.getRole(aTerm);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTerm + " is not a property!");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a valid class expression");
            return false;
        }
        boolean bl = this.getRBox().removeDomain(aTerm, aTermAppl);
        if (bl) {
            this.changes.add(ChangeType.RBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove domain " + aTerm + " " + aTermAppl);
        }
        return bl;
    }

    public boolean removePropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        Edge edge;
        if (ATermUtils.isLiteral(aTermAppl3)) {
            try {
                aTermAppl3 = this.abox.getDatatypeReasoner().getCanonicalRepresentation(aTermAppl3);
            }
            catch (InvalidLiteralException invalidLiteralException) {
                log.warning(String.format("Unable to remove property value (%s,%s,%s) due to invalid literal: %s", aTermAppl, aTermAppl2, aTermAppl3, invalidLiteralException.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
                log.warning(String.format("Unable to remove property value (%s,%s,%s) due to unrecognized datatype for literal: %s", aTermAppl, aTermAppl2, aTermAppl3, unrecognizedDatatypeException.getMessage()));
                return false;
            }
        }
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl2);
        Node node = this.abox.getNode((ATerm)aTermAppl3);
        Role role = this.getRole((ATerm)aTermAppl);
        if (individual == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                throw new UnsupportedFeatureException(aTermAppl2 + " is not an individual!");
            }
            return false;
        }
        if (node == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl3 + " is not an individual!");
            return false;
        }
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove ObjectPropertyValue " + aTermAppl2 + " " + aTermAppl + " " + aTermAppl3);
        }
        if ((edge = individual.getOutEdges().getExactEdge(individual, role, node)) == null && node.isMerged()) {
            edge = node.getInEdges().getExactEdge(individual, role, node);
        }
        if (edge == null) {
            return false;
        }
        this.changes.add(ChangeType.ABOX_DEL);
        if (!this.canUseIncConsistency()) {
            this.abox.reset();
            individual.removeEdge(edge);
            node.removeInEdge(edge);
        } else {
            this.getDeletedAssertions().add(ATermUtils.makePropAtom(aTermAppl, aTermAppl2, aTermAppl3));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(individual);
            if (!role.isDatatypeRole()) {
                this.abox.getIncrementalChangeTracker().addUpdatedIndividual((Individual)node);
            }
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl aTermAppl4 = ATermUtils.makePropAtom(aTermAppl, aTermAppl2, aTermAppl3);
            if (ATermUtils.isLiteral(aTermAppl3)) {
                this.aboxAssertions.remove(AssertionType.DATA_ROLE, aTermAppl4);
            } else {
                this.aboxAssertions.remove(AssertionType.OBJ_ROLE, aTermAppl4);
            }
        }
        return true;
    }

    public boolean removeRange(ATerm aTerm, ATermAppl aTermAppl) {
        Role role = this.getRole(aTerm);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTerm + " is not a property!");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl) && !this.isDatatype(aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a valid class expression or data range");
            return false;
        }
        boolean bl = this.getRBox().removeRange(aTerm, aTermAppl);
        if (bl) {
            this.changes.add(ChangeType.RBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove range" + aTerm + " " + aTermAppl);
        }
        return bl;
    }

    public boolean removeType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl);
        if (individual == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(aTermAppl + " is not an individual!");
        }
        ATermAppl aTermAppl3 = ATermUtils.normalize(aTermAppl2);
        DependencySet dependencySet = individual.getDepends((ATerm)aTermAppl3);
        if (dependencySet == null || !dependencySet.isIndependent()) {
            return false;
        }
        boolean bl = true;
        if (!this.canUseIncConsistency() || !PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.reset();
            bl = individual.removeType(aTermAppl3);
        } else {
            this.getDeletedAssertions().add(ATermUtils.makeTypeAtom(aTermAppl, aTermAppl2));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(individual);
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl aTermAppl4 = ATermUtils.makeTypeAtom(aTermAppl, aTermAppl2);
            this.aboxAssertions.remove(AssertionType.TYPE, aTermAppl4);
        }
        this.changes.add(ChangeType.ABOX_DEL);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove Type " + aTermAppl + " " + aTermAppl2);
        }
        return bl;
    }

    public boolean removeAxiom(ATermAppl aTermAppl) {
        boolean bl = false;
        try {
            bl = this.tbox.removeAxiom(aTermAppl);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Removal failed for axiom " + aTermAppl, exception);
        }
        if (bl) {
            this.changes.add(ChangeType.TBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove " + aTermAppl + ": " + bl);
        }
        return bl;
    }

    public void prepare() {
        Timer timer;
        boolean bl;
        if (!this.isChanged()) {
            return;
        }
        boolean bl2 = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        Timer timer2 = this.timers.startTimer("preprocessing");
        this.state.remove((Object)ReasoningState.CONSISTENCY);
        this.state.remove((Object)ReasoningState.REALIZE);
        boolean bl3 = bl = this.state.contains((Object)ReasoningState.CLASSIFY) && !this.isTBoxChanged() && !this.isRBoxChanged() && (!this.expChecker.getExpressivity().hasNominal() || PelletOptions.USE_PSEUDO_NOMINALS);
        if (this.isRBoxChanged()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Role hierarchy...");
            }
            timer = this.timers.startTimer("rbox");
            this.rbox.prepare();
            timer.stop();
        }
        if (this.isTBoxChanged()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Prepare TBox...");
            }
            timer = this.timers.startTimer("normalize");
            this.tbox.prepare();
            timer.stop();
        }
        if (this.isRBoxChanged()) {
            this.rbox.propagateDomainRange();
        }
        this.canUseIncConsistency = this.canUseIncConsistency();
        if (this.abox.isComplete()) {
            if (this.changes.contains((Object)ChangeType.TBOX_DEL) || this.changes.contains((Object)ChangeType.RBOX_DEL) || !this.canUseIncConsistency && this.changes.contains((Object)ChangeType.ABOX_DEL)) {
                this.abox.reset();
            } else if (this.changes.contains((Object)ChangeType.TBOX_ADD) || this.changes.contains((Object)ChangeType.RBOX_ADD)) {
                this.abox.resetQueue();
            } else if (this.canUseIncConsistency && this.changes.contains((Object)ChangeType.ABOX_DEL)) {
                IncrementalRestore.restoreDependencies(this);
            }
        }
        this.changes.clear();
        this.instances.clear();
        this.estimate = new SizeEstimate(this);
        this.abox.setDoExplanation(bl2);
        if (!this.canUseIncConsistency) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Expressivity...");
            }
            this.expChecker.prepare();
        }
        this.abox.clearCaches(!bl);
        this.abox.cache.setMaxSize(PelletOptions.MAX_ANONYMOUS_CACHE);
        if (!bl) {
            this.state.remove((Object)ReasoningState.CLASSIFY);
            this.builder = null;
        }
        timer2.stop();
        if (log.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Expressivity: " + this.expChecker.getExpressivity() + ", ");
            stringBuffer.append("Classes: " + this.getClasses().size() + " ");
            stringBuffer.append("Properties: " + this.getProperties().size() + " ");
            stringBuffer.append("Individuals: " + this.individuals.size());
            log.fine(stringBuffer.toString());
        }
    }

    public void updateExpressivity(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (!this.isChanged() || this.isTBoxChanged() || this.isRBoxChanged()) {
            return;
        }
        this.expChecker.updateWithIndividual(aTermAppl, aTermAppl2);
        this.estimate = new SizeEstimate(this);
    }

    public String getInfo() {
        this.prepare();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Expressivity: " + this.expChecker.getExpressivity() + " ");
        stringBuffer.append("Classes: " + this.getClasses().size() + " ");
        stringBuffer.append("Properties: " + this.getProperties().size() + " ");
        stringBuffer.append("Individuals: " + this.individuals.size() + " ");
        Expressivity expressivity = this.expChecker.getExpressivity();
        if (expressivity.hasNominal()) {
            stringBuffer.append("Nominals: " + expressivity.getNominals().size() + " ");
        }
        return stringBuffer.toString();
    }

    public boolean isConsistencyDone() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.CONSISTENCY);
    }

    public boolean isClassified() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.CLASSIFY);
    }

    public boolean isRealized() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.REALIZE);
    }

    public boolean isChanged() {
        return !this.changes.isEmpty();
    }

    public boolean isChanged(ChangeType changeType) {
        return this.changes.contains((Object)changeType);
    }

    public boolean isTBoxChanged() {
        return this.changes.contains((Object)ChangeType.TBOX_ADD) || this.changes.contains((Object)ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this.changes.contains((Object)ChangeType.RBOX_ADD) || this.changes.contains((Object)ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this.changes.contains((Object)ChangeType.ABOX_ADD) || this.changes.contains((Object)ChangeType.ABOX_DEL);
    }

    public Set<ATermAppl> getUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses(false);
    }

    public Set<ATermAppl> getAllUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses(true);
    }

    private Set<ATermAppl> getUnsatisfiableClasses(boolean bl) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        if (this.isClassified()) {
            hashSet = bl ? this.getAllEquivalentClasses(ATermUtils.BOTTOM) : this.getEquivalentClasses(ATermUtils.BOTTOM);
        } else {
            if (bl) {
                hashSet.add(TermFactory.BOTTOM);
            }
            Set<ATermAppl> set = this.getClasses();
            for (ATermAppl aTermAppl : set) {
                if (this.isSatisfiable(aTermAppl)) continue;
                hashSet.add(aTermAppl);
            }
        }
        return hashSet;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        this.abox.setInitialized(false);
        this.prepare();
        for (Map.Entry<Rule, Rule> entry : this.rules.entrySet()) {
            if (entry.getValue() != null) continue;
            Rule rule = entry.getKey();
            String string = UsableRuleFilter.explainNotUsable(rule);
            log.warning("Ignoring rule " + rule + ": " + string);
        }
        Timer timer = this.timers.startTimer("consistency");
        boolean bl = this.abox.doExplanation();
        if (PelletOptions.USE_TRACING && !this.explainOnlyInconsistency) {
            this.abox.setDoExplanation(true);
        }
        boolean bl2 = this.consistent = this.canUseIncConsistency ? this.abox.isIncConsistent() : this.abox.isConsistent();
        if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this.abox.getIncrementalChangeTracker().clear();
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.getDeletedAssertions().clear();
        }
        if (!this.consistent) {
            if (PelletOptions.USE_TRACING && this.explainOnlyInconsistency && !this.abox.doExplanation()) {
                this.abox.setDoExplanation(true);
                this.abox.reset();
                this.abox.isConsistent();
                this.abox.setDoExplanation(false);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Inconsistent ontology. Reason: " + this.getExplanation());
            }
            if (PelletOptions.USE_TRACING && log.isLoggable(Level.FINE)) {
                log.fine(this.renderExplanationSet());
            }
        }
        this.abox.setDoExplanation(bl);
        this.state.add(ReasoningState.CONSISTENCY);
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + this.consistent + " (" + timer.getLast() + "ms)");
        }
        assert (this.isConsistencyDone()) : "Consistency flag not set";
    }

    private String renderExplanationSet() {
        StringBuilder stringBuilder = new StringBuilder("ExplanationSet: [");
        Set<ATermAppl> set = this.getExplanationSet();
        for (ATermAppl aTermAppl : set) {
            stringBuilder.append(ATermUtils.toString(aTermAppl));
            stringBuilder.append(",");
        }
        if (set.isEmpty()) {
            stringBuilder.append(']');
        } else {
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        }
        return stringBuilder.toString();
    }

    public boolean isConsistent() {
        this.consistency();
        return this.consistent;
    }

    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return this.getTaxonomyBuilder().getToldTaxonomy();
    }

    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return this.getTaxonomyBuilder().getToldDisjoints();
    }

    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!\nReason for inconsistency: " + this.getExplanation() + (PelletOptions.USE_TRACING ? "\n" + this.renderExplanationSet() : ""));
        }
    }

    public void classify() {
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classifying...");
        }
        Timer timer = this.timers.startTimer("classify");
        this.builder = this.getTaxonomyBuilder();
        boolean bl = this.builder.classify();
        timer.stop();
        if (!bl) {
            return;
        }
        this.state.add(ReasoningState.CLASSIFY);
        this.estimate.computKBCosts();
    }

    public void realize() {
        if (this.isRealized()) {
            return;
        }
        this.classify();
        if (!this.isClassified()) {
            return;
        }
        Timer timer = this.timers.startTimer("realize");
        boolean bl = this.builder.realize();
        timer.stop();
        if (!bl) {
            return;
        }
        this.state.add(ReasoningState.REALIZE);
        this.estimate.computKBCosts();
    }

    public Set<ATermAppl> getClasses() {
        return Collections.unmodifiableSet(this.tbox.getClasses());
    }

    public Set<ATermAppl> getAllClasses() {
        return Collections.unmodifiableSet(this.tbox.getAllClasses());
    }

    public Set<ATermAppl> getProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isObjectRole() && !role.isDatatypeRole() && !role.isAnnotationRole()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getObjectProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isObjectRole()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getAnnotationProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isAnnotationRole()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getTransitiveProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isTransitive()) continue;
            hashSet.add(aTermAppl);
        }
        hashSet.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return hashSet;
    }

    public Set<ATermAppl> getSymmetricProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isSymmetric()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getAntisymmetricProperties() {
        return this.getAsymmetricProperties();
    }

    public Set<ATermAppl> getAsymmetricProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isAsymmetric()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getReflexiveProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isReflexive()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getIrreflexiveProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isIrreflexive()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getFunctionalProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isFunctional()) continue;
            hashSet.add(aTermAppl);
        }
        hashSet.add(ATermUtils.BOTTOM_DATA_PROPERTY);
        hashSet.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return hashSet;
    }

    public Set<ATermAppl> getInverseFunctionalProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isInverseFunctional()) continue;
            hashSet.add(aTermAppl);
        }
        hashSet.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return hashSet;
    }

    public Set<ATermAppl> getDataProperties() {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl aTermAppl = role.getName();
            if (!ATermUtils.isPrimitive(aTermAppl) || !role.isDatatypeRole()) continue;
            hashSet.add(aTermAppl);
        }
        return hashSet;
    }

    public Set<ATermAppl> getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    public Set<ATermAppl> getAnnotationSubjects() {
        return this.annotations.keySet();
    }

    public Role getProperty(ATerm aTerm) {
        return this.rbox.getRole(aTerm);
    }

    public PropertyType getPropertyType(ATerm aTerm) {
        Role role = this.getProperty(aTerm);
        return role == null ? PropertyType.UNTYPED : role.getType();
    }

    public boolean isClass(ATerm aTerm) {
        if (this.tbox.getClasses().contains(aTerm) || aTerm.equals((Object)ATermUtils.TOP)) {
            return true;
        }
        if (ATermUtils.isComplexClass(aTerm)) {
            return this.fullyDefinedVisitor.isFullyDefined((ATermAppl)aTerm);
        }
        return false;
    }

    public boolean isProperty(ATerm aTerm) {
        return this.rbox.isRole(aTerm);
    }

    public boolean isDatatypeProperty(ATerm aTerm) {
        return this.getPropertyType(aTerm) == PropertyType.DATATYPE;
    }

    public boolean isObjectProperty(ATerm aTerm) {
        return this.getPropertyType(aTerm) == PropertyType.OBJECT;
    }

    public boolean isABoxProperty(ATerm aTerm) {
        PropertyType propertyType = this.getPropertyType(aTerm);
        return propertyType == PropertyType.OBJECT || propertyType == PropertyType.DATATYPE;
    }

    public boolean isAnnotationProperty(ATerm aTerm) {
        return this.getPropertyType(aTerm) == PropertyType.ANNOTATION;
    }

    @Deprecated
    public boolean isOntologyProperty(ATerm aTerm) {
        return false;
    }

    public boolean isIndividual(ATerm aTerm) {
        return this.getIndividuals().contains(aTerm);
    }

    public boolean isTransitiveProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role.isTransitive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainTransitive());
            }
            return true;
        }
        if (!role.isObjectRole() || role.isFunctional() || role.isInverseFunctional()) {
            return false;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl2 = ATermUtils.makeTermAppl("_C_");
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        ATermAppl aTermAppl4 = ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl2)), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl3));
        return !this.abox.isSatisfiable(aTermAppl4);
    }

    public boolean isSymmetricProperty(ATermAppl aTermAppl) {
        return this.isInverse(aTermAppl, aTermAppl);
    }

    public boolean isFunctionalProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role.isAnnotationRole()) {
            return false;
        }
        if (role.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role.isFunctional()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainFunctional());
            }
            return true;
        }
        if (!role.isSimple()) {
            return false;
        }
        ATermAppl aTermAppl2 = role.isDatatypeRole() ? ATermUtils.makeMin((ATerm)aTermAppl, 2, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)aTermAppl, 2, (ATerm)ATermUtils.TOP);
        return !this.isSatisfiable(aTermAppl2);
    }

    public boolean isInverseFunctionalProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isInverseFunctional() || role.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainInverseFunctional());
            }
            return true;
        }
        ATermAppl aTermAppl2 = role.getInverse().getName();
        ATermAppl aTermAppl3 = ATermUtils.makeMax((ATerm)aTermAppl2, 1, (ATerm)ATermUtils.TOP);
        return this.isSubClassOf(ATermUtils.TOP, aTermAppl3);
    }

    public boolean isReflexiveProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isIrreflexive()) {
            return false;
        }
        if (role.isReflexive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainReflexive());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl2 = ATermUtils.makeTermAppl("_C_");
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        ATermAppl aTermAppl4 = ATermUtils.makeAnd((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl3));
        return !this.abox.isSatisfiable(aTermAppl4);
    }

    public boolean isIrreflexiveProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isReflexive()) {
            return false;
        }
        if (role.isIrreflexive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainIrreflexive());
            }
            return true;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl2 = ATermUtils.makeSelf(aTermAppl);
        return !this.abox.isSatisfiable(aTermAppl2);
    }

    public boolean isAntisymmetricProperty(ATermAppl aTermAppl) {
        return this.isAsymmetricProperty(aTermAppl);
    }

    public boolean isAsymmetricProperty(ATermAppl aTermAppl) {
        Role role = this.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl2 = ATermUtils.makeAnonNominal(Integer.MAX_VALUE);
        ATermAppl aTermAppl3 = ATermUtils.makeValue((ATerm)aTermAppl2);
        ATermAppl aTermAppl4 = ATermUtils.makeAnd((ATerm)aTermAppl3, (ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)ATermUtils.makeAnd((ATerm)ATermUtils.makeNot((ATerm)aTermAppl3), (ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl3))));
        return !this.abox.isSatisfiable(aTermAppl4);
    }

    public boolean isSubPropertyOf(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3;
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        Role role2 = this.rbox.getRole((ATerm)aTermAppl2);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known property");
            return false;
        }
        if (role.isSubRoleOf(role2)) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainSuper((ATerm)aTermAppl2));
            }
            return true;
        }
        if (role.getType() != role2.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (role.isObjectRole()) {
            ATermAppl aTermAppl4 = ATermUtils.makeTermAppl("_C_");
            ATermAppl aTermAppl5 = ATermUtils.makeNot((ATerm)aTermAppl4);
            aTermAppl3 = ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl4), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)aTermAppl5));
        } else if (role.isDatatypeRole()) {
            ATermAppl aTermAppl6 = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            aTermAppl3 = ATermUtils.makeAnd((ATerm)ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl6), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)aTermAppl6))));
        } else {
            if (role.isAnnotationRole()) {
                return false;
            }
            throw new IllegalArgumentException();
        }
        return !this.abox.isSatisfiable(aTermAppl3);
    }

    public boolean isEquivalentProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3;
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        Role role2 = this.rbox.getRole((ATerm)aTermAppl2);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known property");
            return false;
        }
        if (role.isSubRoleOf(role2) && role2.isSubRoleOf(role)) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainSuper((ATerm)aTermAppl2).union(role.getExplainSub((ATerm)aTermAppl2), this.doExplanation()));
            }
            return true;
        }
        if (role.isAnnotationRole() || role2.isAnnotationRole()) {
            return false;
        }
        if (role.getType() != role2.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (role.isObjectRole()) {
            ATermAppl aTermAppl4 = !role.getRanges().isEmpty() ? role.getRanges().iterator().next() : (!role2.getRanges().isEmpty() ? role2.getRanges().iterator().next() : ATermUtils.makeTermAppl("_C_"));
            ATermAppl aTermAppl5 = ATermUtils.makeNot((ATerm)aTermAppl4);
            aTermAppl3 = ATermUtils.makeOr(ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)aTermAppl4), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)aTermAppl5)), ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)aTermAppl4), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl5)));
        } else if (role.isDatatypeRole()) {
            ATermAppl aTermAppl6 = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            aTermAppl3 = ATermUtils.makeOr(ATermUtils.makeAnd((ATerm)ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl6), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)aTermAppl6)))), ATermUtils.makeAnd((ATerm)ATermUtils.makeHasValue((ATerm)aTermAppl2, (ATerm)aTermAppl6), (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)aTermAppl6)))));
        } else {
            throw new IllegalArgumentException();
        }
        return !this.abox.isSatisfiable(aTermAppl3);
    }

    public boolean isInverse(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Role role = this.getRole((ATerm)aTermAppl);
        Role role2 = this.getRole((ATerm)aTermAppl2);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || !role2.isObjectRole()) {
            return false;
        }
        if (role.getInverse().equals(role2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl3 = ATermUtils.makeTermAppl("_C_");
        ATermAppl aTermAppl4 = ATermUtils.makeNot((ATerm)aTermAppl3);
        ATermAppl aTermAppl5 = ATermUtils.makeAnd((ATerm)aTermAppl3, (ATerm)ATermUtils.makeOr(ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl2, (ATerm)aTermAppl4)), ATermUtils.makeSomeValues((ATerm)aTermAppl2, (ATerm)ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl4))));
        return !this.abox.isSatisfiable(aTermAppl5);
    }

    public boolean hasDomain(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a valid class expression");
            return false;
        }
        ATermAppl aTermAppl3 = ATermUtils.makeSomeValues((ATerm)aTermAppl, (ATerm)ATermUtils.getTop(role));
        return this.isSubClassOf(aTermAppl3, aTermAppl2);
    }

    public boolean hasRange(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (!this.isClass((ATerm)aTermAppl2) && !this.isDatatype(aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a valid class expression");
            return false;
        }
        ATermAppl aTermAppl3 = ATermUtils.makeAllValues((ATerm)aTermAppl, (ATerm)aTermAppl2);
        return this.isSubClassOf(ATermUtils.TOP, aTermAppl3);
    }

    public boolean isDatatype(ATermAppl aTermAppl) {
        return this.datatypeVisitor.isDatatype(aTermAppl);
    }

    public boolean isSatisfiable(ATermAppl aTermAppl) {
        Bool bool;
        this.ensureConsistency();
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known class!");
            return false;
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        if (this.isClassified() && !this.doExplanation() && (bool = this.builder.getTaxonomy().isEquivalent(ATermUtils.BOTTOM, aTermAppl)).isKnown()) {
            return bool.isFalse();
        }
        return this.abox.isSatisfiable(aTermAppl);
    }

    public boolean hasInstance(ATerm aTerm) {
        if (!this.isClass(aTerm)) {
            KnowledgeBase.handleUndefinedEntity(aTerm + " is not a class!");
            return false;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl = ATermUtils.normalize((ATermAppl)aTerm);
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        IndividualIterator individualIterator = new IndividualIterator(this.abox);
        while (individualIterator.hasNext()) {
            ATermAppl aTermAppl2 = ((Individual)individualIterator.next()).getName();
            Bool bool = this.abox.isKnownType(aTermAppl2, aTermAppl);
            if (bool.isTrue()) {
                return true;
            }
            if (!bool.isUnknown()) continue;
            arrayList.add(aTermAppl2);
        }
        boolean bl = !arrayList.isEmpty() && this.abox.isType(arrayList, aTermAppl);
        return bl;
    }

    public boolean isSubClassOf(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Bool bool;
        this.ensureConsistency();
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known class");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known class");
            return false;
        }
        if (aTermAppl.equals(aTermAppl2)) {
            return true;
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        if (this.isClassified() && !this.doExplanation() && (bool = this.builder.getTaxonomy().isSubNodeOf(aTermAppl, aTermAppl2)).isKnown()) {
            return bool.isTrue();
        }
        return this.abox.isSubClassOf(aTermAppl, aTermAppl2);
    }

    public boolean isEquivalentClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3;
        Bool bool;
        this.ensureConsistency();
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known class");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known class");
            return false;
        }
        if (aTermAppl.equals(aTermAppl2)) {
            return true;
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        if (!this.doExplanation()) {
            bool = Bool.UNKNOWN;
            if (this.isClassified()) {
                bool = this.builder.getTaxonomy().isEquivalent(aTermAppl, aTermAppl2);
            }
            if (bool.isUnknown()) {
                bool = this.abox.isKnownSubClassOf(aTermAppl, aTermAppl2).and(this.abox.isKnownSubClassOf(aTermAppl2, aTermAppl));
            }
            if (bool.isKnown()) {
                return bool.isTrue();
            }
        }
        bool = ATermUtils.negate(aTermAppl2);
        ATermAppl aTermAppl4 = ATermUtils.negate(aTermAppl);
        ATermAppl aTermAppl5 = ATermUtils.makeAnd((ATerm)aTermAppl, (ATerm)bool);
        ATermAppl aTermAppl6 = ATermUtils.makeOr(aTermAppl5, aTermAppl3 = ATermUtils.makeAnd((ATerm)aTermAppl2, (ATerm)aTermAppl4));
        return !this.isSatisfiable(aTermAppl6);
    }

    public boolean isDisjoint(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (this.isClass((ATerm)aTermAppl) && this.isClass((ATerm)aTermAppl2)) {
            return this.isDisjointClass(aTermAppl, aTermAppl2);
        }
        if (this.isProperty((ATerm)aTermAppl) && this.isProperty((ATerm)aTermAppl2)) {
            return this.isDisjointProperty(aTermAppl, aTermAppl2);
        }
        return false;
    }

    public boolean isDisjointClass(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        return this.isSubClassOf(aTermAppl, aTermAppl3);
    }

    public boolean isDisjointProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3;
        ATermAppl aTermAppl4;
        Role role = this.getRole((ATerm)aTermAppl);
        Role role2 = this.getRole((ATerm)aTermAppl2);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known property");
            return false;
        }
        if (role.getType() != role2.getType()) {
            return false;
        }
        if (role.isBottom() || role2.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role.isTop() || role2.isTop()) {
            return false;
        }
        if (role.getSubRoles().contains(role2) || role2.getSubRoles().contains(role)) {
            return false;
        }
        if (role.getDisjointRoles().contains(role2) && !this.doExplanation()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl aTermAppl5 = ATermUtils.makeAnonNominal(Integer.MAX_VALUE);
        if (role.isDatatypeRole()) {
            aTermAppl5 = ATermUtils.makeLiteral(aTermAppl5);
        }
        return !this.abox.isSatisfiable(aTermAppl4 = TermFactory.and(TermFactory.some(aTermAppl, aTermAppl3 = ATermUtils.makeValue((ATerm)aTermAppl5)), TermFactory.some(aTermAppl2, aTermAppl3)));
    }

    public boolean isComplement(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)aTermAppl2);
        return this.isEquivalentClass(aTermAppl, aTermAppl3);
    }

    public Bool isKnownType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return Bool.FALSE;
        }
        if (!this.isClass((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a valid class expression");
            return Bool.FALSE;
        }
        aTermAppl2 = ATermUtils.normalize(aTermAppl2);
        return this.abox.isKnownType(aTermAppl, aTermAppl2);
    }

    public boolean isType(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return false;
        }
        if (!this.isClass((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a valid class expression");
            return false;
        }
        if (this.isRealized() && !this.doExplanation()) {
            if (this.builder == null) {
                throw new NullPointerException("Builder is null");
            }
            Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
            if (taxonomy == null) {
                throw new NullPointerException("Taxonomy is null");
            }
            if (taxonomy.contains(aTermAppl2)) {
                return TaxonomyUtils.isType(taxonomy, aTermAppl, aTermAppl2);
            }
        }
        return this.abox.isType(aTermAppl, aTermAppl2);
    }

    public boolean isSameAs(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return false;
        }
        if (!this.isIndividual((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not an individual!");
            return false;
        }
        if (aTermAppl.equals(aTermAppl2)) {
            return true;
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl);
        if (individual.isMerged() && !individual.getMergeDependency(true).isIndependent()) {
            this.abox.getSames(individual.getSame(), hashSet2, hashSet2);
        } else {
            this.abox.getSames(individual.getSame(), hashSet, hashSet2);
        }
        if (hashSet.contains(aTermAppl2)) {
            if (!this.doExplanation()) {
                return true;
            }
        } else if (!hashSet2.contains(aTermAppl2)) {
            return false;
        }
        return this.abox.isSameAs(aTermAppl, aTermAppl2);
    }

    public boolean isDifferentFrom(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl);
        Individual individual2 = this.abox.getIndividual((ATerm)aTermAppl2);
        if (individual == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return false;
        }
        if (individual2 == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not an individual!");
            return false;
        }
        if (individual.isDifferent(individual2) && !this.doExplanation()) {
            return true;
        }
        ATermAppl aTermAppl3 = ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)aTermAppl2));
        return this.isType(aTermAppl, aTermAppl3);
    }

    public Set<ATermAppl> getDifferents(ATermAppl aTermAppl) {
        this.ensureConsistency();
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl);
        if (individual == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return Collections.emptySet();
        }
        boolean bl = true;
        if (individual.isMerged()) {
            bl = individual.getMergeDependency(true).isIndependent();
            individual = individual.getSame();
        }
        ATermAppl aTermAppl2 = ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)aTermAppl));
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (ATermAppl aTermAppl3 : this.individuals) {
            Bool bool = this.abox.isKnownType(aTermAppl3, aTermAppl2);
            if (bl && bool.isKnown()) {
                if (!bool.isTrue()) continue;
                hashSet.add(aTermAppl3);
                continue;
            }
            if (!this.isType(aTermAppl3, aTermAppl2)) continue;
            hashSet.add(aTermAppl3);
        }
        return hashSet;
    }

    public boolean hasPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return false;
        }
        if (!this.isProperty((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known property!");
            return false;
        }
        if (aTermAppl3 != null && (this.isDatatypeProperty((ATerm)aTermAppl2) ? !ATermUtils.isLiteral(aTermAppl3) : !this.isIndividual((ATerm)aTermAppl3))) {
            return false;
        }
        return this.abox.hasPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
    }

    public Bool hasKnownPropertyValue(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        this.ensureConsistency();
        return this.abox.hasObviousPropertyValue(aTermAppl, aTermAppl2, aTermAppl3);
    }

    public ABox getABox() {
        return this.abox;
    }

    public RBox getRBox() {
        return this.rbox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.abox.getDatatypeReasoner();
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl aTermAppl, boolean bl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(aTermAppl)) {
            this.builder.classify(aTermAppl);
        }
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> set : taxonomy.getSupers(aTermAppl, bl)) {
            Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
            if (set2.isEmpty()) continue;
            hashSet.add(set2);
        }
        return hashSet;
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl aTermAppl) {
        return this.getSubClasses(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getDisjoints(ATermAppl aTermAppl) {
        if (this.isClass((ATerm)aTermAppl)) {
            return this.getDisjointClasses(aTermAppl);
        }
        if (this.isProperty((ATerm)aTermAppl)) {
            return this.getDisjointProperties(aTermAppl);
        }
        KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property nor a class!");
        return Collections.emptySet();
    }

    public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl aTermAppl) {
        return this.getDisjointClasses(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl aTermAppl, boolean bl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl aTermAppl2 = ATermUtils.normalize(ATermUtils.makeNot((ATerm)aTermAppl));
        Set<ATermAppl> set = this.getAllEquivalentClasses(aTermAppl2);
        if (aTermAppl2.equals(ATermUtils.BOTTOM)) {
            set.add(ATermUtils.BOTTOM);
        }
        if (bl && !set.isEmpty()) {
            return Collections.singleton(set);
        }
        Set<Set<ATermAppl>> set2 = this.getSubClasses(aTermAppl2, bl);
        if (!set.isEmpty()) {
            set2.add(set);
        }
        return set2;
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl aTermAppl) {
        return this.getDisjointProperties(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl aTermAppl, boolean bl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        TaxonomyNode taxonomyNode = this.getRoleTaxonomy(role.isObjectRole()).getTop();
        HashSet<TaxonomyNode<ATermAppl>> hashSet2 = new HashSet<TaxonomyNode<ATermAppl>>();
        ArrayList arrayList = new ArrayList();
        arrayList.add(taxonomyNode);
        for (int i = 0; i < arrayList.size(); ++i) {
            taxonomyNode = (TaxonomyNode)arrayList.get(i);
            if (taxonomyNode.isHidden() || taxonomyNode.getEquivalents().isEmpty() || hashSet2.contains(taxonomyNode)) continue;
            ATermAppl aTermAppl2 = (ATermAppl)taxonomyNode.getName();
            if (this.isDisjointProperty(aTermAppl, aTermAppl2)) {
                Set<ATermAppl> set = this.getAllEquivalentProperties(aTermAppl2);
                if (!set.isEmpty()) {
                    hashSet.add(set);
                }
                if (bl) {
                    this.mark(taxonomyNode, hashSet2);
                    continue;
                }
                hashSet.addAll(this.getSubProperties(aTermAppl2));
                continue;
            }
            arrayList.addAll(taxonomyNode.getSubs());
        }
        return hashSet;
    }

    private void mark(TaxonomyNode<ATermAppl> taxonomyNode, Set<TaxonomyNode<ATermAppl>> set) {
        set.add(taxonomyNode);
        for (TaxonomyNode<ATermAppl> taxonomyNode2 : taxonomyNode.getSubs()) {
            this.mark(taxonomyNode2, set);
        }
    }

    public Set<ATermAppl> getComplements(ATermAppl aTermAppl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl aTermAppl2 = ATermUtils.normalize(ATermUtils.makeNot((ATerm)aTermAppl));
        Set<ATermAppl> set = this.getAllEquivalentClasses(aTermAppl2);
        if (aTermAppl2.equals(ATermUtils.BOTTOM)) {
            set.add(ATermUtils.BOTTOM);
        }
        return set;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl aTermAppl, boolean bl) {
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return Collections.emptySet();
        }
        this.realize();
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> set : TaxonomyUtils.getTypes(this.builder.getTaxonomy(), aTermAppl, bl)) {
            Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
            if (set2.isEmpty()) continue;
            hashSet.add(set2);
        }
        return hashSet;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl aTermAppl) {
        return this.getTypes(aTermAppl, false);
    }

    public ATermAppl getType(ATermAppl aTermAppl) {
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return null;
        }
        return this.abox.getIndividual((ATerm)aTermAppl).getTypes(0).iterator().next();
    }

    public ATermAppl getType(ATermAppl aTermAppl, boolean bl) {
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return null;
        }
        this.realize();
        for (Set<ATermAppl> set : TaxonomyUtils.getTypes(this.builder.getTaxonomy(), aTermAppl, bl)) {
            Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
            if (set2.isEmpty()) continue;
            return set2.iterator().next();
        }
        return null;
    }

    public Set<ATermAppl> getInstances(ATermAppl aTermAppl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        if (this.instances.containsKey(aTermAppl)) {
            return this.instances.get(aTermAppl);
        }
        if (this.isRealized()) {
            if (this.builder == null) {
                throw new NullPointerException("Builder is null");
            }
            Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
            if (taxonomy == null) {
                throw new NullPointerException("Taxonomy is null");
            }
            if (taxonomy.contains(aTermAppl) && ATermUtils.isPrimitive(aTermAppl)) {
                return TaxonomyUtils.getAllInstances(taxonomy, aTermAppl);
            }
        }
        return new HashSet<ATermAppl>(this.retrieve(aTermAppl, this.individuals));
    }

    public Set<ATermAppl> getInstances(ATermAppl aTermAppl, boolean bl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        if (!bl) {
            return this.getInstances(aTermAppl);
        }
        this.realize();
        if (this.builder == null) {
            throw new NullPointerException("Builder is null");
        }
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (taxonomy == null) {
            throw new NullPointerException("Taxonomy is null");
        }
        if (ATermUtils.isPrimitive(aTermAppl)) {
            return TaxonomyUtils.getDirectInstances(taxonomy, aTermAppl);
        }
        if (!taxonomy.contains(aTermAppl)) {
            this.builder.classify(aTermAppl);
        }
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        Set<Set<ATermAppl>> set = this.getSuperClasses(aTermAppl, true);
        for (Set<ATermAppl> set2 : set) {
            Iterator<ATermAppl> iterator = set2.iterator();
            ATermAppl aTermAppl2 = iterator.next();
            Set set3 = TaxonomyUtils.getDirectInstances(taxonomy, aTermAppl2);
            if (hashSet.isEmpty()) {
                hashSet.addAll(set3);
            } else {
                hashSet.retainAll(set3);
            }
            if (!hashSet.isEmpty()) continue;
            return hashSet;
        }
        return this.retrieve(aTermAppl, hashSet);
    }

    public Set<ATermAppl> getEquivalentClasses(ATermAppl aTermAppl) {
        Set<ATermAppl> set = this.getAllEquivalentClasses(aTermAppl);
        set.remove(aTermAppl);
        return set;
    }

    public Set<ATermAppl> getAllEquivalentClasses(ATermAppl aTermAppl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(aTermAppl)) {
            this.builder.classify(aTermAppl);
        }
        return ATermUtils.primitiveOrBottom(taxonomy.getAllEquivalents(aTermAppl));
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl aTermAppl) {
        return this.getSuperClasses(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl aTermAppl, boolean bl) {
        if (!this.isClass((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a class!");
            return Collections.emptySet();
        }
        aTermAppl = ATermUtils.normalize(aTermAppl);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(aTermAppl)) {
            this.builder.classify(aTermAppl);
        }
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> set : taxonomy.getSubs(aTermAppl, bl)) {
            Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
            if (set2.isEmpty()) continue;
            hashSet.add(set2);
        }
        return hashSet;
    }

    public Set<Set<ATermAppl>> getAllSuperProperties(ATermAppl aTermAppl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> set = this.getSuperProperties(aTermAppl);
        set.add(this.getAllEquivalentProperties(aTermAppl));
        return set;
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl aTermAppl) {
        return this.getSuperProperties(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl aTermAppl, boolean bl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(aTermAppl);
        if (taxonomy != null) {
            for (Set<ATermAppl> set : taxonomy.getSupers(aTermAppl, bl)) {
                Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
                if (set2.isEmpty()) continue;
                hashSet.add(set2);
            }
        }
        return hashSet;
    }

    public Set<Set<ATermAppl>> getAllSubProperties(ATermAppl aTermAppl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> set = this.getSubProperties(aTermAppl);
        set.add(this.getAllEquivalentProperties(aTermAppl));
        return set;
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl aTermAppl) {
        return this.getSubProperties(aTermAppl, false);
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl aTermAppl, boolean bl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> hashSet = new HashSet<Set<ATermAppl>>();
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(aTermAppl);
        if (taxonomy != null) {
            for (Set<ATermAppl> set : taxonomy.getSubs(aTermAppl, bl)) {
                Set<ATermAppl> set2 = ATermUtils.primitiveOrBottom(set);
                if (set2.isEmpty()) continue;
                hashSet.add(set2);
            }
        } else {
            System.out.print("");
        }
        return hashSet;
    }

    public Set<ATermAppl> getEquivalentProperties(ATermAppl aTermAppl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(aTermAppl);
        return taxonomy != null ? ATermUtils.primitiveOrBottom(taxonomy.getEquivalents(aTermAppl)) : Collections.emptySet();
    }

    public Set<ATermAppl> getAllEquivalentProperties(ATermAppl aTermAppl) {
        if (!this.isProperty((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        Taxonomy<ATermAppl> taxonomy = this.getRoleTaxonomy(aTermAppl);
        return taxonomy != null ? ATermUtils.primitiveOrBottom(taxonomy.getAllEquivalents(aTermAppl)) : Collections.emptySet();
    }

    public Set<ATermAppl> getInverses(ATerm aTerm) {
        ATermAppl aTermAppl = this.getInverse(aTerm);
        if (aTermAppl != null) {
            Set<ATermAppl> set = this.getAllEquivalentProperties(aTermAppl);
            return set;
        }
        return Collections.emptySet();
    }

    public ATermAppl getInverse(ATerm aTerm) {
        Role role = this.rbox.getRole(aTerm);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTerm + " is not a property!");
            return null;
        }
        Role role2 = role.getInverse();
        return role2 != null ? role2.getName() : null;
    }

    public Set<ATermAppl> getDomains(ATermAppl aTermAppl) {
        this.ensureConsistency();
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a property!");
            return Collections.emptySet();
        }
        return ATermUtils.primitiveOrBottom(role.getDomains());
    }

    public Set<ATermAppl> getRanges(ATerm aTerm) {
        this.ensureConsistency();
        Set<ATermAppl> set = Collections.emptySet();
        Role role = this.rbox.getRole(aTerm);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTerm + " is not a property!");
            return set;
        }
        return ATermUtils.primitiveOrBottom(role.getRanges());
    }

    public Set<ATermAppl> getAllSames(ATermAppl aTermAppl) {
        this.ensureConsistency();
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl);
        if (individual == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return Collections.emptySet();
        }
        if (individual.isMerged() && !individual.getMergeDependency(true).isIndependent()) {
            hashSet.add(aTermAppl);
            this.abox.getSames(individual.getSame(), hashSet2, hashSet2);
            hashSet2.remove(aTermAppl);
        } else {
            this.abox.getSames(individual.getSame(), hashSet, hashSet2);
        }
        for (ATermAppl aTermAppl2 : hashSet2) {
            if (!this.abox.isSameAs(aTermAppl, aTermAppl2)) continue;
            hashSet.add(aTermAppl2);
        }
        return hashSet;
    }

    public Set<ATermAppl> getSames(ATermAppl aTermAppl) {
        Set<ATermAppl> set = this.getAllSames(aTermAppl);
        set.remove(aTermAppl);
        return set;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3) {
        this.ensureConsistency();
        Individual individual = this.abox.getIndividual((ATerm)aTermAppl2);
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (individual == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not an individual!");
            return Collections.emptyList();
        }
        if (role == null || !role.isDatatypeRole()) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known data property!");
            return Collections.emptyList();
        }
        if (role.isTop()) {
            ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
            if (!PelletOptions.HIDE_TOP_PROPERTY_VALUES) {
                for (Node node : this.abox.getNodes()) {
                    if (!node.isLiteral() || node.getTerm() == null) continue;
                    arrayList.add(node.getTerm());
                }
            }
            return arrayList;
        }
        if (role.isBottom()) {
            return Collections.emptyList();
        }
        return this.abox.getDataPropertyValues(aTermAppl2, role, aTermAppl3);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl aTermAppl, ATermAppl aTermAppl2, String string) {
        List<ATermAppl> list = this.getDataPropertyValues(aTermAppl, aTermAppl2);
        if (string == null) {
            return list;
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl3 : list) {
            String string2 = ((ATermAppl)aTermAppl3.getArgument(1)).getName();
            if (!string2.equals(string)) continue;
            arrayList.add(aTermAppl3);
        }
        return arrayList;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        return this.getDataPropertyValues(aTermAppl, aTermAppl2, (ATermAppl)null);
    }

    public List<ATermAppl> getObjectPropertyValues(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.ensureConsistency();
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null || !role.isObjectRole()) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known object property!");
            return Collections.emptyList();
        }
        if (!this.isIndividual((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not a known individual!");
            return Collections.emptyList();
        }
        HashSet<ATermAppl> hashSet = new HashSet();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        if (role.isTop()) {
            if (!PelletOptions.HIDE_TOP_PROPERTY_VALUES) {
                hashSet = this.getIndividuals();
            }
        } else if (!role.isBottom()) {
            this.abox.getObjectPropertyValues(aTermAppl2, role, hashSet, hashSet2, true);
        }
        if (!hashSet2.isEmpty()) {
            ATermAppl aTermAppl3 = ATermUtils.makeHasValue((ATerm)role.getInverse().getName(), (ATerm)aTermAppl2);
            ATermAppl aTermAppl4 = ATermUtils.normalize(aTermAppl3);
            this.binaryInstanceRetrieval(aTermAppl4, new ArrayList<ATermAppl>(hashSet2), hashSet);
        }
        return new ArrayList<ATermAppl>(hashSet);
    }

    public List<ATermAppl> getPropertyValues(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null || role.isUntypedRole()) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(aTermAppl, aTermAppl2);
        }
        if (role.isDatatypeRole()) {
            return this.getDataPropertyValues(aTermAppl, aTermAppl2);
        }
        if (role.isAnnotationRole()) {
            Set<ATermAppl> set = this.getAnnotations(aTermAppl2, aTermAppl);
            return set.isEmpty() ? Collections.emptyList() : Arrays.asList(set.toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    public List<ATermAppl> getIndividualsWithProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getIndividualsWithObjectProperty(aTermAppl, aTermAppl2);
        }
        if (role.isDatatypeRole()) {
            return this.getIndividualsWithDataProperty(aTermAppl, aTermAppl2);
        }
        if (role.isAnnotationRole()) {
            return Arrays.asList(this.getIndividualsWithAnnotation(aTermAppl, aTermAppl2).toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    public List<ATermAppl> getIndividualsWithDataProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        ATermAppl aTermAppl3;
        if (!ATermUtils.isLiteral(aTermAppl2)) {
            return Collections.emptyList();
        }
        this.ensureConsistency();
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> arrayList2 = new ArrayList<ATermAppl>();
        try {
            aTermAppl3 = this.getDatatypeReasoner().getCanonicalRepresentation(aTermAppl2);
        }
        catch (InvalidLiteralException invalidLiteralException) {
            log.warning(String.format("Invalid literal '%s' passed as input, returning empty set of individuals: %s", aTermAppl2, invalidLiteralException.getMessage()));
            return Collections.emptyList();
        }
        catch (UnrecognizedDatatypeException unrecognizedDatatypeException) {
            log.warning(String.format("Unrecognized datatype for literal '%s' passed as input, returning empty set of individuals: %s", aTermAppl2, unrecognizedDatatypeException.getMessage()));
            return Collections.emptyList();
        }
        Literal literal = this.abox.getLiteral((ATerm)aTermAppl3);
        if (literal != null) {
            Role role = this.getRole((ATerm)aTermAppl);
            EdgeList edgeList = literal.getInEdges();
            for (Edge edge : edgeList) {
                if (!edge.getRole().isSubRoleOf(role)) continue;
                ATermAppl aTermAppl4 = edge.getFrom().getName();
                if (edge.getDepends().isIndependent()) {
                    arrayList.add(aTermAppl4);
                    continue;
                }
                arrayList2.add(aTermAppl4);
            }
            if (!arrayList2.isEmpty()) {
                ATermAppl aTermAppl5 = ATermUtils.normalize(ATermUtils.makeHasValue((ATerm)aTermAppl, (ATerm)aTermAppl2));
                this.binaryInstanceRetrieval(aTermAppl5, arrayList2, arrayList);
            }
        }
        return arrayList;
    }

    public List<ATermAppl> getIndividualsWithObjectProperty(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not an individual!");
            return Collections.emptyList();
        }
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        ATermAppl aTermAppl3 = role.getInverse().getName();
        return this.getObjectPropertyValues(aTermAppl3, aTermAppl2);
    }

    public List<ATermAppl> getProperties(ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        if (!this.isIndividual((ATerm)aTermAppl)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not an individual!");
            return Collections.emptyList();
        }
        if (!this.isIndividual((ATerm)aTermAppl2) && !ATermUtils.isLiteral(aTermAppl2)) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl2 + " is not an individual!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        Set<ATermAppl> set = ATermUtils.isLiteral(aTermAppl2) ? this.getDataProperties() : this.getObjectProperties();
        for (ATermAppl aTermAppl3 : set) {
            if (!this.abox.hasPropertyValue(aTermAppl, aTermAppl3, aTermAppl2)) continue;
            arrayList.add(aTermAppl3);
        }
        return arrayList;
    }

    public Map<ATermAppl, List<ATermAppl>> getPropertyValues(ATermAppl aTermAppl) {
        HashMap<ATermAppl, List<ATermAppl>> hashMap = new HashMap<ATermAppl, List<ATermAppl>>();
        for (ATermAppl aTermAppl2 : this.individuals) {
            List<ATermAppl> list = this.getPropertyValues(aTermAppl, aTermAppl2);
            if (list.isEmpty()) continue;
            hashMap.put(aTermAppl2, list);
        }
        return hashMap;
    }

    public Set<ATermAppl> retrieve(ATermAppl aTermAppl, Collection<ATermAppl> collection) {
        Set<ATermAppl> set;
        this.ensureConsistency();
        ATermAppl aTermAppl2 = ATermUtils.normalize(aTermAppl);
        Timer timer = this.timers.startTimer("retrieve");
        ATermAppl aTermAppl3 = ATermUtils.negate(aTermAppl2);
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        if (!this.abox.isSatisfiable(aTermAppl3)) {
            arrayList.addAll(this.getIndividuals());
        } else if (this.abox.isSatisfiable(aTermAppl2)) {
            Taxonomy<ATermAppl> taxonomy;
            set = Collections.emptySet();
            if (this.isClassified()) {
                if (this.builder == null) {
                    throw new NullPointerException("Builder is null");
                }
                taxonomy = this.builder.getTaxonomy();
                if (taxonomy == null) {
                    throw new NullPointerException("Taxonomy");
                }
                if (taxonomy.contains(aTermAppl2)) {
                    set = taxonomy.getFlattenedSubs(aTermAppl2, false);
                }
            }
            taxonomy = new ArrayList();
            for (ATermAppl aTermAppl4 : collection) {
                Bool bool = this.abox.isKnownType(aTermAppl4, aTermAppl2, set);
                if (bool.isTrue()) {
                    arrayList.add(aTermAppl4);
                    continue;
                }
                if (!bool.isUnknown()) continue;
                taxonomy.add(aTermAppl4);
            }
            if (!taxonomy.isEmpty()) {
                if (PelletOptions.INSTANCE_RETRIEVAL == PelletOptions.InstanceRetrievalMethod.TRACING_BASED && PelletOptions.USE_TRACING) {
                    this.tracingBasedInstanceRetrieval(aTermAppl2, (List<ATermAppl>)((Object)taxonomy), arrayList);
                } else if (this.abox.isType((List<ATermAppl>)((Object)taxonomy), aTermAppl2)) {
                    if (PelletOptions.INSTANCE_RETRIEVAL == PelletOptions.InstanceRetrievalMethod.BINARY) {
                        this.binaryInstanceRetrieval(aTermAppl2, (List<ATermAppl>)((Object)taxonomy), arrayList);
                    } else {
                        this.linearInstanceRetrieval(aTermAppl2, (List<ATermAppl>)((Object)taxonomy), arrayList);
                    }
                }
            }
        }
        timer.stop();
        set = Collections.unmodifiableSet(new HashSet(arrayList));
        if (PelletOptions.CACHE_RETRIEVAL) {
            this.instances.put(aTermAppl2, set);
        }
        return set;
    }

    public List<ATermAppl> retrieveIndividualsWithProperty(ATermAppl aTermAppl) {
        this.ensureConsistency();
        Role role = this.rbox.getRole((ATerm)aTermAppl);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(aTermAppl + " is not a known property!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
        for (ATermAppl aTermAppl2 : this.individuals) {
            if (this.abox.hasObviousPropertyValue(aTermAppl2, aTermAppl, null).isFalse()) continue;
            arrayList.add(aTermAppl2);
        }
        return arrayList;
    }

    public void tracingBasedInstanceRetrieval(ATermAppl aTermAppl, List<ATermAppl> list, Collection<ATermAppl> collection) {
        boolean bl = this.doExplanation();
        this.setDoExplanation(true);
        ATermAppl aTermAppl2 = ATermUtils.negate(aTermAppl);
        block0: while (this.abox.isType(list, aTermAppl)) {
            Set<ATermAppl> set = this.getExplanationSet();
            for (ATermAppl aTermAppl3 : set) {
                ATermAppl aTermAppl4;
                int n;
                if (!aTermAppl3.getAFun().equals(ATermUtils.TYPEFUN) || !aTermAppl3.getArgument(1).equals((Object)aTermAppl2) || (n = list.indexOf(aTermAppl4 = (ATermAppl)aTermAppl3.getArgument(0))) < 0) continue;
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filter instance " + aTermAppl3 + " while retrieving " + aTermAppl);
                }
                Collections.swap(list, n, 0);
                collection.add(aTermAppl4);
                list = list.subList(1, list.size());
                continue block0;
            }
        }
        this.setDoExplanation(bl);
    }

    public void linearInstanceRetrieval(ATermAppl aTermAppl, List<ATermAppl> list, Collection<ATermAppl> collection) {
        for (ATermAppl aTermAppl2 : list) {
            if (!this.abox.isType(aTermAppl2, aTermAppl)) continue;
            collection.add(aTermAppl2);
        }
    }

    public void binaryInstanceRetrieval(ATermAppl aTermAppl, List<ATermAppl> list, Collection<ATermAppl> collection) {
        if (list.isEmpty()) {
            return;
        }
        List<ATermAppl>[] listArray = this.partition(list);
        this.partitionInstanceRetrieval(aTermAppl, listArray, collection);
    }

    private void partitionInstanceRetrieval(ATermAppl aTermAppl, List<ATermAppl>[] listArray, Collection<ATermAppl> collection) {
        if (listArray[0].size() == 1) {
            ATermAppl aTermAppl2 = listArray[0].get(0);
            this.binaryInstanceRetrieval(aTermAppl, listArray[1], collection);
            if (this.abox.isType(aTermAppl2, aTermAppl)) {
                collection.add(aTermAppl2);
            }
        } else if (!this.abox.isType(listArray[0], aTermAppl)) {
            this.binaryInstanceRetrieval(aTermAppl, listArray[1], collection);
        } else if (!this.abox.isType(listArray[1], aTermAppl)) {
            this.binaryInstanceRetrieval(aTermAppl, listArray[0], collection);
        } else {
            this.binaryInstanceRetrieval(aTermAppl, listArray[0], collection);
            this.binaryInstanceRetrieval(aTermAppl, listArray[1], collection);
        }
    }

    private List<ATermAppl>[] partition(List<ATermAppl> list) {
        List[] listArray = new List[2];
        int n = list.size();
        if (n <= 1) {
            listArray[0] = list;
            listArray[1] = new ArrayList();
        } else {
            listArray[0] = list.subList(0, n / 2);
            listArray[1] = list.subList(n / 2, n);
        }
        return listArray;
    }

    public void printClassTree() {
        this.classify();
        new ClassTreePrinter().print(this.builder.getTaxonomy());
    }

    public void printClassTree(PrintWriter printWriter) {
        this.classify();
        new ClassTreePrinter().print(this.builder.getTaxonomy(), printWriter);
    }

    public boolean doExplanation() {
        return this.abox.doExplanation();
    }

    public void setDoExplanation(boolean bl) {
        this.abox.setDoExplanation(bl);
    }

    public String getExplanation() {
        return this.abox.getExplanation();
    }

    public void setDoDependencyAxioms(boolean bl) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Setting DoDependencyAxioms = " + bl);
        }
    }

    public boolean getDoDependencyAxioms() {
        return false;
    }

    public Set<ATermAppl> getExplanationSet() {
        return this.abox.getExplanationSet();
    }

    public void setRBox(RBox rBox) {
        this.rbox = rBox;
    }

    public void setTBox(TBox tBox) {
        this.tbox = tBox;
    }

    CompletionStrategy chooseStrategy(ABox aBox) {
        return this.chooseStrategy(aBox, this.getExpressivity());
    }

    CompletionStrategy chooseStrategy(ABox aBox, Expressivity expressivity) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = aBox.size() == 1 && new IndividualIterator(aBox).next().isConceptRoot();
        if (this.getRules().size() > 0 && (expressivity.hasNominal() || !bl2)) {
            if (PelletOptions.USE_CONTINUOUS_RULES) {
                return new ContinuousRulesStrategy(aBox);
            }
            return new RuleStrategy(aBox);
        }
        boolean bl4 = bl = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        if (!bl && bl2 && !expressivity.hasNominal()) {
            return new EmptySRIQStrategy(aBox);
        }
        return new SROIQStrategy(aBox);
    }

    public void setTimeout(long l) {
        this.timers.mainTimer.setTimeout(l);
    }

    public Role getRole(ATerm aTerm) {
        return this.rbox.getRole(aTerm);
    }

    public Taxonomy<ATermAppl> getTaxonomy() {
        this.classify();
        return this.builder.getTaxonomy();
    }

    public TaxonomyBuilder getTaxonomyBuilder() {
        if (this.builder == null) {
            this.prepare();
            this.builder = this.expChecker.getExpressivity().isEL() && !PelletOptions.DISABLE_EL_CLASSIFIER ? new SimplifiedELClassifier() : new CDOptimizedTaxonomyBuilder();
            this.builder.setKB(this);
            if (this.builderProgressMonitor != null) {
                this.builder.setProgressMonitor(this.builderProgressMonitor);
            }
        }
        return this.builder;
    }

    public void setTaxonomyBuilderProgressMonitor(ProgressMonitor progressMonitor) {
        this.builderProgressMonitor = progressMonitor;
        if (this.builder != null) {
            this.builder.setProgressMonitor(progressMonitor);
        }
    }

    public Taxonomy<ATermAppl> getRoleTaxonomy(boolean bl) {
        this.prepare();
        return bl ? this.rbox.getObjectTaxonomy() : this.rbox.getDataTaxonomy();
    }

    public Taxonomy<ATermAppl> getRoleTaxonomy(ATermAppl aTermAppl) {
        this.prepare();
        if (this.isObjectProperty((ATerm)aTermAppl)) {
            return this.rbox.getObjectTaxonomy();
        }
        if (this.isDatatypeProperty((ATerm)aTermAppl)) {
            return this.rbox.getDataTaxonomy();
        }
        if (this.isAnnotationProperty((ATerm)aTermAppl)) {
            return this.rbox.getAnnotationTaxonomy();
        }
        return null;
    }

    public SizeEstimate getSizeEstimate() {
        return this.estimate;
    }

    public boolean addRule(Rule rule) {
        this.changes.add(ChangeType.ABOX_ADD);
        this.rules.put(rule, this.normalize(rule));
        if (log.isLoggable(Level.FINER)) {
            log.finer("rule " + rule);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Rule normalize(Rule rule) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!UsableRuleFilter.isUsable(rule)) {
            return null;
        }
        LinkedHashSet<void> linkedHashSet = new LinkedHashSet<void>();
        LinkedHashSet<void> linkedHashSet2 = new LinkedHashSet<void>();
        for (RuleAtom ruleAtom : rule.getHead()) {
            void object5;
            if (ruleAtom instanceof ClassAtom) {
                ClassAtom classAtom = (ClassAtom)ruleAtom;
                object4 = (AtomIObject)classAtom.getArgument();
                object3 = (ATermAppl)classAtom.getPredicate();
                if (object3 != (object2 = ATermUtils.normalize(object3))) {
                    ClassAtom classAtom2 = new ClassAtom((ATermAppl)object2, (AtomIObject)object4);
                }
            }
            linkedHashSet.add(object5);
        }
        HashMap hashMap = new HashMap();
        for (RuleAtom ruleAtom : rule.getBody()) {
            Set<ATermAppl> set;
            if (!(ruleAtom instanceof IndividualPropertyAtom)) continue;
            object4 = (IndividualPropertyAtom)ruleAtom;
            object3 = (ATermAppl)((RuleAtomImpl)object4).getPredicate();
            object2 = (AtomIObject)((BinaryAtom)object4).getArgument1();
            if (object2 instanceof AtomIVariable && (object = this.getRole((ATerm)object3).getDomains()) != null) {
                MultiMapUtils.addAll(hashMap, object2, object);
            }
            if (!((object = (AtomIObject)((BinaryAtom)object4).getArgument2()) instanceof AtomIVariable) || (set = this.getRole((ATerm)object3).getRanges()) == null) continue;
            MultiMapUtils.addAll(hashMap, object, set);
        }
        for (RuleAtom ruleAtom : rule.getBody()) {
            void var6_16;
            if (ruleAtom instanceof ClassAtom) {
                object4 = (ClassAtom)ruleAtom;
                object3 = (AtomIObject)((UnaryAtom)object4).getArgument();
                if (MultiMapUtils.contains(hashMap, object3, object = ATermUtils.normalize(object2 = (ATermAppl)((RuleAtomImpl)object4).getPredicate()))) continue;
                if (object2 != object) {
                    ClassAtom classAtom = new ClassAtom((ATermAppl)object, (AtomIObject)((UnaryAtom)object4).getArgument());
                }
            }
            linkedHashSet2.add(var6_16);
        }
        return new Rule(rule.getName(), linkedHashSet, linkedHashSet2);
    }

    public Set<Rule> getRules() {
        return this.rules.keySet();
    }

    public Map<Rule, Rule> getNormalizedRules() {
        return this.rules;
    }

    protected boolean canUseIncConsistency() {
        Expressivity expressivity = this.expChecker.getExpressivity();
        if (expressivity == null) {
            return false;
        }
        boolean bl = !(expressivity.hasNominal() && expressivity.hasInverse() || !this.getRules().isEmpty() || this.isTBoxChanged() || this.isRBoxChanged() || !this.abox.isComplete() || !PelletOptions.USE_INCREMENTAL_CONSISTENCY || this.changes.contains((Object)ChangeType.ABOX_DEL) && !PelletOptions.USE_INCREMENTAL_DELETION);
        return bl;
    }

    public void ensureIncConsistency(boolean bl) {
        if (this.canUseIncConsistency()) {
            return;
        }
        Expressivity expressivity = this.expChecker.getExpressivity();
        String string = "ABox " + (bl ? "deletion" : "addition") + " failed because ";
        string = expressivity == null ? string + "an initial consistency check has not been performed on this KB" : (expressivity.hasNominal() ? string + "KB has nominals" : (expressivity.hasInverse() ? string + "KB has inverse properties" : (this.isTBoxChanged() ? string + "TBox changed" : (this.isRBoxChanged() ? string + "RBox changed" : (PelletOptions.USE_INCREMENTAL_CONSISTENCY ? string + "configuration option USE_INCREMENTAL_CONSISTENCY is not enabled" : (bl ? string + "configuration option USE_INCREMENTAL_DELETION is not enabled" : string + "of an unknown reason"))))));
        throw new UnsupportedOperationException(string);
    }

    public DependencyIndex getDependencyIndex() {
        return this.dependencyIndex;
    }

    public Set<ATermAppl> getSyntacticAssertions() {
        return this.syntacticAssertions;
    }

    protected static void handleUndefinedEntity(String string) {
        if (!PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
            throw new UndefinedEntityException(string);
        }
    }

    public Set<ATermAppl> getABoxAssertions(AssertionType assertionType) {
        Set set = (Set)this.aboxAssertions.get((Object)assertionType);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public Set<ATermAppl> getAboxMembershipAssertions() {
        return this.getABoxAssertions(AssertionType.TYPE);
    }

    public Set<ATermAppl> getAboxObjectRoleAssertions() {
        return this.getABoxAssertions(AssertionType.OBJ_ROLE);
    }

    public Set<ATermAppl> getAboxDataRoleAssertions() {
        return this.getABoxAssertions(AssertionType.DATA_ROLE);
    }

    public Set<ATermAppl> getDeletedAssertions() {
        return this.deletedAssertions;
    }

    public boolean isExplainOnlyInconsistency() {
        return this.explainOnlyInconsistency;
    }

    public void setExplainOnlyInconsistency(boolean bl) {
        this.explainOnlyInconsistency = bl;
    }

    class FullyDefinedClassVisitor
    extends ATermBaseVisitor {
        private boolean fullyDefined = true;

        FullyDefinedClassVisitor() {
        }

        public boolean isFullyDefined(ATermAppl aTermAppl) {
            this.fullyDefined = true;
            this.visit(aTermAppl);
            return this.fullyDefined;
        }

        private void visitQCR(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2;
            this.visitRestr(aTermAppl);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(2))) {
                this.visit(aTermAppl2);
            }
        }

        private void visitQR(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2;
            this.visitRestr(aTermAppl);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1))) {
                this.visit(aTermAppl2);
            }
        }

        private void visitRestr(ATermAppl aTermAppl) {
            this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isProperty(aTermAppl.getArgument(0));
        }

        @Override
        public void visit(ATermAppl aTermAppl) {
            if (aTermAppl.equals(ATermUtils.TOP) || aTermAppl.equals(ATermUtils.BOTTOM) || aTermAppl.equals(ATermUtils.TOP_LIT) || aTermAppl.equals(ATermUtils.BOTTOM_LIT)) {
                return;
            }
            super.visit(aTermAppl);
        }

        @Override
        public void visitAll(ATermAppl aTermAppl) {
            this.visitQR(aTermAppl);
        }

        @Override
        public void visitAnd(ATermAppl aTermAppl) {
            if (this.fullyDefined) {
                this.visitList((ATermList)aTermAppl.getArgument(0));
            }
        }

        @Override
        public void visitCard(ATermAppl aTermAppl) {
            this.visitQCR(aTermAppl);
        }

        @Override
        public void visitHasValue(ATermAppl aTermAppl) {
            this.visitQR(aTermAppl);
        }

        @Override
        public void visitLiteral(ATermAppl aTermAppl) {
        }

        @Override
        public void visitMax(ATermAppl aTermAppl) {
            this.visitQCR(aTermAppl);
        }

        @Override
        public void visitMin(ATermAppl aTermAppl) {
            this.visitQCR(aTermAppl);
        }

        @Override
        public void visitNot(ATermAppl aTermAppl) {
            this.visit((ATermAppl)aTermAppl.getArgument(0));
        }

        @Override
        public void visitOneOf(ATermAppl aTermAppl) {
            if (this.fullyDefined) {
                this.visitList((ATermList)aTermAppl.getArgument(0));
            }
        }

        @Override
        public void visitOr(ATermAppl aTermAppl) {
            if (this.fullyDefined) {
                this.visitList((ATermList)aTermAppl.getArgument(0));
            }
        }

        @Override
        public void visitSelf(ATermAppl aTermAppl) {
            this.visitRestr(aTermAppl);
        }

        @Override
        public void visitSome(ATermAppl aTermAppl) {
            this.visitQR(aTermAppl);
        }

        @Override
        public void visitTerm(ATermAppl aTermAppl) {
            boolean bl = this.fullyDefined = this.fullyDefined && KnowledgeBase.this.tbox.getClasses().contains(aTermAppl);
            if (!this.fullyDefined) {
                return;
            }
        }

        @Override
        public void visitValue(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (ATermUtils.isLiteral(aTermAppl2)) {
                this.fullyDefined = false;
            } else if (!ATermUtils.isLiteral(aTermAppl2)) {
                this.fullyDefined = this.fullyDefined && KnowledgeBase.this.individuals.contains(aTermAppl2);
            }
        }

        @Override
        public void visitInverse(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (ATermUtils.isPrimitive(aTermAppl2)) {
                this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isProperty((ATerm)aTermAppl2);
            } else {
                this.visitInverse(aTermAppl2);
            }
        }

        @Override
        public void visitRestrictedDatatype(ATermAppl aTermAppl) {
            this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isDatatype((ATermAppl)aTermAppl.getArgument(0));
        }
    }

    class DatatypeVisitor
    extends ATermBaseVisitor {
        private boolean isDatatype = false;

        DatatypeVisitor() {
        }

        public boolean isDatatype(ATermAppl aTermAppl) {
            this.isDatatype = false;
            this.visit(aTermAppl);
            return this.isDatatype;
        }

        @Override
        public void visit(ATermAppl aTermAppl) {
            super.visit(aTermAppl);
        }

        @Override
        public void visitOr(ATermAppl aTermAppl) {
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitValue(ATermAppl aTermAppl) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (ATermUtils.isLiteral(aTermAppl2)) {
                this.isDatatype = true;
            }
        }

        @Override
        public void visitTerm(ATermAppl aTermAppl) {
            if (KnowledgeBase.this.getDatatypeReasoner().isDeclared(aTermAppl)) {
                this.isDatatype = true;
            }
        }

        @Override
        public void visitNot(ATermAppl aTermAppl) {
            this.visit((ATermAppl)aTermAppl.getArgument(0));
        }

        @Override
        public void visitAll(ATermAppl aTermAppl) {
        }

        @Override
        public void visitAnd(ATermAppl aTermAppl) {
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitCard(ATermAppl aTermAppl) {
        }

        @Override
        public void visitHasValue(ATermAppl aTermAppl) {
        }

        @Override
        public void visitLiteral(ATermAppl aTermAppl) {
        }

        @Override
        public void visitMax(ATermAppl aTermAppl) {
        }

        @Override
        public void visitMin(ATermAppl aTermAppl) {
        }

        @Override
        public void visitOneOf(ATermAppl aTermAppl) {
            this.visitList((ATermList)aTermAppl.getArgument(0));
        }

        @Override
        public void visitSelf(ATermAppl aTermAppl) {
        }

        @Override
        public void visitSome(ATermAppl aTermAppl) {
        }

        @Override
        public void visitInverse(ATermAppl aTermAppl) {
        }

        @Override
        public void visitRestrictedDatatype(ATermAppl aTermAppl) {
            this.isDatatype((ATermAppl)aTermAppl.getArgument(0));
        }
    }

    public static enum ChangeType {
        ABOX_ADD,
        ABOX_DEL,
        TBOX_ADD,
        TBOX_DEL,
        RBOX_ADD,
        RBOX_DEL;

    }

    public static enum AssertionType {
        TYPE,
        OBJ_ROLE,
        DATA_ROLE;

    }

    protected static enum ReasoningState {
        CONSISTENCY,
        CLASSIFY,
        REALIZE;

    }
}

