/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.BindingIterator;
import com.clarkparsia.pellet.sparqldl.engine.CoreStrategy;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryExec;
import com.clarkparsia.pellet.sparqldl.engine.QueryOptimizer;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.model.CoreNewImpl;
import com.clarkparsia.pellet.sparqldl.model.NotKnownQueryAtom;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import com.clarkparsia.pellet.sparqldl.model.UnionQueryAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.CandidateSet;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.Timer;

public class CombinedQueryEngine
implements QueryExec {
    public static final Logger log = Logger.getLogger(CombinedQueryEngine.class.getName());
    public static final QueryOptimizer optimizer = new QueryOptimizer();
    private KnowledgeBase kb;
    protected QueryPlan plan;
    protected Query oldQuery;
    protected Query query;
    private QueryResult result;
    private Set<ATermAppl> downMonotonic;
    private long branches;
    private boolean STOP_ROLLING_ON_CONSTANTS = false;

    private void prepare(Query query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing plan ...");
        }
        this.kb = query.getKB();
        if (this.kb == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        this.result = new QueryResultImpl(query);
        this.oldQuery = query;
        this.query = this.setupCores(query);
        if (log.isLoggable(Level.FINE)) {
            log.fine("After setting-up cores : " + this.query);
        }
        this.plan = optimizer.getExecutionPlan(this.query);
        this.plan.reset();
        if (PelletOptions.USE_CACHING && !this.kb.isClassified()) {
            for (QueryAtom queryAtom : this.oldQuery.getAtoms()) {
                for (ATermAppl aTermAppl : queryAtom.getArguments()) {
                    if (!this.kb.isClass((ATerm)aTermAppl)) continue;
                    this.kb.isSatisfiable(aTermAppl);
                    this.kb.isSatisfiable(ATermUtils.makeNot((ATerm)aTermAppl));
                }
            }
        }
        if (PelletOptions.OPTIMIZE_DOWN_MONOTONIC) {
            this.downMonotonic = new HashSet<ATermAppl>();
            this.setupDownMonotonicVariables(this.query);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Variables to be optimized : " + this.downMonotonic);
            }
        }
    }

    private Query setupCores(Query query) {
        ATermAppl aTermAppl;
        Object object;
        Iterator<ATermAppl> iterator = query.getUndistVars().iterator();
        if (!iterator.hasNext()) {
            return query;
        }
        DisjointSet<Object> disjointSet = new DisjointSet<Object>();
        ArrayList<QueryAtom> arrayList = new ArrayList<QueryAtom>();
        while (iterator.hasNext()) {
            object = iterator.next();
            disjointSet.add(object);
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, new ATermAppl[]{object, null, null})) {
                disjointSet.add(queryAtom);
                disjointSet.union(object, queryAtom);
                aTermAppl = queryAtom.getArguments().get(2);
                if (query.getUndistVars().contains(aTermAppl)) {
                    disjointSet.add(aTermAppl);
                    disjointSet.union(object, aTermAppl);
                }
                arrayList.add(queryAtom);
            }
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, new ATermAppl[]{null, null, object})) {
                disjointSet.add(queryAtom);
                disjointSet.union(object, queryAtom);
                aTermAppl = queryAtom.getArguments().get(0);
                if (query.getUndistVars().contains(aTermAppl)) {
                    disjointSet.add(aTermAppl);
                    disjointSet.union(object, aTermAppl);
                }
                arrayList.add(queryAtom);
            }
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.Type, new ATermAppl[]{object, null})) {
                disjointSet.add(queryAtom);
                disjointSet.union(object, queryAtom);
                arrayList.add(queryAtom);
            }
        }
        object = query.apply(new ResultBindingImpl());
        for (Set set : disjointSet.getEquivalanceSets()) {
            aTermAppl = new ArrayList();
            for (Object t : set) {
                if (!(t instanceof QueryAtom)) continue;
                aTermAppl.add((QueryAtom)((QueryAtom)t));
            }
            CoreNewImpl coreNewImpl = (CoreNewImpl)QueryAtomFactory.Core(aTermAppl, query.getUndistVars(), this.kb);
            object.add(coreNewImpl);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(coreNewImpl.getUndistVars() + " : " + coreNewImpl.getDistVars() + " : " + coreNewImpl.getQuery().getAtoms());
        }
        for (QueryAtom queryAtom : arrayList) {
            object.remove(queryAtom);
        }
        return object;
    }

    private void setupDownMonotonicVariables(Query query) {
        block3: for (QueryAtom queryAtom : query.getAtoms()) {
            ATermAppl aTermAppl;
            switch (queryAtom.getPredicate()) {
                case PropertyValue: 
                case Type: {
                    aTermAppl = queryAtom.getArguments().get(1);
                    if (!ATermUtils.isVar(aTermAppl)) continue block3;
                    this.downMonotonic.add(aTermAppl);
                    continue block3;
                }
            }
            aTermAppl = null;
        }
    }

    @Override
    public boolean supports(Query query) {
        return true;
    }

    @Override
    public QueryResult exec(Query query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing query " + query);
        }
        Timer timer = new Timer("CombinedQueryEngine");
        timer.start();
        this.prepare(query);
        this.branches = 0L;
        this.exec(new ResultBindingImpl());
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "#B=" + this.branches + ", time=" + timer.getLast() + " ms.");
        }
        return this.result;
    }

    private void exec(ResultBinding resultBinding) {
        if (log.isLoggable(Level.FINE)) {
            ++this.branches;
        }
        if (!this.plan.hasNext()) {
            if (!resultBinding.isEmpty() || this.result.isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found binding: " + resultBinding);
                }
                if (!this.result.getResultVars().containsAll(resultBinding.getAllVariables())) {
                    ResultBindingImpl resultBindingImpl = new ResultBindingImpl();
                    for (ATermAppl aTermAppl : this.result.getResultVars()) {
                        ATermAppl aTermAppl2 = resultBinding.getValue(aTermAppl);
                        resultBindingImpl.setValue(aTermAppl, aTermAppl2);
                    }
                    resultBinding = resultBindingImpl;
                }
                this.result.add(resultBinding);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Returning ... binding=" + resultBinding);
            }
            return;
        }
        QueryAtom queryAtom = this.plan.next(resultBinding);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Evaluating " + queryAtom);
        }
        if (queryAtom.isGround() && !queryAtom.getPredicate().equals((Object)QueryPredicate.UndistVarCore)) {
            if (QueryEngine.checkGround(queryAtom, this.kb)) {
                this.exec(resultBinding);
            }
        } else {
            this.exec(queryAtom, resultBinding);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Returning ... " + resultBinding);
        }
        this.plan.back();
    }

    private void exec(QueryAtom queryAtom, ResultBinding resultBinding) {
        List<ATermAppl> list = queryAtom.getArguments();
        boolean bl = false;
        boolean bl2 = false;
        block0 : switch (queryAtom.getPredicate()) {
            case DirectType: {
                bl = true;
            }
            case Type: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl2 = list.get(1);
                Set<ATermAppl> set = null;
                if (aTermAppl.equals(aTermAppl2)) {
                    set = this.kb.getIndividuals().size() < this.kb.getClasses().size() ? this.kb.getIndividuals() : this.kb.getClasses();
                    for (ATermAppl aTermAppl3 : set) {
                        if (!(bl ? this.kb.getInstances(aTermAppl3, bl).contains(aTermAppl3) : this.kb.isType(aTermAppl3, aTermAppl3))) continue;
                        ResultBinding resultBinding2 = resultBinding.duplicate();
                        if (ATermUtils.isVar(aTermAppl)) {
                            resultBinding2.setValue(aTermAppl, aTermAppl3);
                        }
                        this.exec(resultBinding2);
                    }
                } else {
                    Set<ATermAppl> set2;
                    if (!ATermUtils.isVar(aTermAppl2)) {
                        set2 = Collections.singleton(aTermAppl2);
                        set = this.kb.getInstances(aTermAppl2, bl);
                    } else if (!ATermUtils.isVar(aTermAppl)) {
                        set2 = this.flatten(this.kb.getTypes(aTermAppl, bl));
                        set = Collections.singleton(aTermAppl);
                    } else {
                        set2 = this.kb.getAllClasses();
                    }
                    boolean bl3 = set == null;
                    for (ATermAppl aTermAppl4 : set2) {
                        if (bl3) {
                            set = this.kb.getInstances(aTermAppl4, bl);
                        }
                        for (ATermAppl aTermAppl5 : set) {
                            this.runNext(resultBinding, list, aTermAppl5, aTermAppl4);
                        }
                    }
                }
                break;
            }
            case PropertyValue: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl6 = list.get(1);
                ATermAppl aTermAppl7 = list.get(2);
                Set<ATermAppl> set = null;
                Collection<ATermAppl> collection = null;
                Collection<ATermAppl> collection2 = null;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                if (!ATermUtils.isVar(aTermAppl6)) {
                    set = Collections.singleton(aTermAppl6);
                    if (!ATermUtils.isVar(aTermAppl)) {
                        collection = Collections.singleton(aTermAppl);
                        collection2 = this.kb.getPropertyValues(aTermAppl6, aTermAppl);
                    } else if (!ATermUtils.isVar(aTermAppl7)) {
                        collection2 = Collections.singleton(aTermAppl7);
                        collection = this.kb.getIndividualsWithProperty(aTermAppl6, aTermAppl7);
                    }
                    bl4 = false;
                } else {
                    if (!ATermUtils.isVar(aTermAppl)) {
                        collection = Collections.singleton(aTermAppl);
                    }
                    if (!ATermUtils.isVar(aTermAppl7)) {
                        collection2 = Collections.singleton(aTermAppl7);
                    } else if (!this.plan.getQuery().getDistVarsForType(Query.VarType.LITERAL).contains(aTermAppl7)) {
                        set = this.kb.getObjectProperties();
                    }
                    if (set == null) {
                        set = this.kb.getProperties();
                    }
                    bl4 = true;
                }
                bl5 = collection == null;
                bl6 = collection2 == null;
                for (ATermAppl aTermAppl8 : set) {
                    if (bl6 && bl5) {
                        if (aTermAppl.equals(aTermAppl7)) {
                            if (aTermAppl.equals(aTermAppl6)) {
                                if (!this.kb.hasPropertyValue(aTermAppl8, aTermAppl8, aTermAppl8)) continue;
                                this.runNext(resultBinding, list, aTermAppl8, aTermAppl8, aTermAppl8);
                                continue;
                            }
                            for (ATermAppl aTermAppl9 : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(aTermAppl9, aTermAppl8, aTermAppl9)) continue;
                                this.runNext(resultBinding, list, aTermAppl9, aTermAppl8, aTermAppl9);
                            }
                            continue;
                        }
                        if (aTermAppl.equals(aTermAppl6)) {
                            for (ATermAppl aTermAppl9 : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(aTermAppl8, aTermAppl8, aTermAppl9)) continue;
                                this.runNext(resultBinding, list, aTermAppl8, aTermAppl8, aTermAppl9);
                            }
                            continue;
                        }
                        if (aTermAppl7.equals(aTermAppl6)) {
                            for (ATermAppl aTermAppl9 : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(aTermAppl9, aTermAppl8, aTermAppl8)) continue;
                                this.runNext(resultBinding, list, aTermAppl9, aTermAppl8, aTermAppl8);
                            }
                            continue;
                        }
                        for (ATermAppl aTermAppl9 : this.kb.getIndividuals()) {
                            for (ATermAppl aTermAppl10 : this.kb.getPropertyValues(aTermAppl8, aTermAppl9)) {
                                this.runNext(resultBinding, list, aTermAppl9, aTermAppl8, aTermAppl10);
                            }
                        }
                        continue;
                    }
                    if (bl6) {
                        if (aTermAppl6.equals(aTermAppl7) && !this.kb.hasPropertyValue(collection.iterator().next(), aTermAppl8, aTermAppl8)) {
                            collection = Collections.emptySet();
                        }
                        for (ATermAppl aTermAppl9 : collection) {
                            for (ATermAppl aTermAppl10 : this.kb.getPropertyValues(aTermAppl8, aTermAppl9)) {
                                this.runNext(resultBinding, list, aTermAppl9, aTermAppl8, aTermAppl10);
                            }
                        }
                        continue;
                    }
                    for (ATermAppl aTermAppl9 : collection2) {
                        if (bl5) {
                            collection = aTermAppl.equals(aTermAppl6) ? (this.kb.hasPropertyValue(aTermAppl8, aTermAppl8, aTermAppl9) ? Collections.singleton(aTermAppl8) : Collections.emptySet()) : new HashSet<ATermAppl>(this.kb.getIndividualsWithProperty(aTermAppl8, aTermAppl9));
                        }
                        for (ATermAppl aTermAppl10 : collection) {
                            if (bl4 && !this.kb.hasPropertyValue(aTermAppl10, aTermAppl8, aTermAppl9)) continue;
                            this.runNext(resultBinding, list, aTermAppl10, aTermAppl8, aTermAppl9);
                        }
                    }
                }
                break;
            }
            case SameAs: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl11 = list.get(1);
                for (ATermAppl aTermAppl12 : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, aTermAppl, aTermAppl11)) {
                    Set<ATermAppl> set = aTermAppl.equals(aTermAppl11) ? Collections.singleton(aTermAppl12) : this.kb.getAllSames(aTermAppl12);
                    for (ATermAppl aTermAppl13 : set) {
                        this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl12, aTermAppl11, aTermAppl13, resultBinding);
                    }
                }
                break;
            }
            case DifferentFrom: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl14 = list.get(1);
                if (!aTermAppl.equals(aTermAppl14)) {
                    for (ATermAppl aTermAppl15 : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, aTermAppl, aTermAppl14)) {
                        for (ATermAppl aTermAppl16 : this.kb.getDifferents(aTermAppl15)) {
                            this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl15, aTermAppl14, aTermAppl16, resultBinding);
                        }
                    }
                    break;
                }
                if (!log.isLoggable(Level.FINER)) break;
                log.finer("Atom " + queryAtom + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case Annotation: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl17 = list.get(1);
                ATermAppl aTermAppl18 = list.get(2);
                Set<ATermAppl> set = null;
                Object var14_26 = null;
                Set<ATermAppl> set3 = null;
                set = ATermUtils.isVar(aTermAppl) ? this.kb.getAnnotationSubjects() : Collections.singleton(aTermAppl);
                set3 = ATermUtils.isVar(aTermAppl17) ? this.kb.getAnnotationProperties() : Collections.singleton(aTermAppl17);
                if (ATermUtils.isVar(aTermAppl18)) {
                    for (ATermAppl aTermAppl19 : set) {
                        for (ATermAppl aTermAppl20 : set3) {
                            for (ATermAppl aTermAppl21 : this.kb.getAnnotations(aTermAppl19, aTermAppl20)) {
                                this.runNext(resultBinding, list, aTermAppl19, aTermAppl20, aTermAppl21);
                            }
                        }
                    }
                } else {
                    for (ATermAppl aTermAppl22 : set) {
                        for (ATermAppl aTermAppl23 : set3) {
                            if (!this.kb.isAnnotation(aTermAppl22, aTermAppl23, aTermAppl18)) continue;
                            this.runNext(resultBinding, list, aTermAppl22, aTermAppl23, aTermAppl18);
                        }
                    }
                }
                break;
            }
            case DirectSubClassOf: {
                bl = true;
            }
            case StrictSubClassOf: {
                bl2 = true;
            }
            case SubClassOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl24 = list.get(1);
                if (aTermAppl.equals(aTermAppl24)) {
                    for (ATermAppl aTermAppl25 : this.kb.getClasses()) {
                        this.runNext(resultBinding, list, aTermAppl25, aTermAppl25);
                    }
                } else {
                    Set<ATermAppl> set;
                    boolean bl7 = this.isDownMonotonic(aTermAppl);
                    boolean bl8 = this.isDownMonotonic(aTermAppl24);
                    if (bl7 || bl8) {
                        this.downMonotonic(this.kb.getTaxonomy(), this.kb.getClasses(), bl7, aTermAppl, aTermAppl24, resultBinding, bl, bl2);
                        break;
                    }
                    Set<ATermAppl> set4 = null;
                    if (!ATermUtils.isVar(aTermAppl)) {
                        set = Collections.singleton(aTermAppl);
                        set4 = this.flatten(this.kb.getSuperClasses(aTermAppl, bl));
                        set4.addAll(this.kb.getEquivalentClasses(aTermAppl));
                        if (bl2) {
                            set4.removeAll(this.kb.getEquivalentClasses(aTermAppl));
                        } else if (!ATermUtils.isComplexClass((ATerm)aTermAppl)) {
                            set4.add(aTermAppl);
                        }
                    } else if (!ATermUtils.isVar(aTermAppl24)) {
                        set4 = Collections.singleton(aTermAppl24);
                        if (aTermAppl24.equals(ATermUtils.TOP)) {
                            set = new HashSet<ATermAppl>(this.kb.getAllClasses());
                        } else {
                            set = this.flatten(this.kb.getSubClasses(aTermAppl24, bl));
                            set.addAll(this.kb.getAllEquivalentClasses(aTermAppl24));
                        }
                        if (bl2) {
                            set.removeAll(this.kb.getAllEquivalentClasses(aTermAppl24));
                        }
                    } else {
                        set = this.kb.getClasses();
                    }
                    boolean bl9 = set4 == null;
                    for (ATermAppl aTermAppl26 : set) {
                        if (bl9) {
                            set4 = this.flatten(this.kb.getSuperClasses(aTermAppl26, bl));
                            if (bl2) {
                                set4.removeAll(this.kb.getEquivalentClasses(aTermAppl26));
                            } else if (!ATermUtils.isComplexClass((ATerm)aTermAppl26)) {
                                set4.add(aTermAppl26);
                            }
                        }
                        for (ATermAppl aTermAppl27 : set4) {
                            this.runNext(resultBinding, list, aTermAppl26, aTermAppl27);
                        }
                    }
                }
                break;
            }
            case EquivalentClass: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl28 = list.get(1);
                block65: for (ATermAppl aTermAppl29 : this.getSymmetricCandidates(Query.VarType.CLASS, aTermAppl, aTermAppl28)) {
                    Set<ATermAppl> set = aTermAppl.equals(aTermAppl28) ? Collections.singleton(aTermAppl29) : this.kb.getEquivalentClasses(aTermAppl29);
                    for (ATermAppl aTermAppl30 : set) {
                        int n = this.result.size();
                        this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl29, aTermAppl28, aTermAppl30, resultBinding);
                        if (this.result.size() != n) continue;
                        continue block65;
                    }
                }
                break;
            }
            case DisjointWith: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl31 = list.get(1);
                if (!aTermAppl.equals(aTermAppl31)) {
                    for (ATermAppl aTermAppl32 : this.getSymmetricCandidates(Query.VarType.CLASS, aTermAppl, aTermAppl31)) {
                        for (Set<ATermAppl> set : this.kb.getDisjointClasses(aTermAppl32)) {
                            for (ATermAppl aTermAppl33 : set) {
                                this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl32, aTermAppl31, aTermAppl33, resultBinding);
                            }
                        }
                    }
                    break;
                }
                log.finer("Atom " + queryAtom + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case ComplementOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl34 = list.get(1);
                if (!aTermAppl.equals(aTermAppl34)) {
                    for (ATermAppl aTermAppl35 : this.getSymmetricCandidates(Query.VarType.CLASS, aTermAppl, aTermAppl34)) {
                        for (ATermAppl aTermAppl36 : this.kb.getComplements(aTermAppl35)) {
                            this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl35, aTermAppl34, aTermAppl36, resultBinding);
                        }
                    }
                    break;
                }
                log.finer("Atom " + queryAtom + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case DirectSubPropertyOf: {
                bl = true;
            }
            case StrictSubPropertyOf: {
                bl2 = true;
            }
            case SubPropertyOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl37 = list.get(1);
                if (aTermAppl.equals(aTermAppl37)) {
                    for (ATermAppl aTermAppl38 : this.kb.getProperties()) {
                        this.runNext(resultBinding, list, aTermAppl38, aTermAppl38);
                    }
                } else {
                    Set<ATermAppl> set;
                    boolean bl10 = this.isDownMonotonic(aTermAppl);
                    boolean bl11 = this.isDownMonotonic(aTermAppl37);
                    if (bl10 || bl11) {
                        this.downMonotonic(this.kb.getRoleTaxonomy(true), this.kb.getProperties(), bl10, aTermAppl, aTermAppl37, resultBinding, bl, bl2);
                        break;
                    }
                    Set<ATermAppl> set5 = null;
                    if (!ATermUtils.isVar(aTermAppl)) {
                        set = Collections.singleton(aTermAppl);
                        set5 = this.flatten(this.kb.getSuperProperties(aTermAppl, bl));
                        if (bl2) {
                            set5.removeAll(this.kb.getEquivalentProperties(aTermAppl));
                        } else {
                            set5.add(aTermAppl);
                        }
                    } else if (!ATermUtils.isVar(aTermAppl37)) {
                        set5 = Collections.singleton(aTermAppl37);
                        set = this.flatten(this.kb.getSubProperties(aTermAppl37, bl));
                        if (bl2) {
                            set.removeAll(this.kb.getEquivalentProperties(aTermAppl37));
                        } else {
                            set.add(aTermAppl37);
                        }
                    } else {
                        set = this.kb.getProperties();
                    }
                    boolean bl12 = set5 == null;
                    for (ATermAppl aTermAppl39 : set) {
                        if (bl12) {
                            set5 = this.flatten(this.kb.getSuperProperties(aTermAppl39, bl));
                            if (bl2) {
                                set5.removeAll(this.kb.getEquivalentProperties(aTermAppl39));
                            } else {
                                set5.add(aTermAppl39);
                            }
                        }
                        for (ATermAppl aTermAppl40 : set5) {
                            this.runNext(resultBinding, list, aTermAppl39, aTermAppl40);
                        }
                    }
                }
                break;
            }
            case EquivalentProperty: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl41 = list.get(1);
                block75: for (ATermAppl aTermAppl42 : this.getSymmetricCandidates(Query.VarType.PROPERTY, aTermAppl, aTermAppl41)) {
                    Set<ATermAppl> set = aTermAppl.equals(aTermAppl41) ? Collections.singleton(aTermAppl42) : this.kb.getEquivalentProperties(aTermAppl42);
                    for (ATermAppl aTermAppl43 : set) {
                        int n = this.result.size();
                        this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl42, aTermAppl41, aTermAppl43, resultBinding);
                        if (this.result.size() != n) continue;
                        continue block75;
                    }
                }
                break;
            }
            case Domain: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl44 = list.get(1);
                Set<ATermAppl> set = !ATermUtils.isVar(aTermAppl) ? Collections.singleton(aTermAppl) : this.kb.getProperties();
                Set<ATermAppl> set6 = !ATermUtils.isVar(aTermAppl44) ? Collections.singleton(aTermAppl44) : this.kb.getAllClasses();
                for (ATermAppl aTermAppl45 : set) {
                    for (ATermAppl aTermAppl46 : set6) {
                        if (!this.kb.isDatatypeProperty((ATerm)aTermAppl45) && !this.kb.isObjectProperty((ATerm)aTermAppl45) || !this.kb.hasDomain(aTermAppl45, aTermAppl46)) continue;
                        this.runNext(resultBinding, list, aTermAppl45, aTermAppl46);
                    }
                }
                break;
            }
            case Range: {
                Set<Object> set;
                Set<Object> set7;
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl47 = list.get(1);
                Set<ATermAppl> set8 = !ATermUtils.isVar(aTermAppl) ? Collections.singleton(aTermAppl) : this.kb.getProperties();
                if (!ATermUtils.isVar(aTermAppl47)) {
                    if (this.kb.isDatatype(aTermAppl47)) {
                        set7 = Collections.emptySet();
                        set = Collections.singleton(aTermAppl47);
                    } else {
                        set7 = Collections.singleton(aTermAppl47);
                        set = Collections.emptySet();
                    }
                } else {
                    set7 = this.kb.getAllClasses();
                    set = new HashSet();
                    for (ATermAppl aTermAppl48 : this.kb.getDatatypeReasoner().listDataRanges()) {
                        set.add(aTermAppl48);
                    }
                }
                for (ATermAppl aTermAppl48 : set8) {
                    if (this.kb.isObjectProperty((ATerm)aTermAppl48)) {
                        for (ATermAppl aTermAppl51 : set7) {
                            if (!this.kb.hasRange(aTermAppl48, aTermAppl51)) continue;
                            this.runNext(resultBinding, list, aTermAppl48, aTermAppl51);
                        }
                        continue;
                    }
                    if (!this.kb.isDatatypeProperty((ATerm)aTermAppl48)) continue;
                    for (ATermAppl collection : set) {
                        if (!this.kb.hasRange(aTermAppl48, collection)) continue;
                        this.runNext(resultBinding, list, aTermAppl48, collection);
                    }
                }
                break;
            }
            case InverseOf: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl50 = list.get(1);
                if (aTermAppl.equals(aTermAppl50)) {
                    this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getSymmetricProperties(), resultBinding);
                    break;
                }
                for (ATermAppl aTermAppl2 : this.getSymmetricCandidates(Query.VarType.PROPERTY, aTermAppl, aTermAppl50)) {
                    for (ATermAppl aTermAppl54 : this.kb.getInverses((ATerm)aTermAppl2)) {
                        this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl2, aTermAppl50, aTermAppl54, resultBinding);
                    }
                }
                break;
            }
            case Symmetric: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getSymmetricProperties(), resultBinding);
                break;
            }
            case Asymmetric: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getAsymmetricProperties(), resultBinding);
                break;
            }
            case Reflexive: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getReflexiveProperties(), resultBinding);
                break;
            }
            case Irreflexive: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getIrreflexiveProperties(), resultBinding);
                break;
            }
            case ObjectProperty: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getObjectProperties(), resultBinding);
                break;
            }
            case DatatypeProperty: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getDataProperties(), resultBinding);
                break;
            }
            case Functional: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getFunctionalProperties(), resultBinding);
                break;
            }
            case InverseFunctional: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getInverseFunctionalProperties(), resultBinding);
                break;
            }
            case Transitive: {
                this.runAllPropertyChecks(queryAtom, list.get(0), this.kb.getTransitiveProperties(), resultBinding);
                break;
            }
            case UndistVarCore: {
                CoreNewImpl coreNewImpl = (CoreNewImpl)queryAtom.apply(resultBinding);
                Collection collection = coreNewImpl.getDistVars();
                if (collection.isEmpty()) {
                    ATermAppl aTermAppl57;
                    Collection coreStrategy = coreNewImpl.getConstants();
                    if (coreStrategy.isEmpty()) {
                        if (!QueryEngine.execBooleanABoxQuery(coreNewImpl.getQuery())) break;
                        this.result.add(resultBinding);
                        break;
                    }
                    ATermAppl aTermAppl56 = (ATermAppl)coreStrategy.iterator().next();
                    if (!this.kb.isType(aTermAppl56, aTermAppl57 = coreNewImpl.getQuery().rollUpTo(aTermAppl56, Collections.emptySet(), this.STOP_ROLLING_ON_CONSTANTS))) break;
                    this.exec(resultBinding);
                    break;
                }
                if (collection.size() == 1) {
                    ATermAppl aTermAppl = (ATermAppl)collection.iterator().next();
                    ATermAppl combinedQueryEngine = coreNewImpl.getQuery().rollUpTo(aTermAppl, Collections.emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
                    Set<ATermAppl> queryAtom2 = this.kb.getInstances(combinedQueryEngine);
                    for (ATermAppl aTermAppl3 : queryAtom2) {
                        ResultBinding resultBinding2 = resultBinding.duplicate();
                        resultBinding2.setValue(aTermAppl, aTermAppl3);
                        this.exec(resultBinding2);
                    }
                    break;
                }
                CoreStrategy queryImpl = QueryEngine.getStrategy(queryAtom);
                switch (queryImpl) {
                    case SIMPLE: {
                        this.execSimpleCore(this.oldQuery, resultBinding, collection);
                        break block0;
                    }
                    case ALLFAST: {
                        this.execAllFastCore(this.oldQuery, resultBinding, collection, coreNewImpl.getUndistVars());
                        break block0;
                    }
                }
                throw new InternalReasonerException("Unknown core strategy.");
            }
            case NegativePropertyValue: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl list2 = list.get(1);
                ATermAppl bl13 = list.get(2);
                if (ATermUtils.isVar(list2)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a variable property not supported");
                }
                if (ATermUtils.isVar(bl13) && this.kb.isDatatypeProperty((ATerm)list2)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a datatype property and variable object not supported");
                }
                if (ATermUtils.isVar(aTermAppl)) {
                    Set<ATermAppl> set = ATermUtils.isVar(bl13) ? this.kb.getIndividuals() : Collections.singleton(bl13);
                    for (ATermAppl aTermAppl4 : set) {
                        Set<ATermAppl> set2 = this.kb.getInstances(TermFactory.not(TermFactory.hasValue(list2, aTermAppl4)));
                        for (ATermAppl aTermAppl5 : set2) {
                            this.runNext(resultBinding, list, aTermAppl5, list2, aTermAppl4);
                        }
                    }
                    break;
                }
                if (ATermUtils.isVar(bl13)) {
                    Set<ATermAppl> set = this.kb.getInstances(TermFactory.not(TermFactory.hasValue(TermFactory.inv(list2), bl13)));
                    for (ATermAppl aTermAppl6 : set) {
                        this.runNext(resultBinding, list, aTermAppl, list2, aTermAppl6);
                    }
                    break;
                }
                if (!this.kb.isType(aTermAppl, TermFactory.hasValue(list2, bl13))) break;
                this.exec(resultBinding);
                break;
            }
            case NotKnown: {
                QueryImpl aTermAppl = new QueryImpl(this.kb, true);
                for (QueryAtom queryImpl : ((NotKnownQueryAtom)queryAtom).getAtoms()) {
                    aTermAppl.add(queryImpl.apply(resultBinding));
                }
                for (ATermAppl aTermAppl7 : aTermAppl.getUndistVars()) {
                    aTermAppl.addDistVar(aTermAppl7, Query.VarType.INDIVIDUAL);
                }
                CombinedQueryEngine aTermAppl61 = new CombinedQueryEngine();
                boolean bl3 = aTermAppl61.exec(aTermAppl).isEmpty();
                if (!bl3) break;
                this.exec(resultBinding);
                break;
            }
            case Union: {
                for (List<QueryAtom> list2 : ((UnionQueryAtom)queryAtom).getUnion()) {
                    QueryImpl queryImpl = new QueryImpl(this.kb, true);
                    for (QueryAtom queryAtom2 : list2) {
                        queryImpl.add(queryAtom2.apply(resultBinding));
                    }
                    for (ATermAppl aTermAppl : queryImpl.getUndistVars()) {
                        queryImpl.addDistVar(aTermAppl, Query.VarType.INDIVIDUAL);
                        queryImpl.addResultVar(aTermAppl);
                    }
                    CombinedQueryEngine combinedQueryEngine = new CombinedQueryEngine();
                    QueryResult queryResult = combinedQueryEngine.exec(queryImpl);
                    for (ResultBinding resultBinding3 : queryResult) {
                        resultBinding3.setValues(resultBinding);
                        this.exec(resultBinding3);
                    }
                }
                break;
            }
            case Datatype: {
                throw new UnsupportedQueryException("Datatype atom not ground: " + queryAtom);
            }
            case propertyDisjointWith: {
                ATermAppl aTermAppl = list.get(0);
                ATermAppl aTermAppl8 = list.get(1);
                if (!aTermAppl.equals(aTermAppl8)) {
                    for (ATermAppl aTermAppl9 : this.getSymmetricCandidates(Query.VarType.PROPERTY, aTermAppl, aTermAppl8)) {
                        for (Set<ATermAppl> set : this.kb.getDisjointProperties(aTermAppl9)) {
                            for (ATermAppl aTermAppl10 : set) {
                                this.runSymetricCheck(queryAtom, aTermAppl, aTermAppl9, aTermAppl8, aTermAppl10, resultBinding);
                            }
                        }
                    }
                    break;
                }
                log.finer("Atom " + queryAtom + "cannot be satisfied in any consistent ontology.");
                break;
            }
            default: {
                throw new UnsupportedQueryException("Unknown atom type '" + (Object)((Object)queryAtom.getPredicate()) + "'.");
            }
        }
    }

    private void execSimpleCore(Query query, ResultBinding resultBinding, Collection<ATermAppl> collection) {
        Object object;
        HashMap<ATermAppl, Set<ATermAppl>> hashMap = new HashMap<ATermAppl, Set<ATermAppl>>();
        KnowledgeBase knowledgeBase = query.getKB();
        for (ATermAppl object22 : collection) {
            ATermAppl bl = query.rollUpTo(object22, Collections.emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
            if (log.isLoggable(Level.FINER)) {
                log.finer(object22 + " rolled to " + bl);
            }
            object = knowledgeBase.getInstances(bl);
            hashMap.put(object22, (Set<ATermAppl>)object);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Var bindings: " + hashMap);
        }
        Set<ATermAppl> set = query.getDistVarsForType(Query.VarType.LITERAL);
        Set<ATermAppl> set2 = query.getDistVarsForType(Query.VarType.INDIVIDUAL);
        boolean bl = !set2.containsAll(set);
        object = new BindingIterator(hashMap);
        while (object.hasNext()) {
            ResultBinding resultBinding2 = ((ResultBinding)object.next()).duplicate();
            resultBinding2.setValues(resultBinding);
            if (bl) {
                LiteralIterator literalIterator = new LiteralIterator(query, resultBinding2);
                while (literalIterator.hasNext()) {
                    ResultBinding resultBinding3 = resultBinding.duplicate();
                    resultBinding3.setValues((ResultBinding)literalIterator.next());
                    if (!QueryEngine.execBooleanABoxQuery(query.apply(resultBinding3))) continue;
                    this.exec(resultBinding3);
                }
                continue;
            }
            if (!QueryEngine.execBooleanABoxQuery(query.apply(resultBinding2))) continue;
            this.exec(resultBinding2);
        }
    }

    private Map<ATermAppl, Boolean> fastPrune(Query query, ATermAppl aTermAppl) {
        ATermAppl aTermAppl2 = query.rollUpTo(aTermAppl, Collections.emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
        if (log.isLoggable(Level.FINER)) {
            log.finer(aTermAppl + " rolled to " + aTermAppl2);
        }
        CandidateSet<ATermAppl> candidateSet = this.kb.getABox().getObviousInstances(aTermAppl2);
        HashMap<ATermAppl, Boolean> hashMap = new HashMap<ATermAppl, Boolean>();
        for (ATermAppl aTermAppl3 : candidateSet.getKnowns()) {
            hashMap.put(aTermAppl3, true);
        }
        for (ATermAppl aTermAppl3 : candidateSet.getUnknowns()) {
            hashMap.put(aTermAppl3, false);
        }
        return hashMap;
    }

    private void execAllFastCore(Query query, ResultBinding resultBinding, Collection<ATermAppl> collection, Collection<ATermAppl> collection2) {
        if (collection.isEmpty()) {
            this.exec(resultBinding);
        } else {
            ATermAppl aTermAppl = collection.iterator().next();
            collection.remove(aTermAppl);
            Map<ATermAppl, Boolean> map = this.fastPrune(query, aTermAppl);
            for (Map.Entry<ATermAppl, Boolean> entry : map.entrySet()) {
                ATermAppl aTermAppl2 = entry.getKey();
                ResultBinding resultBinding2 = resultBinding.duplicate();
                resultBinding2.setValue(aTermAppl, aTermAppl2);
                Query query2 = query.apply(resultBinding2);
                if (!entry.getValue().booleanValue() && !QueryEngine.execBooleanABoxQuery(query2)) continue;
                this.execAllFastCore(query2, resultBinding2, collection, collection2);
            }
            collection.add(aTermAppl);
        }
    }

    private void downMonotonic(Taxonomy<ATermAppl> taxonomy, Collection<ATermAppl> collection, boolean bl, ATermAppl aTermAppl, ATermAppl aTermAppl2, ResultBinding resultBinding, boolean bl2, boolean bl3) {
        Collection<ATermAppl> collection2;
        ATermAppl aTermAppl3;
        ATermAppl aTermAppl4 = bl ? aTermAppl : aTermAppl2;
        ATermAppl aTermAppl5 = aTermAppl3 = bl ? aTermAppl2 : aTermAppl;
        if (ATermUtils.isVar(aTermAppl3)) {
            collection2 = collection;
        } else {
            Object object;
            Object object2 = object = bl ? aTermAppl2 : taxonomy.getTop().getName();
            if (ATermUtils.isComplexClass((ATerm)object)) {
                collection2 = this.kb.getEquivalentClasses((ATermAppl)object);
                if (!bl3 && collection2.isEmpty()) {
                    collection2 = this.flatten(this.kb.getSubClasses((ATermAppl)object, true));
                }
            } else {
                collection2 = Collections.singleton(object);
            }
        }
        for (ATermAppl aTermAppl6 : collection2) {
            Set<ATermAppl> set;
            ResultBinding resultBinding2 = resultBinding.duplicate();
            if (ATermUtils.isVar(aTermAppl3)) {
                resultBinding2.setValue(aTermAppl3, aTermAppl6);
            }
            Set<ATermAppl> set2 = set = bl ? this.flatten(taxonomy.getSubs(aTermAppl6, bl2)) : this.flatten(taxonomy.getSupers(aTermAppl6, bl2));
            if (bl3) {
                set.removeAll(taxonomy.getEquivalents(aTermAppl6));
            } else {
                set.add(aTermAppl6);
            }
            this.runRecursively(taxonomy, aTermAppl4, aTermAppl6, resultBinding2, new HashSet<ATermAppl>(set), bl2, bl3);
        }
    }

    private boolean isDownMonotonic(ATermAppl aTermAppl) {
        return PelletOptions.OPTIMIZE_DOWN_MONOTONIC && this.downMonotonic.contains(aTermAppl);
    }

    private void runNext(ResultBinding resultBinding, List<ATermAppl> list, ATermAppl ... aTermApplArray) {
        ResultBinding resultBinding2 = resultBinding.duplicate();
        for (int i = 0; i < list.size(); ++i) {
            if (!ATermUtils.isVar(list.get(i))) continue;
            resultBinding2.setValue(list.get(i), aTermApplArray[i]);
        }
        this.exec(resultBinding2);
    }

    private Set<ATermAppl> getSymmetricCandidates(Query.VarType varType, ATermAppl aTermAppl, ATermAppl aTermAppl2) {
        Set<ATermAppl> set;
        if (!ATermUtils.isVar(aTermAppl)) {
            set = Collections.singleton(aTermAppl);
        } else if (!ATermUtils.isVar(aTermAppl2)) {
            set = Collections.singleton(aTermAppl2);
        } else {
            switch (varType) {
                case CLASS: {
                    set = this.kb.getClasses();
                    break;
                }
                case PROPERTY: {
                    set = this.kb.getProperties();
                    break;
                }
                case INDIVIDUAL: {
                    set = this.kb.getIndividuals();
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown variable type : " + (Object)((Object)varType));
                }
            }
        }
        return set;
    }

    private void runRecursively(Taxonomy<ATermAppl> taxonomy, ATermAppl aTermAppl, ATermAppl aTermAppl2, ResultBinding resultBinding, Set<ATermAppl> set, boolean bl, boolean bl2) {
        int n = this.result.size();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Trying : " + aTermAppl2 + ", done=" + set);
        }
        if (!bl2) {
            set.remove(aTermAppl2);
            this.runNext(resultBinding, Collections.singletonList(aTermAppl), aTermAppl2);
        }
        if (bl2 || this.result.size() > n) {
            Set<ATermAppl> set2 = this.flatten(taxonomy.getSubs(aTermAppl2, bl));
            for (ATermAppl aTermAppl3 : set2) {
                if (!set.contains(aTermAppl3)) continue;
                this.runRecursively(taxonomy, aTermAppl, aTermAppl3, resultBinding, set, false, false);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Skipping subs of " + aTermAppl2);
            }
            set.removeAll(this.flatten(taxonomy.getSubs(aTermAppl2, false)));
        }
    }

    private void runSymetricCheck(QueryAtom queryAtom, ATermAppl aTermAppl, ATermAppl aTermAppl2, ATermAppl aTermAppl3, ATermAppl aTermAppl4, ResultBinding resultBinding) {
        ResultBinding resultBinding2 = resultBinding.duplicate();
        if (!ATermUtils.isVar(aTermAppl)) {
            resultBinding2.setValue(aTermAppl3, aTermAppl4);
        } else if (!ATermUtils.isVar(aTermAppl3)) {
            resultBinding2.setValue(aTermAppl, aTermAppl4);
        } else {
            resultBinding2.setValue(aTermAppl, aTermAppl2);
            resultBinding2.setValue(aTermAppl3, aTermAppl4);
        }
        this.exec(resultBinding2);
    }

    private void runAllPropertyChecks(QueryAtom queryAtom, ATermAppl aTermAppl, Set<ATermAppl> set, ResultBinding resultBinding) {
        if (this.isDownMonotonic(aTermAppl)) {
            for (TaxonomyNode<ATermAppl> taxonomyNode : this.kb.getRoleTaxonomy(true).getTop().getSubs()) {
                ATermAppl aTermAppl2 = taxonomyNode.getName();
                if (!set.contains(aTermAppl2)) continue;
                this.runRecursively(this.kb.getRoleTaxonomy(true), aTermAppl, taxonomyNode.getName(), resultBinding, new HashSet<ATermAppl>(set), false, false);
            }
        } else {
            for (ATermAppl aTermAppl3 : set) {
                ResultBinding resultBinding2 = resultBinding.duplicate();
                resultBinding2.setValue(aTermAppl, aTermAppl3);
                this.exec(resultBinding2);
            }
        }
    }

    private Set<ATermAppl> flatten(Set<Set<ATermAppl>> set) {
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Set<ATermAppl> set2 : set) {
            for (ATermAppl aTermAppl : set2) {
                hashSet.add(aTermAppl);
            }
        }
        return hashSet;
    }
}

