/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.fsm.Transition;
import org.mindswap.pellet.utils.fsm.TransitionGraph;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

public class CacheSafetyDynamic
implements CacheSafety {
    private final Expressivity expressivity;

    CacheSafetyDynamic(Expressivity expressivity) {
        this.expressivity = new Expressivity(expressivity);
    }

    @Override
    public boolean canSupport(Expressivity expressivity) {
        return !expressivity.hasNominal() && this.expressivity.getAnonInverses().equals(expressivity.getAnonInverses());
    }

    @Override
    public boolean isSafe(ATermAppl aTermAppl, Individual individual) {
        Edge edge = this.getParentEdge(individual);
        Role role = edge.getRole();
        Individual individual2 = edge.getFrom();
        ABox aBox = individual2.getABox();
        if (!this.isParentSafe(aBox.getKB(), role, individual2)) {
            return false;
        }
        Iterator<CachedNode> iterator = this.getCachedNodes(aBox, aTermAppl);
        if (!iterator.hasNext()) {
            return false;
        }
        if (this.interactsWithInverses(aBox.getKB(), role)) {
            while (iterator.hasNext()) {
                CachedNode cachedNode = iterator.next();
                if (cachedNode.isBottom()) {
                    return true;
                }
                if (cachedNode.isTop() || !cachedNode.isComplete()) {
                    return false;
                }
                if (this.isSafe(aBox.getKB(), individual2, role.getInverse(), cachedNode)) continue;
                return false;
            }
        }
        return true;
    }

    protected Edge getParentEdge(Individual individual) {
        Edge edge = null;
        Role role = null;
        Individual individual2 = individual.getParent();
        for (Edge edge2 : individual.getInEdges()) {
            if (!edge2.getFrom().equals(individual2)) continue;
            if (role == null) {
                role = edge2.getRole();
                edge = edge2;
                continue;
            }
            if (!edge2.getRole().isSubRoleOf(role)) continue;
            role = edge2.getRole();
            edge = edge2;
        }
        assert (edge != null);
        return edge;
    }

    protected Iterator<CachedNode> getCachedNodes(ABox aBox, ATermAppl aTermAppl) {
        CachedNode cachedNode = aBox.getCached(aTermAppl);
        if (cachedNode != null) {
            return IteratorUtils.singleton(cachedNode);
        }
        if (ATermUtils.isAnd(aTermAppl)) {
            ATermList aTermList = (ATermList)aTermAppl.getArgument(0);
            CachedNode[] cachedNodeArray = new CachedNode[aTermList.getLength()];
            int n = 0;
            while (!aTermList.isEmpty()) {
                ATermAppl aTermAppl2 = (ATermAppl)aTermList.getFirst();
                cachedNode = aBox.getCached(aTermAppl2);
                if (cachedNode == null) {
                    return IteratorUtils.emptyIterator();
                }
                if (cachedNode.isBottom()) {
                    return IteratorUtils.singleton(cachedNode);
                }
                cachedNodeArray[n++] = cachedNode;
                aTermList = aTermList.getNext();
            }
            return IteratorUtils.iterator(cachedNodeArray);
        }
        return IteratorUtils.emptyIterator();
    }

    private boolean isParentSafe(KnowledgeBase knowledgeBase, Role role, Individual individual) {
        return this.isParentFunctionalSafe(role, individual) && this.isParentMaxSafe(knowledgeBase, role, individual);
    }

    private boolean isParentFunctionalSafe(Role role, Individual individual) {
        return !role.isFunctional() || individual.getRNeighbors(role).size() <= 1;
    }

    private boolean isParentMaxSafe(KnowledgeBase knowledgeBase, Role role, Individual individual) {
        for (ATermAppl aTermAppl : individual.getTypes(5)) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0);
            if (this.isParentMaxSafe(knowledgeBase, role, aTermAppl2)) continue;
            return false;
        }
        return true;
    }

    private boolean isParentMaxSafe(KnowledgeBase knowledgeBase, Role role, ATermAppl aTermAppl) {
        Role role2 = knowledgeBase.getRole(aTermAppl.getArgument(0));
        return !role.isSubRoleOf(role2);
    }

    private boolean isSafe(KnowledgeBase knowledgeBase, Individual individual, Role role, CachedNode cachedNode) {
        if (!this.isFunctionalSafe(role, cachedNode)) {
            return false;
        }
        for (ATermAppl aTermAppl : cachedNode.getDepends().keySet()) {
            ATermAppl aTermAppl2;
            if (!(ATermUtils.isAllValues(aTermAppl) ? !this.isAllValuesSafe(knowledgeBase, individual, role, aTermAppl) : ATermUtils.isNot(aTermAppl) && ATermUtils.isMin(aTermAppl2 = (ATermAppl)aTermAppl.getArgument(0)) && !this.isMaxSafe(knowledgeBase, role, aTermAppl2))) continue;
            return false;
        }
        return true;
    }

    private boolean isAllValuesSafe(KnowledgeBase knowledgeBase, Individual individual, Role role, ATermAppl aTermAppl) {
        Role role2 = knowledgeBase.getRole(aTermAppl.getArgument(0));
        if (!role2.hasComplexSubRole()) {
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
            if (role.isSubRoleOf(role2) && !individual.hasType((ATerm)aTermAppl2)) {
                return false;
            }
        } else {
            TransitionGraph<Role> transitionGraph = role2.getFSM();
            for (Transition<Role> transition : transitionGraph.getInitialState().getTransitions()) {
                if (!role.isSubRoleOf(transition.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFunctionalSafe(Role role, CachedNode cachedNode) {
        return !role.isFunctional() || this.getRNeighbors(cachedNode, role).isEmpty();
    }

    private boolean isMaxSafe(KnowledgeBase knowledgeBase, Role role, ATermAppl aTermAppl) {
        Role role2 = knowledgeBase.getRole(aTermAppl.getArgument(0));
        return !role.isSubRoleOf(role2);
    }

    private Set<ATermAppl> getRNeighbors(CachedNode cachedNode, Role role) {
        Role role2;
        HashSet<ATermAppl> hashSet = new HashSet<ATermAppl>();
        for (Edge edge : cachedNode.getOutEdges()) {
            role2 = edge.getRole();
            if (!role2.isSubRoleOf(role)) continue;
            hashSet.add(edge.getToName());
        }
        if (role.isObjectRole()) {
            role = role.getInverse();
            for (Edge edge : cachedNode.getInEdges()) {
                role2 = edge.getRole();
                if (!role2.isSubRoleOf(role)) continue;
                hashSet.add(edge.getFromName());
            }
        }
        return hashSet;
    }

    protected boolean interactsWithInverses(KnowledgeBase knowledgeBase, Role role) {
        if (this.interactsWithInversesSimple(role)) {
            return true;
        }
        return this.expressivity.hasComplexSubRoles() && this.interactsWithInversesComplex(knowledgeBase, role);
    }

    protected boolean interactsWithInversesSimple(Role role) {
        for (Role role2 : role.getSuperRoles()) {
            if (!this.hasAnonInverse(role2)) continue;
            return true;
        }
        return false;
    }

    protected boolean interactsWithInversesComplex(KnowledgeBase knowledgeBase, Role role) {
        for (ATermAppl aTermAppl : this.expressivity.getAnonInverses()) {
            Role role2 = knowledgeBase.getRole((ATerm)aTermAppl);
            if (!role2.hasComplexSubRole() || !role2.getFSM().getAlpahabet().contains(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnonInverse(Role role) {
        return !role.isBuiltin() && (role.isAnon() || this.expressivity.getAnonInverses().contains(role.getName()));
    }
}

