/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;

class LiteralIterator
implements Iterator<ResultBinding> {
    private int[] indices;
    private ResultBinding binding;
    private Set<ATermAppl> litVars;
    private List<List<ATermAppl>> litVarBindings = new ArrayList<List<ATermAppl>>();
    private boolean more = true;

    public LiteralIterator(Query query, ResultBinding resultBinding) {
        KnowledgeBase knowledgeBase = query.getKB();
        this.binding = resultBinding;
        this.litVars = query.getDistVarsForType(Query.VarType.LITERAL);
        this.indices = new int[this.litVars.size()];
        int n = 0;
        for (ATermAppl aTermAppl : this.litVars) {
            ArrayList<ATermAppl> arrayList = new ArrayList<ATermAppl>();
            boolean bl = true;
            for (QueryAtom queryAtom : query.findAtoms(QueryPredicate.PropertyValue, null, null, aTermAppl)) {
                ATermAppl aTermAppl2 = queryAtom.getArguments().get(0);
                ATermAppl aTermAppl3 = queryAtom.getArguments().get(1);
                if (ATermUtils.isVar(aTermAppl2)) {
                    aTermAppl2 = resultBinding.getValue(aTermAppl2);
                }
                this.litVarBindings.add(n, new ArrayList());
                List<ATermAppl> list = knowledgeBase.getDataPropertyValues(aTermAppl3, aTermAppl2);
                if (bl) {
                    arrayList.addAll(list);
                    continue;
                }
                arrayList.retainAll(list);
                bl = false;
            }
            if (arrayList.size() > 0) {
                this.litVarBindings.get(n++).addAll(arrayList);
                continue;
            }
            this.more = false;
        }
    }

    private boolean incIndex(int n) {
        if (this.indices[n] + 1 >= this.litVarBindings.get(n).size()) {
            if (n == this.indices.length - 1) {
                return false;
            }
            this.indices[n] = 0;
            return this.incIndex(n + 1);
        }
        int n2 = n;
        this.indices[n2] = this.indices[n2] + 1;
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from this iterator is not supported.");
    }

    @Override
    public boolean hasNext() {
        return this.more;
    }

    @Override
    public ResultBinding next() {
        if (!this.more) {
            return null;
        }
        ResultBinding resultBinding = this.binding.duplicate();
        int n = 0;
        for (ATermAppl aTermAppl : this.litVars) {
            ATermAppl aTermAppl2 = this.litVarBindings.get(n).get(this.indices[n++]);
            resultBinding.setValue(aTermAppl, aTermAppl2);
        }
        this.more = this.incIndex(0);
        return resultBinding;
    }
}

