/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.utils.Pair;

public class Index<S, T>
implements Iterable<T> {
    private int size;
    private IndexNode<S, T> root;

    public Index() {
        this.clear();
    }

    public boolean add(List<S> list, T t) {
        if (this.root.add(list, t)) {
            ++this.size;
            return true;
        }
        return false;
    }

    public void clear() {
        this.root = new IndexNode();
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return ((IndexNode)this.root).getAllLeaves().iterator();
    }

    public <U> Collection<Pair<T, U>> join(Index<S, U> index, int n) {
        ArrayList<Pair<T, U>> arrayList = new ArrayList<Pair<T, U>>();
        this.root.join(index.root, n, arrayList);
        return arrayList;
    }

    public Collection<T> match(List<S> list) {
        ArrayList arrayList = new ArrayList();
        this.root.match(list, arrayList);
        return arrayList;
    }

    public boolean remove(List<S> list, T t) {
        if (this.root.remove(list, t)) {
            --this.size;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Index ");
        this.root.print(stringBuilder, "");
        return stringBuilder.toString();
    }

    private static class IndexNode<I, J> {
        private Map<I, IndexNode<I, J>> children = new HashMap<I, IndexNode<I, J>>();
        private Collection<J> leaves = new HashSet<J>();

        public boolean add(List<I> list, J j) {
            if (list.size() == 0) {
                return this.leaves.add(j);
            }
            I i = list.get(0);
            IndexNode<I, J> indexNode = this.children.get(i);
            if (indexNode == null) {
                indexNode = new IndexNode<I, J>();
                this.children.put(i, indexNode);
            }
            return indexNode.add(list.subList(1, list.size()), j);
        }

        private Collection<J> getAllLeaves() {
            ArrayList arrayList = new ArrayList();
            this.getAllLeaves(arrayList);
            return arrayList;
        }

        private void getAllLeaves(Collection<J> collection) {
            collection.addAll(this.leaves);
            for (IndexNode<I, J> indexNode : this.children.values()) {
                super.getAllLeaves(collection);
            }
        }

        public <V> void join(IndexNode<I, V> indexNode, int n, Collection<Pair<J, V>> collection) {
            if (n > 0) {
                for (Map.Entry<I, IndexNode<I, J>> entry : this.children.entrySet()) {
                    if (entry.getKey() != null) {
                        IndexNode<I, J> indexNode2;
                        IndexNode<I, J> indexNode3 = indexNode.children.get(entry.getKey());
                        if (indexNode3 != null) {
                            entry.getValue().join(indexNode3, n - 1, collection);
                        }
                        if ((indexNode2 = indexNode.children.get(null)) == null) continue;
                        entry.getValue().join(indexNode2, n - 1, collection);
                        continue;
                    }
                    for (IndexNode<I, J> indexNode2 : indexNode.children.values()) {
                        entry.getValue().join(indexNode2, n - 1, collection);
                    }
                }
            } else {
                for (J j : this.getAllLeaves()) {
                    for (V v : super.getAllLeaves()) {
                        collection.add(new Pair<J, V>(j, v));
                    }
                }
            }
        }

        public void match(List<I> list, Collection<J> collection) {
            if (list.size() == 0) {
                collection.addAll(this.leaves);
            } else {
                IndexNode<I, J> indexNode;
                List<I> list2 = list.subList(1, list.size());
                IndexNode<I, J> indexNode2 = this.children.get(list.get(0));
                if (indexNode2 != null) {
                    indexNode2.match(list2, collection);
                }
                if ((indexNode = this.children.get(null)) != null) {
                    indexNode.match(list2, collection);
                }
            }
        }

        public void print(StringBuilder stringBuilder, String string) {
            if (this.leaves.size() > 0) {
                stringBuilder.append(this.leaves.toString());
            }
            stringBuilder.append(":\n");
            string = string + " ";
            for (Map.Entry<I, IndexNode<I, J>> entry : this.children.entrySet()) {
                stringBuilder.append(string).append(entry.getKey()).append(" ");
                entry.getValue().print(stringBuilder, string);
            }
        }

        public boolean remove(List<I> list, J j) {
            if (list.size() == 0) {
                return this.leaves.remove(j);
            }
            I i = list.get(0);
            IndexNode<I, J> indexNode = this.children.get(i);
            if (indexNode == null) {
                return false;
            }
            boolean bl = indexNode.remove(list.subList(1, list.size()), j);
            if (bl && indexNode.leaves.isEmpty()) {
                this.children.remove(indexNode);
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Index Node ");
            this.print(stringBuilder, "");
            return stringBuilder.toString();
        }
    }
}

