/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import org.coode.owlapi.owlxmlparser.AbstractClassExpressionElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLAxiomElementHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLDataRangeHandler;
import org.coode.owlapi.owlxmlparser.AbstractOWLElementHandler;
import org.coode.owlapi.owlxmlparser.OWLAnnotationElementHandler;
import org.coode.owlapi.owlxmlparser.OWLElementHandler;
import org.coode.owlapi.owlxmlparser.OWLXMLParserException;
import org.coode.owlapi.owlxmlparser.OWLXMLParserHandler;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OWLOntologyHandler
extends AbstractOWLElementHandler<OWLOntology> {
    public OWLOntologyHandler(OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String name) throws OWLXMLParserException {
    }

    @Override
    public void attribute(String name, String value) throws OWLParserException {
        OWLOntologyID newID;
        if (name.equals("ontologyIRI")) {
            newID = new OWLOntologyID(IRI.create(value), this.getOntology().getOntologyID().getVersionIRI());
            this.getOWLOntologyManager().applyChange(new SetOntologyID(this.getOntology(), newID));
        }
        if (name.equals("versionIRI")) {
            newID = new OWLOntologyID(this.getOntology().getOntologyID().getOntologyIRI(), IRI.create(value));
            this.getOWLOntologyManager().applyChange(new SetOntologyID(this.getOntology(), newID));
        }
    }

    @Override
    public void handleChild(AbstractOWLAxiomElementHandler handler) throws OWLXMLParserException {
        OWLAxiom axiom = handler.getOWLObject();
        if (!axiom.isAnnotationAxiom() || this.getConfiguration().isLoadAnnotationAxioms()) {
            this.getOWLOntologyManager().applyChange(new AddAxiom(this.getOntology(), axiom));
        }
    }

    @Override
    public void handleChild(AbstractOWLDataRangeHandler handler) throws OWLXMLParserException {
    }

    @Override
    public void handleChild(AbstractClassExpressionElementHandler handler) throws OWLXMLParserException {
    }

    @Override
    public void handleChild(OWLAnnotationElementHandler handler) throws OWLXMLParserException {
        this.getOWLOntologyManager().applyChange(new AddOntologyAnnotation(this.getOntology(), handler.getOWLObject()));
    }

    @Override
    public void endElement() throws OWLParserException, UnloadableImportException {
    }

    @Override
    public OWLOntology getOWLObject() {
        return this.getOntology();
    }

    @Override
    public void setParentHandler(OWLElementHandler<?> handler) {
    }
}

