/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class DefaultEdge
implements Edge {
    private Individual from;
    private Node to;
    private Role role;
    private DependencySet depends;

    public DefaultEdge(Role role, Individual individual, Node node) {
        this.role = role;
        this.from = individual;
        this.to = node;
    }

    public DefaultEdge(Role role, Individual individual, Node node, DependencySet dependencySet) {
        this.role = role;
        this.from = individual;
        this.to = node;
        this.depends = dependencySet;
    }

    @Override
    public Node getNeighbor(Node node) {
        if (this.from.equals(node)) {
            return this.to;
        }
        if (this.to.equals(node)) {
            return this.from;
        }
        return null;
    }

    public String toString() {
        return "[" + this.from + ", " + this.role + ", " + this.to + "] - " + this.depends;
    }

    @Override
    public DependencySet getDepends() {
        return this.depends;
    }

    @Override
    public Individual getFrom() {
        return this.from;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public Node getTo() {
        return this.to;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultEdge)) {
            return false;
        }
        DefaultEdge defaultEdge = (DefaultEdge)object;
        return this.from.equals(defaultEdge.from) && this.role.equals(defaultEdge.role) && this.to.equals(defaultEdge.to);
    }

    public int hashCode() {
        int n = 23;
        n = 31 * n + this.role.hashCode();
        n = 31 * n + this.from.hashCode();
        n = 31 * n + this.to.hashCode();
        return n;
    }

    @Override
    public ATermAppl getFromName() {
        return this.getFrom().getName();
    }

    @Override
    public ATermAppl getToName() {
        return this.getTo().getName();
    }

    @Override
    public void setDepends(DependencySet dependencySet) {
        this.depends = dependencySet;
    }
}

