/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.owlapiv3.PelletVisitor;
import com.clarkparsia.pellet.owlapiv3.ProgressAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.PelletRuntimeException;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.TimerInterruptedException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.VersionInfo;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class PelletReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final Logger log = Logger.getLogger(PelletReasoner.class.getName());
    private static final Set<InferenceType> PRECOMPUTABLE_INFERENCES = EnumSet.of(InferenceType.CLASS_HIERARCHY, InferenceType.CLASS_ASSERTIONS, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY);
    private static final Version VERSION = PelletReasoner.createVersion();
    private final OWLDataFactory factory;
    private KnowledgeBase kb;
    private final OWLOntologyManager manager;
    private final ReasonerProgressMonitor monitor;
    private final OWLOntology ontology;
    private Set<OWLOntology> importsClosure;
    private boolean shouldRefresh;
    private final PelletVisitor visitor;
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> pendingChanges;
    private final IndividualNodeSetPolicy individualNodeSetPolicy;
    private final ChangeVisitor changeVisitor = new ChangeVisitor();
    private final EntityMapper<OWLNamedIndividual> IND_MAPPER = new NamedIndividualMapper();
    private final EntityMapper<OWLLiteral> LIT_MAPPER = new LiteralMapper();
    private final EntityMapper<OWLObjectPropertyExpression> OP_MAPPER = new ObjectPropertyMapper();
    private final EntityMapper<OWLDataProperty> DP_MAPPER = new DataPropertyMapper();
    private final EntityMapper<OWLDatatype> DT_MAPPER = new DatatypeMapper();
    private final EntityMapper<OWLClass> CLASS_MAPPER = new ClassMapper();

    private static Version createVersion() {
        String string = VersionInfo.getInstance().getVersionString();
        String[] stringArray = string.split("\\.");
        int n = PelletReasoner.parseNumberIfExists(stringArray, 0);
        int n2 = PelletReasoner.parseNumberIfExists(stringArray, 1);
        int n3 = PelletReasoner.parseNumberIfExists(stringArray, 2);
        int n4 = PelletReasoner.parseNumberIfExists(stringArray, 3);
        return new Version(n, n2, n3, n4);
    }

    private static int parseNumberIfExists(String[] stringArray, int n) {
        try {
            if (0 <= n && n < stringArray.length) {
                return Integer.parseInt(stringArray[n]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.log(Level.FINE, "Invalid number in version identifier: " + stringArray[n], numberFormatException);
        }
        return 0;
    }

    private static IRI iri(ATermAppl aTermAppl) {
        if (aTermAppl.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + aTermAppl);
        }
        return IRI.create((String)aTermAppl.getName());
    }

    public PelletReasoner(OWLOntology oWLOntology, BufferingMode bufferingMode) {
        this(oWLOntology, (OWLReasonerConfiguration)new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW, 0L, IndividualNodeSetPolicy.BY_SAME_AS), bufferingMode);
    }

    public PelletReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration, BufferingMode bufferingMode) throws IllegalConfigurationException {
        this.individualNodeSetPolicy = oWLReasonerConfiguration.getIndividualNodeSetPolicy();
        if (!this.getFreshEntityPolicy().equals((Object)oWLReasonerConfiguration.getFreshEntityPolicy())) {
            throw new IllegalConfigurationException("PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING conflicts with reasoner configuration", oWLReasonerConfiguration);
        }
        this.ontology = oWLOntology;
        this.monitor = oWLReasonerConfiguration.getProgressMonitor();
        this.kb = new KnowledgeBase();
        this.kb.setTaxonomyBuilderProgressMonitor(new ProgressAdapter(this.monitor));
        if (oWLReasonerConfiguration.getTimeOut() > 0L) {
            this.kb.timers.mainTimer.setTimeout(oWLReasonerConfiguration.getTimeOut());
        }
        this.manager = oWLOntology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.visitor = new PelletVisitor(this.kb);
        this.bufferingMode = bufferingMode;
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.shouldRefresh = true;
        this.pendingChanges = new ArrayList<OWLOntologyChange>();
        this.refresh();
    }

    private PelletRuntimeException convert(PelletRuntimeException pelletRuntimeException) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (pelletRuntimeException instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (pelletRuntimeException instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)pelletRuntimeException);
        }
        if (pelletRuntimeException instanceof org.mindswap.pellet.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (pelletRuntimeException instanceof UndefinedEntityException) {
            Set set = Collections.emptySet();
            throw new FreshEntitiesException(set);
        }
        return pelletRuntimeException;
    }

    public void dispose() {
        this.kb = null;
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void flush() {
        this.processChanges(this.pendingChanges);
        this.pendingChanges.clear();
        this.refreshCheck();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getUnsatisfiableClasses();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_OBJECT_PROPERTY));
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl aTermAppl = ATermUtils.makeSomeValues((ATerm)this.term((OWLObject)oWLDataProperty), (ATerm)ATermUtils.TOP_LIT);
            Set<ATermAppl> set = this.kb.getEquivalentClasses(aTermAppl);
            if (bl && !set.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(set));
            }
            Set<Set<ATermAppl>> set2 = this.kb.getSuperClasses(aTermAppl, bl);
            if (!set.isEmpty()) {
                set2.add(set);
            }
            return this.toClassNodeSet(set2);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getDataPropertyValues(this.term((OWLObject)oWLDataProperty), this.term((OWLObject)oWLNamedIndividual)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Set<OWLLiteral> getAnnotationPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLAnnotationProperty oWLAnnotationProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getPropertyValues(this.term((OWLObject)oWLAnnotationProperty), this.term((OWLObject)oWLNamedIndividual)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getDifferents(this.term((OWLObject)oWLNamedIndividual)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> set = this.kb.getDisjointClasses(this.term((OWLObject)oWLClassExpression));
            return this.toClassNodeSet(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> hashSet = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> set : this.kb.getDisjointProperties(this.term((OWLObject)oWLDataPropertyExpression))) {
                hashSet.add(this.toDataPropertyNode(set));
            }
            return new OWLDataPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> hashSet = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> set : this.kb.getDisjointProperties(this.term((OWLObject)oWLObjectPropertyExpression))) {
                hashSet.add(this.toObjectPropertyNode(set));
            }
            return new OWLObjectPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getAllEquivalentClasses(this.term((OWLObject)oWLClassExpression)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(this.term((OWLObject)oWLDataProperty)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(this.term((OWLObject)oWLObjectPropertyExpression)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<ATermAppl> collection) {
        HashSet<Node<OWLNamedIndividual>> hashSet = new HashSet<Node<OWLNamedIndividual>>();
        HashSet<ATermAppl> hashSet2 = new HashSet<ATermAppl>();
        for (ATermAppl aTermAppl : collection) {
            if (hashSet2.contains(aTermAppl)) continue;
            Set<ATermAppl> set = this.kb.getAllSames(aTermAppl);
            hashSet.add(this.toIndividualNode(set));
            hashSet2.addAll(set);
        }
        return new OWLNamedIndividualNodeSet(hashSet);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<ATermAppl> collection) {
        HashSet<Node<OWLNamedIndividual>> hashSet = new HashSet<Node<OWLNamedIndividual>>();
        for (ATermAppl aTermAppl : collection) {
            for (ATermAppl aTermAppl2 : this.kb.getAllSames(aTermAppl)) {
                hashSet.add(this.toIndividualNode(aTermAppl2));
            }
        }
        return new OWLNamedIndividualNodeSet(hashSet);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<ATermAppl> collection) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetByName(collection);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetBySameAs(collection);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.individualNodeSetPolicy));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getInstances(this.term((OWLObject)oWLClassExpression), bl));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getInverses((ATerm)this.term((OWLObject)oWLObjectPropertyExpression)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl aTermAppl = ATermUtils.makeSomeValues((ATerm)this.term((OWLObject)oWLObjectPropertyExpression), (ATerm)ATermUtils.TOP);
            Set<ATermAppl> set = this.kb.getEquivalentClasses(aTermAppl);
            if (bl && !set.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(set));
            }
            Set<Set<ATermAppl>> set2 = this.kb.getSuperClasses(aTermAppl, bl);
            if (!set.isEmpty()) {
                set2.add(set);
            }
            return this.toClassNodeSet(set2);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl aTermAppl = ATermUtils.makeSomeValues((ATerm)ATermUtils.makeInv(this.term((OWLObject)oWLObjectPropertyExpression)), (ATerm)ATermUtils.TOP);
            Set<ATermAppl> set = this.kb.getEquivalentClasses(aTermAppl);
            if (bl && !set.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(set));
            }
            Set<Set<ATermAppl>> set2 = this.kb.getSuperClasses(aTermAppl, bl);
            if (!set.isEmpty()) {
                set2.add(set);
            }
            return this.toClassNodeSet(set2);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getObjectPropertyValues(this.term((OWLObject)oWLObjectPropertyExpression), this.term((OWLObject)oWLNamedIndividual)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges;
    }

    public String getReasonerName() {
        return PelletReasonerFactory.getInstance().getReasonerName();
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toIndividualNode(this.kb.getAllSames(this.term((OWLObject)oWLNamedIndividual)));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> set = this.kb.getSubClasses(this.term((OWLObject)oWLClassExpression), bl);
            return this.toClassNodeSet(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> hashSet = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> set : this.kb.getSubProperties(this.term((OWLObject)oWLDataProperty), bl)) {
                hashSet.add(this.toDataPropertyNode(set));
            }
            return new OWLDataPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> hashSet = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> set : this.kb.getSubProperties(this.term((OWLObject)oWLObjectPropertyExpression), bl)) {
                hashSet.add(this.toObjectPropertyNode(set));
            }
            return new OWLObjectPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> set = this.kb.getSuperClasses(this.term((OWLObject)oWLClassExpression), bl);
            return this.toClassNodeSet(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> hashSet = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> set : this.kb.getSuperProperties(this.term((OWLObject)oWLDataProperty), bl)) {
                hashSet.add(this.toDataPropertyNode(set));
            }
            return new OWLDataPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> hashSet = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> set : this.kb.getSuperProperties(this.term((OWLObject)oWLObjectPropertyExpression), bl)) {
                hashSet.add(this.toObjectPropertyNode(set));
            }
            return new OWLObjectPropertyNodeSet(hashSet);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public long getTimeOut() {
        return this.kb.timers.mainTimer.getTimeout();
    }

    public Node<OWLClass> getTopClassNode() {
        this.refreshCheck();
        return this.toClassNode(this.kb.getAllEquivalentClasses(ATermUtils.TOP));
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_OBJECT_PROPERTY));
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> set = this.kb.getTypes(this.term((OWLObject)oWLNamedIndividual), bl);
            return this.toClassNodeSet(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getAllUnsatisfiableClasses());
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public void interrupt() {
        this.kb.timers.interrupt();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.kb.isConsistent();
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public boolean isEntailed(OWLAxiom oWLAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.isEntailed(Collections.singleton(oWLAxiom));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(set);
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !EntailmentChecker.UNSUPPORTED_ENTAILMENT.contains(axiomType);
    }

    public boolean isSatisfiable(OWLClassExpression oWLClassExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.kb.isSatisfiable(this.term((OWLObject)oWLClassExpression));
        }
        catch (PelletRuntimeException pelletRuntimeException) {
            throw this.convert(pelletRuntimeException);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
        switch (this.bufferingMode) {
            case BUFFERING: {
                this.pendingChanges.addAll(list);
                break;
            }
            case NON_BUFFERING: {
                this.processChanges(list);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected buffering mode: " + this.bufferingMode));
            }
        }
    }

    public boolean processChanges(List<? extends OWLOntologyChange> list) {
        if (this.shouldRefresh) {
            return false;
        }
        for (OWLOntologyChange oWLOntologyChange : list) {
            if (log.isLoggable(Level.FINER)) {
                log.fine("Changed: " + oWLOntologyChange + " in " + oWLOntologyChange.getOntology());
            }
            if (!this.importsClosure.contains(oWLOntologyChange.getOntology()) || this.changeVisitor.process(oWLOntologyChange)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Reload required by ontology change " + oWLOntologyChange);
            }
            this.shouldRefresh = true;
            break;
        }
        return !this.shouldRefresh;
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        if (this.kb.isConsistent()) {
            this.kb.realize();
        }
    }

    public void refresh() {
        this.visitor.clear();
        this.kb.clear();
        this.importsClosure = this.ontology.getImportsClosure();
        this.visitor.setAddAxiom(true);
        for (OWLOntology oWLOntology : this.importsClosure) {
            oWLOntology.accept((OWLObjectVisitor)this.visitor);
        }
        this.visitor.verify();
        this.shouldRefresh = false;
    }

    private void refreshCheck() {
        if (this.kb == null) {
            throw new OWLRuntimeException("Trying to use a disposed reasoner");
        }
        if (this.shouldRefresh) {
            this.refresh();
        }
    }

    public ATermAppl term(OWLObject oWLObject) {
        this.refreshCheck();
        this.visitor.reset();
        this.visitor.setAddAxiom(false);
        oWLObject.accept((OWLObjectVisitor)this.visitor);
        ATermAppl aTermAppl = this.visitor.result();
        if (aTermAppl == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + oWLObject);
        }
        return aTermAppl;
    }

    private NodeSet<OWLClass> toClassNodeSet(Set<Set<ATermAppl>> set) {
        HashSet<Node<OWLClass>> hashSet = new HashSet<Node<OWLClass>>();
        for (Set<ATermAppl> set2 : set) {
            hashSet.add(this.toClassNode(set2));
        }
        return new OWLClassNodeSet(hashSet);
    }

    private Node<OWLClass> toClassNode(Set<ATermAppl> set) {
        return NodeFactory.getOWLClassNode(this.CLASS_MAPPER.map(set));
    }

    private Node<OWLDataProperty> toDataPropertyNode(Set<ATermAppl> set) {
        return NodeFactory.getOWLDataPropertyNode(this.DP_MAPPER.map(set));
    }

    private Node<OWLNamedIndividual> toIndividualNode(Set<ATermAppl> set) {
        return NodeFactory.getOWLNamedIndividualNode(this.IND_MAPPER.map(set));
    }

    private Set<OWLLiteral> toLiteralSet(Collection<ATermAppl> collection) {
        return this.LIT_MAPPER.map(collection);
    }

    private Node<OWLObjectPropertyExpression> toObjectPropertyNode(Set<ATermAppl> set) {
        return NodeFactory.getOWLObjectPropertyNode(this.OP_MAPPER.map(set));
    }

    private Node<OWLNamedIndividual> toIndividualNode(ATermAppl aTermAppl) {
        return NodeFactory.getOWLNamedIndividualNode((OWLNamedIndividual)this.IND_MAPPER.map(aTermAppl));
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return PRECOMPUTABLE_INFERENCES;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.kb.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.kb.isRealized();
            }
            case OBJECT_PROPERTY_HIERARCHY: {
                return this.kb.getRBox().isObjectTaxonomyPrepared();
            }
            case DATA_PROPERTY_HIERARCHY: {
                return this.kb.getRBox().isDataTaxonomyPrepared();
            }
        }
        return false;
    }

    public void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypeArray) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this.kb.classify();
                }
                case CLASS_ASSERTIONS: {
                    this.kb.realize();
                }
                case OBJECT_PROPERTY_HIERARCHY: {
                    this.kb.getRBox().getObjectTaxonomy();
                }
                case DATA_PROPERTY_HIERARCHY: {
                    this.kb.getRBox().getDataTaxonomy();
                }
            }
        }
    }

    private class ObjectPropertyMapper
    extends EntityMapper<OWLObjectPropertyExpression> {
        private ObjectPropertyMapper() {
        }

        @Override
        public OWLObjectPropertyExpression map(ATermAppl aTermAppl) {
            if (ATermUtils.TOP_OBJECT_PROPERTY.equals(aTermAppl)) {
                return PelletReasoner.this.factory.getOWLTopObjectProperty();
            }
            if (ATermUtils.BOTTOM_OBJECT_PROPERTY.equals(aTermAppl)) {
                return PelletReasoner.this.factory.getOWLBottomObjectProperty();
            }
            if (ATermUtils.isInv(aTermAppl)) {
                return PelletReasoner.this.factory.getOWLObjectInverseOf((OWLObjectPropertyExpression)PelletReasoner.this.OP_MAPPER.map(aTermAppl));
            }
            return PelletReasoner.this.factory.getOWLObjectProperty(PelletReasoner.iri(aTermAppl));
        }
    }

    private class NamedIndividualMapper
    extends EntityMapper<OWLNamedIndividual> {
        private NamedIndividualMapper() {
        }

        @Override
        public OWLNamedIndividual map(ATermAppl aTermAppl) {
            if (ATermUtils.isBnode(aTermAppl)) {
                return null;
            }
            return PelletReasoner.this.factory.getOWLNamedIndividual(PelletReasoner.iri(aTermAppl));
        }
    }

    private class LiteralMapper
    extends EntityMapper<OWLLiteral> {
        private LiteralMapper() {
        }

        @Override
        public OWLLiteral map(ATermAppl aTermAppl) {
            String string = ((ATermAppl)aTermAppl.getArgument(0)).getName();
            ATermAppl aTermAppl2 = (ATermAppl)aTermAppl.getArgument(1);
            ATermAppl aTermAppl3 = (ATermAppl)aTermAppl.getArgument(2);
            if (aTermAppl3.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
                if (aTermAppl2.equals(ATermUtils.EMPTY)) {
                    return PelletReasoner.this.factory.getOWLLiteral(string);
                }
                return PelletReasoner.this.factory.getOWLLiteral(string, aTermAppl2.toString());
            }
            OWLDatatype oWLDatatype = (OWLDatatype)PelletReasoner.this.DT_MAPPER.map(aTermAppl3);
            return PelletReasoner.this.factory.getOWLLiteral(string, oWLDatatype);
        }
    }

    private abstract class EntityMapper<T extends OWLObject> {
        private EntityMapper() {
        }

        public abstract T map(ATermAppl var1);

        public final Set<T> map(Collection<ATermAppl> collection) {
            HashSet<T> hashSet = new HashSet<T>();
            for (ATermAppl aTermAppl : collection) {
                T t = this.map(aTermAppl);
                if (t == null) continue;
                hashSet.add(t);
            }
            return hashSet;
        }
    }

    private class DatatypeMapper
    extends EntityMapper<OWLDatatype> {
        private DatatypeMapper() {
        }

        @Override
        public OWLDatatype map(ATermAppl aTermAppl) {
            return PelletReasoner.this.factory.getOWLDatatype(PelletReasoner.iri(aTermAppl));
        }
    }

    private class DataPropertyMapper
    extends EntityMapper<OWLDataProperty> {
        private DataPropertyMapper() {
        }

        @Override
        public OWLDataProperty map(ATermAppl aTermAppl) {
            if (ATermUtils.TOP_DATA_PROPERTY.equals(aTermAppl)) {
                return PelletReasoner.this.factory.getOWLTopDataProperty();
            }
            if (ATermUtils.BOTTOM_DATA_PROPERTY.equals(aTermAppl)) {
                return PelletReasoner.this.factory.getOWLBottomDataProperty();
            }
            return PelletReasoner.this.factory.getOWLDataProperty(PelletReasoner.iri(aTermAppl));
        }
    }

    private class ClassMapper
    extends EntityMapper<OWLClass> {
        private ClassMapper() {
        }

        @Override
        public OWLClass map(ATermAppl aTermAppl) {
            if (aTermAppl.equals(ATermUtils.TOP)) {
                return PelletReasoner.this.factory.getOWLThing();
            }
            if (aTermAppl.equals(ATermUtils.BOTTOM)) {
                return PelletReasoner.this.factory.getOWLNothing();
            }
            return PelletReasoner.this.factory.getOWLClass(PelletReasoner.iri(aTermAppl));
        }
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        public boolean process(OWLOntologyChange oWLOntologyChange) {
            this.reset();
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletReasoner.this.visitor.reset();
            this.reloadRequired = false;
        }

        public void visit(AddAxiom addAxiom) {
            PelletReasoner.this.visitor.setAddAxiom(true);
            addAxiom.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(RemoveAxiom removeAxiom) {
            PelletReasoner.this.visitor.setAddAxiom(false);
            removeAxiom.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(AddImport addImport) {
            this.reloadRequired = true;
        }

        public void visit(AddOntologyAnnotation addOntologyAnnotation) {
        }

        public void visit(RemoveImport removeImport) {
            this.reloadRequired = true;
        }

        public void visit(RemoveOntologyAnnotation removeOntologyAnnotation) {
        }

        public void visit(SetOntologyID setOntologyID) {
        }
    }
}

