/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ConvertSuperClassesToEquivalentClass
extends AbstractCompositeOntologyChange {
    private final OWLOntology targetOntology;
    private final OWLClass cls;
    private final Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public ConvertSuperClassesToEquivalentClass(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        this.targetOntology = targetOntology;
        this.cls = cls;
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(this.cls)) {
                this.changes.add(new RemoveAxiom(ont, ax));
                descs.add(ax.getSuperClass());
            }
        }
        OWLObjectIntersectionOf equivalentClass = this.getDataFactory().getOWLObjectIntersectionOf(descs);
        HashSet<OWLClassExpression> equivalentClasses = new HashSet<OWLClassExpression>();
        equivalentClasses.add(this.cls);
        equivalentClasses.add(equivalentClass);
        this.changes.add(new AddAxiom(this.targetOntology, this.getDataFactory().getOWLEquivalentClassesAxiom(equivalentClasses)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

